/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;

public class GridFileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dst, long maxBytes) throws IOException {
        boolean err = true;
        try (FileChannel dstChannel = FileChannel.open(dst.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
             FileChannel srcChannel = FileChannel.open(src.toPath(), StandardOpenOption.READ);){
            long writtenBytes;
            long limit = Math.min(srcChannel.size(), maxBytes);
            for (long position = 0L; position < limit; position += writtenBytes, limit -= writtenBytes) {
                writtenBytes = srcChannel.transferTo(position, limit, dstChannel);
            }
            err = false;
        }
        finally {
            if (err) {
                dst.delete();
            }
        }
    }
}

