/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.command;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.processors.bulkload.BulkLoadAckClientParameters;
import org.apache.ignite.internal.processors.bulkload.BulkLoadCsvFormat;
import org.apache.ignite.internal.processors.bulkload.BulkLoadFormat;
import org.apache.ignite.internal.processors.bulkload.BulkLoadIcebergFormat;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocation;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocationFile;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocationQuery;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocationTable;
import org.apache.ignite.internal.processors.bulkload.BulkLoadParquetFormat;
import org.apache.ignite.internal.sql.SqlKeyword;
import org.apache.ignite.internal.sql.SqlLexer;
import org.apache.ignite.internal.sql.SqlLexerToken;
import org.apache.ignite.internal.sql.SqlLexerTokenType;
import org.apache.ignite.internal.sql.SqlParserUtils;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlQualifiedName;
import org.apache.ignite.internal.util.typedef.internal.S;

public class SqlBulkLoadCommand
implements SqlCommand {
    private BulkLoadLocation from;
    private BulkLoadLocation into;
    private BulkLoadFormat format;
    private Integer packetSize;
    private Map<String, String> properties;

    @Override
    public SqlCommand parse(SqlLexer lex) {
        this.parseLocations(lex);
        this.parseFormat(lex);
        this.parseParameters(lex);
        this.properties = SqlBulkLoadCommand.parseProperties(lex);
        return this;
    }

    private void parseLocations(SqlLexer lex) {
        for (int i = 0; i < 2; ++i) {
            lex.shift();
            if (SqlParserUtils.matchesKeyword(lex, "FROM")) {
                this.from = SqlBulkLoadCommand.parseLocation(lex);
                continue;
            }
            if (SqlParserUtils.matchesKeyword(lex, "INTO")) {
                this.into = SqlBulkLoadCommand.parseLocation(lex);
                continue;
            }
            throw SqlParserUtils.errorUnexpectedToken(lex, "FROM", "INTO");
        }
        if (this.from == null || this.into == null) {
            throw SqlParserUtils.error(lex, "(expected both locations: \"FROM\", \"INTO\")");
        }
    }

    private static BulkLoadLocation parseLocation(SqlLexer lex) {
        SqlLexerToken lookAhead = lex.lookAhead();
        if (SqlKeyword.isKeyword(lookAhead.token())) {
            throw SqlParserUtils.errorUnexpectedToken(lookAhead, "[file name: string]", new String[0]);
        }
        if (lookAhead.tokenType() == SqlLexerTokenType.STRING) {
            String locFileName = SqlBulkLoadCommand.parseFileName(lex);
            return new BulkLoadLocationFile().path(locFileName);
        }
        if (lookAhead.tokenType() == SqlLexerTokenType.PARENTHESIS_LEFT) {
            String sql = SqlBulkLoadCommand.parseQuery(lex);
            return new BulkLoadLocationQuery().sql(sql);
        }
        if (!SqlKeyword.isKeyword(lookAhead.token())) {
            SqlQualifiedName tblQName = SqlBulkLoadCommand.parseTableName(lex);
            List<String> cols = SqlBulkLoadCommand.parseColumns(lex);
            return new BulkLoadLocationTable().tableQualifiedName(tblQName).columns(cols);
        }
        throw SqlParserUtils.errorUnexpectedToken(lookAhead, "[location: 'file', table_name (col_name), (query)]", new String[0]);
    }

    private static String parseFileName(SqlLexer lex) {
        if (lex.lookAhead().tokenType() != SqlLexerTokenType.STRING) {
            throw SqlParserUtils.errorUnexpectedToken(lex.lookAhead(), "[file name: string]", new String[0]);
        }
        lex.shift();
        return lex.token();
    }

    private static SqlQualifiedName parseTableName(SqlLexer lex) {
        return SqlParserUtils.parseQualifiedIdentifier(lex, new String[0]);
    }

    private static List<String> parseColumns(SqlLexer lex) {
        SqlParserUtils.skipIfMatches(lex, SqlLexerTokenType.PARENTHESIS_LEFT);
        ArrayList<String> cols = new ArrayList<String>();
        do {
            cols.add(SqlBulkLoadCommand.parseColumn(lex));
        } while (!SqlParserUtils.skipCommaOrRightParenthesis(lex));
        return cols;
    }

    private static String parseColumn(SqlLexer lex) {
        return SqlParserUtils.parseIdentifier(lex, new String[0]);
    }

    private static String parseQuery(SqlLexer lex) {
        if (lex.lookAhead().tokenType() != SqlLexerTokenType.PARENTHESIS_LEFT) {
            throw SqlParserUtils.errorUnexpectedToken(lex.lookAhead(), "[query: parenthesis]", new String[0]);
        }
        lex.shift();
        ArrayDeque<SqlLexerTokenType> stack = new ArrayDeque<SqlLexerTokenType>();
        stack.push(lex.tokenType());
        int startInclusive = lex.position();
        do {
            lex.shift();
            SqlLexerTokenType tokenType = lex.tokenType();
            if (tokenType == SqlLexerTokenType.PARENTHESIS_LEFT) {
                stack.push(tokenType);
                continue;
            }
            if (tokenType != SqlLexerTokenType.PARENTHESIS_RIGHT) continue;
            stack.pop();
        } while (!stack.isEmpty() && !lex.eod());
        int endExclusive = lex.tokenPosition();
        if (!stack.isEmpty()) {
            throw SqlParserUtils.errorUnexpectedToken(lex.lookAhead(), "[query: parenthesis]", new String[0]);
        }
        return lex.sql().substring(startInclusive, endExclusive);
    }

    private void parseFormat(SqlLexer lex) {
        SqlParserUtils.skipIfMatchesKeyword(lex, "FORMAT");
        String name = SqlParserUtils.parseIdentifier(lex, new String[0]);
        switch (name.toUpperCase()) {
            case "CSV": {
                BulkLoadCsvFormat fmt = new BulkLoadCsvFormat();
                fmt.lineSeparator(BulkLoadCsvFormat.DEFAULT_LINE_SEPARATOR);
                fmt.fieldSeparator(",");
                fmt.quoteChars("\"");
                fmt.commentChars(BulkLoadCsvFormat.DEFAULT_COMMENT_CHARS);
                fmt.escapeChars(BulkLoadCsvFormat.DEFAULT_ESCAPE_CHARS);
                fmt.nullString("");
                fmt.trim(true);
                fmt.inputCharsetName(BulkLoadCsvFormat.DFLT_INPUT_CHARSET.toString());
                this.parseCsvOptions(lex, fmt);
                this.validateCsvParserFormat(lex, fmt);
                this.format = fmt;
                break;
            }
            case "PARQUET": {
                BulkLoadParquetFormat parquetFormat = new BulkLoadParquetFormat();
                this.parseParquetOptions(lex, parquetFormat);
                this.format = parquetFormat;
                break;
            }
            case "ICEBERG": {
                this.format = new BulkLoadIcebergFormat();
                break;
            }
            default: {
                throw SqlParserUtils.error(lex, "Unknown format name: " + name);
            }
        }
    }

    private void parseCsvOptions(SqlLexer lex, BulkLoadCsvFormat format) {
        block14: while (lex.lookAhead().tokenType() == SqlLexerTokenType.DEFAULT) {
            switch (lex.lookAhead().token()) {
                case "CHARSET": {
                    lex.shift();
                    String charsetName = SqlParserUtils.parseString(lex, new String[0]);
                    format.inputCharsetName(charsetName);
                    continue block14;
                }
                case "DELIMITER": {
                    lex.shift();
                    String delimiter = SqlParserUtils.parseString(lex, new String[0]);
                    format.fieldSeparator(delimiter);
                    continue block14;
                }
                case "TRIM": {
                    lex.shift();
                    Boolean trim = SqlParserUtils.parseBoolean(lex);
                    format.trim(trim);
                    continue block14;
                }
                case "NULLSTRING": {
                    lex.shift();
                    String nullString = SqlParserUtils.parseString(lex, new String[0]);
                    format.nullString(nullString);
                    continue block14;
                }
                case "HEADER": {
                    lex.shift();
                    format.header(true);
                    continue block14;
                }
            }
            return;
        }
    }

    private void parseParquetOptions(SqlLexer lex, BulkLoadParquetFormat format) {
        block6: while (lex.lookAhead().tokenType() == SqlLexerTokenType.DEFAULT) {
            switch (lex.lookAhead().token()) {
                case "PATTERN": {
                    lex.shift();
                    String pattern = SqlParserUtils.parseString(lex, new String[0]);
                    format.pattern(pattern);
                    continue block6;
                }
            }
            return;
        }
    }

    private void parseParameters(SqlLexer lex) {
        block6: while (lex.lookAhead().tokenType() == SqlLexerTokenType.DEFAULT) {
            switch (lex.lookAhead().token()) {
                case "PACKET_SIZE": {
                    lex.shift();
                    int size = SqlParserUtils.parseInt(lex);
                    if (!BulkLoadAckClientParameters.isValidPacketSize(size)) {
                        throw SqlParserUtils.error(lex, BulkLoadAckClientParameters.packetSizeErrorMesssage(size));
                    }
                    this.packetSize = size;
                    continue block6;
                }
            }
            return;
        }
    }

    private static Map<String, String> parseProperties(SqlLexer lex) {
        if (!"PROPERTIES".equals(lex.lookAhead().token())) {
            return Collections.emptyMap();
        }
        SqlParserUtils.skipIfMatchesKeyword(lex, "PROPERTIES");
        SqlParserUtils.skipIfMatches(lex, SqlLexerTokenType.PARENTHESIS_LEFT);
        HashMap<String, String> props = new HashMap<String, String>();
        do {
            if (lex.lookAhead().tokenType() == SqlLexerTokenType.PARENTHESIS_RIGHT) continue;
            String key = lex.lookAhead().token();
            lex.shift();
            SqlParserUtils.skipIfMatchesKeyword(lex, "=");
            String value = lex.lookAhead().token();
            lex.shift();
            props.put(key, value);
        } while (!SqlParserUtils.skipCommaOrRightParenthesis(lex));
        lex.shift();
        return Collections.unmodifiableMap(props);
    }

    private void validateCsvParserFormat(SqlLexer lex, BulkLoadCsvFormat format) {
        String delimiter = format.fieldSeparator().toString();
        String quoteChars = format.quoteChars();
        if (delimiter.length() > 1 || quoteChars.length() > 1) {
            throw SqlParserUtils.error(lex, "Delimiter or quote chars must consist of single character: delim is '" + delimiter + "', quote char is '" + quoteChars + "'");
        }
        if (delimiter.equals(quoteChars)) {
            throw SqlParserUtils.error(lex, "Invalid delimiter or quote chars: delim is '" + delimiter + "', quote char is '" + quoteChars + "'");
        }
    }

    @Override
    public String schemaName() {
        return null;
    }

    @Override
    public void schemaName(String schemaName) {
        if (this.from instanceof BulkLoadLocationTable && null == ((BulkLoadLocationTable)this.from).schemaName()) {
            ((BulkLoadLocationTable)this.from).qualifiedName().schemaName(schemaName, true);
        }
        if (this.into instanceof BulkLoadLocationTable && null == ((BulkLoadLocationTable)this.into).schemaName()) {
            ((BulkLoadLocationTable)this.into).qualifiedName().schemaName(schemaName, true);
        }
    }

    public BulkLoadFormat format() {
        return this.format;
    }

    public Integer packetSize() {
        return this.packetSize;
    }

    public void packetSize(int packetSize) {
        this.packetSize = packetSize;
    }

    public BulkLoadLocation from() {
        return this.from;
    }

    public BulkLoadLocation into() {
        return this.into;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public String toString() {
        return S.toString(SqlBulkLoadCommand.class, this);
    }
}

