/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.aware;

import org.apache.ignite.internal.util.typedef.internal.S;

public class IndexBuildStatusHolder {
    private final boolean persistent;
    private Status status;
    private boolean rebuild;
    private int newIdx;

    public IndexBuildStatusHolder(boolean persistent, boolean rebuild) {
        this.persistent = persistent;
        this.onStartOperation(rebuild);
    }

    public synchronized void onStartOperation(boolean rebuild) {
        this.status = Status.INIT;
        if (rebuild) {
            this.rebuild = true;
        } else {
            assert (this.newIdx >= 0);
            ++this.newIdx;
        }
    }

    public synchronized Status onFinishOperation(boolean rebuild) {
        if (rebuild) {
            this.rebuild = false;
        } else {
            assert (this.newIdx > 0);
            --this.newIdx;
        }
        if (!this.rebuild && this.newIdx == 0) {
            this.status = Status.COMPLETE;
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        if (this.persistent) {
            IndexBuildStatusHolder indexBuildStatusHolder = this;
            synchronized (indexBuildStatusHolder) {
                if (this.status == Status.COMPLETE) {
                    this.status = Status.DELETE;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public synchronized Status status() {
        return this.status;
    }

    public synchronized boolean rebuild() {
        return this.rebuild;
    }

    public synchronized int buildNewIndexes() {
        return this.newIdx;
    }

    public boolean persistent() {
        return this.persistent;
    }

    public synchronized String toString() {
        return S.toString(IndexBuildStatusHolder.class, this);
    }

    public static enum Status {
        INIT,
        COMPLETE,
        DELETE;

    }
}

