/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.internal.processors.query.QueryCancellable;

public class GridQueryCancel {
    private final List<QueryCancellable> cancelActions = new ArrayList<QueryCancellable>(3);
    private boolean canceled;
    private boolean last;
    private boolean multiStatement;

    public synchronized void add(QueryCancellable clo) throws QueryCancelledException {
        assert (clo != null);
        if (this.canceled) {
            throw new QueryCancelledException();
        }
        this.cancelActions.add(clo);
    }

    public void last(boolean lastQuery) {
        assert (this.multiStatement) : "unexpected last flag";
        this.last = lastQuery;
    }

    public boolean last() {
        return this.last;
    }

    public void multiStatement(boolean multi) {
        this.multiStatement = multi;
    }

    public boolean multiStatement() {
        return this.multiStatement;
    }

    public synchronized void cancel() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        Throwable ex = null;
        for (int i = this.cancelActions.size() - 1; i >= 0; --i) {
            try {
                QueryCancellable act = this.cancelActions.get(i);
                act.doCancel();
                continue;
            }
            catch (Exception e) {
                if (ex == null) {
                    ex = new IgniteException(e);
                    continue;
                }
                ex.addSuppressed(e);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public synchronized void checkCancelled() throws QueryCancelledException {
        if (this.canceled) {
            throw new QueryCancelledException();
        }
    }
}

