/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.tx;

import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientIntResponse;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxContext;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public class ClientTxStartRequest
extends ClientRequest {
    private final TransactionConcurrency concurrency;
    private final TransactionIsolation isolation;
    private final long timeout;
    private final String lb;

    public ClientTxStartRequest(BinaryRawReader reader) {
        super(reader);
        this.concurrency = TransactionConcurrency.fromOrdinal(reader.readByte());
        this.isolation = TransactionIsolation.fromOrdinal(reader.readByte());
        this.timeout = reader.readLong();
        this.lb = reader.readString();
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        GridNearTxLocal tx;
        ctx.kernalContext().gateway().readLock();
        try {
            tx = ctx.kernalContext().cache().context().tm().newTx(false, false, null, this.concurrency, this.isolation, this.timeout, true, null, 0, this.lb);
        }
        finally {
            ctx.kernalContext().gateway().readUnlock();
        }
        try {
            tx.suspend();
            int txId = ctx.nextTxId();
            ctx.addTxContext(new ClientTxContext(txId, tx));
            return new ClientIntResponse(this.requestId(), txId);
        }
        catch (Exception e) {
            try {
                tx.close();
            }
            catch (Exception e1) {
                e.addSuppressed(e1);
            }
            throw e instanceof IgniteClientException ? (IgniteClientException)e : new IgniteClientException(1, e.getMessage(), e);
        }
    }
}

