/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.odbc.SqlListenerUtils;
import org.apache.ignite.internal.processors.platform.client.ClientProtocolContext;
import org.jetbrains.annotations.Nullable;

public class ClientSqlUtils {
    @Nullable
    public static Object[] readQueryArgs(BinaryRawReaderEx reader, ClientProtocolContext protoCtx) {
        int cnt = reader.readInt();
        if (cnt > 0) {
            Object[] args = new Object[cnt];
            for (int i = 0; i < cnt; ++i) {
                args[i] = ClientSqlUtils.readSqlField(reader, protoCtx);
            }
            return args;
        }
        return null;
    }

    @Nullable
    public static Object readSqlField(BinaryRawReaderEx reader, ClientProtocolContext protoCtx) throws BinaryObjectException {
        BinaryReaderExImpl reader0 = (BinaryReaderExImpl)reader;
        TimeZone serverTz = TimeZone.getDefault();
        TimeZone clientTz = protoCtx.clientTimeZone();
        byte type = reader0.readByte();
        switch (type) {
            case 11: {
                return new java.sql.Date(SqlListenerUtils.convertWithTimeZone(BinaryUtils.doReadDate(reader0.in()), clientTz, serverTz).getTime());
            }
            case 36: {
                return SqlListenerUtils.convertWithTimeZone(BinaryUtils.doReadTime(reader0.in()), clientTz, serverTz);
            }
            case 33: {
                return SqlListenerUtils.convertWithTimeZone(BinaryUtils.doReadTimestamp(reader0.in()), clientTz, serverTz);
            }
        }
        reader0.in().position(reader0.in().position() - 1);
        return reader0.readObjectDetached();
    }

    public static void writeSqlField(BinaryRawWriterEx writer, @Nullable Object obj, ClientProtocolContext protoCtx) throws BinaryObjectException {
        Class<?> cls = obj == null ? null : obj.getClass();
        TimeZone serverTz = TimeZone.getDefault();
        TimeZone clientTz = protoCtx.clientTimeZone();
        if (cls == java.sql.Date.class || cls == Date.class) {
            writer.writeDate(SqlListenerUtils.convertWithTimeZone((Date)obj, serverTz, clientTz));
        } else if (cls == Time.class) {
            writer.writeTime(SqlListenerUtils.convertWithTimeZone((Time)obj, serverTz, clientTz));
        } else if (cls == Timestamp.class) {
            writer.writeTimestamp(SqlListenerUtils.convertWithTimeZone((Timestamp)obj, serverTz, clientTz));
        } else {
            writer.writeObjectDetached(obj);
        }
    }
}

