/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRawBinarylizable;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class JdbcResponse
extends ClientListenerResponse
implements JdbcRawBinarylizable {
    @GridToStringInclude
    private JdbcResult res;
    private boolean activeTx;
    private AffinityTopologyVersion affinityVer;

    public JdbcResponse() {
        super(-1, null);
    }

    public JdbcResponse(JdbcResult res) {
        super(0, null);
        this.res = res;
    }

    public JdbcResponse(JdbcResult res, @Nullable AffinityTopologyVersion affinityVer) {
        this(res);
        this.affinityVer = affinityVer;
    }

    public JdbcResponse(int status, @Nullable String err) {
        super(status, err);
        assert (status != 0);
    }

    public JdbcResult response() {
        return this.res;
    }

    public AffinityTopologyVersion affinityVersion() {
        return this.affinityVer;
    }

    public boolean activeTransaction() {
        return this.activeTx;
    }

    public void activeTransaction(boolean activeTx) {
        this.activeTx = activeTx;
    }

    public String toString() {
        return S.toString(JdbcResponse.class, this, "status", (Object)this.status(), "err", (Object)this.error());
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        writer.writeInt(this.status());
        if (this.status() == 0) {
            writer.writeBoolean(this.res != null);
            if (this.res != null) {
                this.res.writeBinary(writer, protoCtx);
            }
        } else {
            writer.writeString(this.error());
        }
        if (protoCtx.isAffinityAwarenessSupported()) {
            writer.writeBoolean(this.activeTx);
            writer.writeBoolean(this.affinityVer != null);
            if (this.affinityVer != null) {
                writer.writeLong(this.affinityVer.topologyVersion());
                writer.writeInt(this.affinityVer.minorTopologyVersion());
            }
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        this.status(reader.readInt());
        if (this.status() == 0) {
            if (reader.readBoolean()) {
                this.res = JdbcResult.readResult(reader, protoCtx);
            }
        } else {
            this.error(reader.readString());
        }
        try {
            if (protoCtx.isAffinityAwarenessSupported()) {
                this.activeTx = reader.readBoolean();
                boolean affinityVerChanged = reader.readBoolean();
                if (affinityVerChanged) {
                    long topVer = reader.readLong();
                    int minorTopVer = reader.readInt();
                    this.affinityVer = new AffinityTopologyVersion(topVer, minorTopVer);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

