/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.io.IOException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcStatementType;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcThinFeature;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcUtils;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class JdbcQueryExecuteRequest
extends JdbcRequest {
    private String schemaName;
    private int pageSize;
    private int maxRows;
    @GridToStringInclude(sensitive=true)
    private String sqlQry;
    @GridToStringInclude(sensitive=true)
    private Object[] args;
    private JdbcStatementType stmtType;
    private boolean autoCommit;
    private boolean partResReq;
    private boolean explicitTimeout;

    JdbcQueryExecuteRequest() {
        super((byte)2);
        this.autoCommit = true;
    }

    public JdbcQueryExecuteRequest(JdbcStatementType stmtType, String schemaName, int pageSize, int maxRows, boolean autoCommit, boolean explicitTimeout, String sqlQry, Object[] args) {
        super((byte)2);
        this.schemaName = F.isEmpty(schemaName) ? null : schemaName;
        this.pageSize = pageSize;
        this.maxRows = maxRows;
        this.sqlQry = sqlQry;
        this.args = args;
        this.stmtType = stmtType;
        this.autoCommit = autoCommit;
        this.explicitTimeout = explicitTimeout;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public int maxRows() {
        return this.maxRows;
    }

    public String sqlQuery() {
        return this.sqlQry;
    }

    public Object[] arguments() {
        return this.args;
    }

    @Nullable
    public String schemaName() {
        return this.schemaName;
    }

    public JdbcStatementType expectedStatementType() {
        return this.stmtType;
    }

    boolean autoCommit() {
        return this.autoCommit;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.writeBinary(writer, protoCtx);
        writer.writeString(this.schemaName);
        writer.writeInt(this.pageSize);
        writer.writeInt(this.maxRows);
        writer.writeString(this.sqlQry);
        writer.writeInt(this.args == null ? 0 : this.args.length);
        if (this.args != null) {
            for (Object arg : this.args) {
                JdbcUtils.writeObject(writer, arg, protoCtx);
            }
        }
        if (protoCtx.isAutoCommitSupported()) {
            writer.writeBoolean(this.autoCommit);
        }
        writer.writeByte((byte)this.stmtType.ordinal());
        if (protoCtx.isAffinityAwarenessSupported()) {
            writer.writeBoolean(this.partResReq);
        }
        if (protoCtx.features().contains(JdbcThinFeature.QUERY_TIMEOUT)) {
            writer.writeBoolean(this.explicitTimeout);
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.readBinary(reader, protoCtx);
        this.schemaName = reader.readString();
        this.pageSize = reader.readInt();
        this.maxRows = reader.readInt();
        this.sqlQry = reader.readString();
        int argsNum = reader.readInt();
        this.args = new Object[argsNum];
        for (int i = 0; i < argsNum; ++i) {
            this.args[i] = JdbcUtils.readObject(reader, protoCtx);
        }
        if (protoCtx.isAutoCommitSupported()) {
            this.autoCommit = reader.readBoolean();
        }
        try {
            this.stmtType = reader.available() > 0 ? JdbcStatementType.fromOrdinal(reader.readByte()) : JdbcStatementType.ANY_STATEMENT_TYPE;
        }
        catch (IOException e) {
            throw new BinaryObjectException(e);
        }
        try {
            if (protoCtx.isAffinityAwarenessSupported()) {
                this.partResReq = reader.readBoolean();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (protoCtx.features().contains(JdbcThinFeature.QUERY_TIMEOUT)) {
            this.explicitTimeout = reader.readBoolean();
        }
    }

    public boolean partitionResponseRequest() {
        return this.partResReq;
    }

    public void partitionResponseRequest(boolean partResReq) {
        this.partResReq = partResReq;
    }

    public boolean explicitTimeout() {
        return this.explicitTimeout;
    }

    @Override
    public String toString() {
        return S.toString(JdbcQueryExecuteRequest.class, this, super.toString());
    }
}

