/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.continuous;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.processors.continuous.ContinuousRoutineInfo;
import org.apache.ignite.internal.processors.continuous.ContinuousRoutinesCommonDiscoveryData;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;

class ContinuousRoutinesInfo {
    private final Map<UUID, ContinuousRoutineInfo> startedRoutines = new HashMap<UUID, ContinuousRoutineInfo>();

    ContinuousRoutinesInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void collectGridNodeData(DiscoveryDataBag dataBag) {
        Map<UUID, ContinuousRoutineInfo> map = this.startedRoutines;
        synchronized (map) {
            if (!dataBag.commonDataCollectedFor(GridComponent.DiscoveryDataExchangeType.CONTINUOUS_PROC.ordinal())) {
                dataBag.addGridCommonData(GridComponent.DiscoveryDataExchangeType.CONTINUOUS_PROC.ordinal(), new ContinuousRoutinesCommonDiscoveryData(new ArrayList<ContinuousRoutineInfo>(this.startedRoutines.values())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<ContinuousRoutineInfo> collectJoiningNodeData(UUID joiningNodeId) {
        Map<UUID, ContinuousRoutineInfo> map = this.startedRoutines;
        synchronized (map) {
            ArrayList<ContinuousRoutineInfo> res = new ArrayList<ContinuousRoutineInfo>();
            for (ContinuousRoutineInfo info : this.startedRoutines.values()) {
                if (info.disconnected) {
                    info.sourceNodeId(joiningNodeId);
                }
                res.add(info);
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRoutineInfo(ContinuousRoutineInfo info) {
        Map<UUID, ContinuousRoutineInfo> map = this.startedRoutines;
        synchronized (map) {
            this.startedRoutines.put(info.routineId, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean routineExists(UUID routineId) {
        Map<UUID, ContinuousRoutineInfo> map = this.startedRoutines;
        synchronized (map) {
            return this.startedRoutines.containsKey(routineId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRoutine(UUID routineId) {
        Map<UUID, ContinuousRoutineInfo> map = this.startedRoutines;
        synchronized (map) {
            this.startedRoutines.remove(routineId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClientDisconnected(Collection<UUID> locRoutines) {
        Map<UUID, ContinuousRoutineInfo> map = this.startedRoutines;
        synchronized (map) {
            Iterator<Map.Entry<UUID, ContinuousRoutineInfo>> it = this.startedRoutines.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<UUID, ContinuousRoutineInfo> e = it.next();
                ContinuousRoutineInfo info = e.getValue();
                if (!locRoutines.contains(info.routineId)) {
                    it.remove();
                    continue;
                }
                info.onDisconnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onNodeFail(UUID nodeId) {
        Map<UUID, ContinuousRoutineInfo> map = this.startedRoutines;
        synchronized (map) {
            Iterator<Map.Entry<UUID, ContinuousRoutineInfo>> it = this.startedRoutines.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<UUID, ContinuousRoutineInfo> e = it.next();
                ContinuousRoutineInfo info = e.getValue();
                if (!info.autoUnsubscribe || !info.srcNodeId.equals(nodeId)) continue;
                it.remove();
            }
        }
    }

    public String toString() {
        return S.toString(ContinuousRoutinesInfo.class, this);
    }
}

