/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObjectUtils;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.verify.GridNotIdleException;
import org.apache.ignite.internal.processors.cache.verify.PartitionEntryHashRecord;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecord;
import org.apache.ignite.internal.processors.cache.verify.PartitionKey;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class CollectConflictPartitionKeysTask
extends ComputeTaskAdapter<PartitionKey, Map<PartitionHashRecord, List<PartitionEntryHashRecord>>> {
    private static final long serialVersionUID = 0L;
    @LoggerResource
    private IgniteLogger log;

    @Override
    @NotNull
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, PartitionKey partKey) throws IgniteException {
        HashMap<CollectPartitionEntryHashesJob, ClusterNode> jobs = new HashMap<CollectPartitionEntryHashesJob, ClusterNode>();
        for (ClusterNode node : subgrid) {
            jobs.put(new CollectPartitionEntryHashesJob(partKey), node);
        }
        return jobs;
    }

    @Override
    @Nullable
    public Map<PartitionHashRecord, List<PartitionEntryHashRecord>> reduce(List<ComputeJobResult> results) throws IgniteException {
        HashMap totalRes = new HashMap();
        for (ComputeJobResult computeJobResult : results) {
            Map nodeRes = (Map)computeJobResult.getData();
            totalRes.putAll(nodeRes);
        }
        HashSet commonEntries = null;
        for (List nodeEntryHashRecords : totalRes.values()) {
            HashSet set = new HashSet(nodeEntryHashRecords);
            if (commonEntries == null) {
                commonEntries = set;
                continue;
            }
            commonEntries.retainAll(set);
        }
        if (commonEntries == null) {
            return Collections.emptyMap();
        }
        HashMap<PartitionHashRecord, List<PartitionEntryHashRecord>> hashMap = new HashMap<PartitionHashRecord, List<PartitionEntryHashRecord>>();
        for (Map.Entry e : totalRes.entrySet()) {
            HashSet conflicts = new HashSet((Collection)e.getValue());
            conflicts.removeAll(commonEntries);
            if (conflicts.isEmpty()) continue;
            hashMap.put((PartitionHashRecord)e.getKey(), new ArrayList(conflicts));
        }
        return hashMap;
    }

    @Override
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
        ComputeJobResultPolicy superRes = super.result(res, rcvd);
        if (superRes == ComputeJobResultPolicy.FAILOVER) {
            superRes = ComputeJobResultPolicy.WAIT;
            this.log.warning("CollectPartitionEntryHashesJob failed on node [consistentId=" + res.getNode().consistentId() + "]", res.getException());
        }
        return superRes;
    }

    public static class CollectPartitionEntryHashesJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private IgniteEx ignite;
        @LoggerResource
        private IgniteLogger log;
        private PartitionKey partKey;

        private CollectPartitionEntryHashesJob(PartitionKey partKey) {
            this.partKey = partKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<PartitionHashRecord, List<PartitionEntryHashRecord>> execute() throws IgniteException {
            ArrayList<PartitionEntryHashRecord> partEntryHashRecords;
            long partSize;
            long updateCntrBefore;
            CacheGroupContext grpCtx = this.ignite.context().cache().cacheGroup(this.partKey.groupId());
            if (grpCtx == null) {
                return Collections.emptyMap();
            }
            this.partKey.groupName(grpCtx.cacheOrGroupName());
            GridDhtLocalPartition part = grpCtx.topology().localPartition(this.partKey.partitionId());
            if (part == null || !part.reserve()) {
                return Collections.emptyMap();
            }
            int partHash = 0;
            try {
                if (part.state() != GridDhtPartitionState.OWNING) {
                    Map<PartitionHashRecord, List<PartitionEntryHashRecord>> map = Collections.emptyMap();
                    return map;
                }
                updateCntrBefore = part.updateCounter();
                partSize = part.dataStore().fullSize();
                GridIterator<CacheDataRow> it = grpCtx.offheap().partitionIterator(part.id(), 1);
                partEntryHashRecords = new ArrayList<PartitionEntryHashRecord>();
                while (it.hasNextX()) {
                    CacheDataRow row = it.nextX();
                    partHash += row.key().hashCode();
                    int valHash = Arrays.hashCode(row.value().valueBytes(grpCtx.cacheObjectContext()));
                    partHash += valHash;
                    int cacheId = row.cacheId() == 0 ? grpCtx.groupId() : row.cacheId();
                    DynamicCacheDescriptor desc = this.ignite.context().cache().cacheDescriptor(cacheId);
                    assert (desc != null);
                    Object o = CacheObjectUtils.unwrapBinaryIfNeeded(grpCtx.cacheObjectContext(), row.key(), true, true);
                    partEntryHashRecords.add(new PartitionEntryHashRecord(cacheId, desc.cacheName(), row.key(), o.toString(), row.key().valueBytes(grpCtx.cacheObjectContext()), row.version(), valHash));
                }
                long updateCntrAfter = part.updateCounter();
                if (updateCntrBefore != updateCntrAfter) {
                    throw new GridNotIdleException("Cluster not idle. Modifications found in caches or groups: [grpName=" + grpCtx.cacheOrGroupName() + ", grpId=" + grpCtx.groupId() + ", partId=" + part.id() + "] changed during hash calculation [before=" + updateCntrBefore + ", after=" + updateCntrAfter + "]");
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Can't calculate partition hash " + this.partKey.toString(), e);
                Map<PartitionHashRecord, List<PartitionEntryHashRecord>> updateCntrAfter = Collections.emptyMap();
                return updateCntrAfter;
            }
            finally {
                part.release();
            }
            Object consId = this.ignite.context().discovery().localNode().consistentId();
            boolean isPrimary = part.primary(grpCtx.topology().readyTopologyVersion());
            PartitionHashRecord partHashRec = new PartitionHashRecord(this.partKey, isPrimary, consId, partHash, updateCntrBefore, partSize);
            HashMap<PartitionHashRecord, List<PartitionEntryHashRecord>> res = new HashMap<PartitionHashRecord, List<PartitionEntryHashRecord>>();
            res.put(partHashRec, partEntryHashRecords);
            return res;
        }
    }
}

