/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class TxDeadlock {
    private static final String KEY_PREFIX = "K";
    private static final String TX_PREFIX = "TX";
    private final Map<GridCacheVersion, Set<IgniteTxKey>> txLockedKeys;
    private final Map<IgniteTxKey, Set<GridCacheVersion>> txRequestedKeys;
    private final List<GridCacheVersion> cycle;
    private final Map<GridCacheVersion, T2<UUID, Long>> txs;

    public TxDeadlock(List<GridCacheVersion> cycle, Map<GridCacheVersion, T2<UUID, Long>> txs, Map<GridCacheVersion, Set<IgniteTxKey>> txLockedKeys, Map<IgniteTxKey, Set<GridCacheVersion>> txRequestedKeys) {
        this.cycle = cycle;
        this.txLockedKeys = txLockedKeys;
        this.txRequestedKeys = txRequestedKeys;
        this.txs = txs;
    }

    public List<GridCacheVersion> cycle() {
        return this.cycle;
    }

    public String toString(GridCacheSharedContext ctx) {
        assert (this.cycle != null && !this.cycle.isEmpty());
        assert (this.cycle.size() >= 3);
        LinkedHashMap keyLabels = U.newLinkedHashMap(this.cycle.size() - 1);
        LinkedHashMap txLabels = U.newLinkedHashMap(this.cycle.size() - 1);
        StringBuilder sb = new StringBuilder("\nDeadlock detected:\n\n");
        for (int i = this.cycle.size() - 1; i > 0; --i) {
            GridCacheVersion txId = this.cycle.get(i);
            Set<IgniteTxKey> keys = this.txLockedKeys.get(txId);
            for (IgniteTxKey key : keys) {
                Set<GridCacheVersion> txIds = this.txRequestedKeys.get(key);
                if (txIds == null || txIds.isEmpty()) continue;
                GridCacheVersion waitsTx = null;
                for (GridCacheVersion ver : txIds) {
                    if (!this.cycle.contains(ver)) continue;
                    waitsTx = ver;
                    break;
                }
                if (waitsTx == null) continue;
                sb.append(TxDeadlock.label(key, KEY_PREFIX, keyLabels)).append(": ").append(TxDeadlock.label(txId, TX_PREFIX, txLabels)).append(" holds lock, ").append(TxDeadlock.label(waitsTx, TX_PREFIX, txLabels)).append(" waits lock.\n");
            }
        }
        sb.append("\nTransactions:\n\n");
        for (Map.Entry e : txLabels.entrySet()) {
            T2<UUID, Long> tx = this.txs.get(e.getKey());
            sb.append((String)e.getValue()).append(" [txId=").append(e.getKey()).append(", nodeId=").append(tx.get1()).append(", threadId=").append(tx.get2()).append("]\n");
        }
        sb.append("\nKeys:\n\n");
        for (Map.Entry e : keyLabels.entrySet()) {
            IgniteTxKey txKey = (IgniteTxKey)e.getKey();
            GridToStringBuilder.SensitiveDataLogging sensitiveDataLogging = S.getSensitiveDataLogging();
            try {
                GridCacheContext cctx = ctx.cacheContext(txKey.cacheId());
                Object val = txKey.key().value(cctx.cacheObjectContext(), true);
                sb.append((String)e.getValue()).append(" [");
                if (sensitiveDataLogging == GridToStringBuilder.SensitiveDataLogging.PLAIN) {
                    sb.append("key=").append(val).append(", ");
                } else if (sensitiveDataLogging == GridToStringBuilder.SensitiveDataLogging.HASH) {
                    sb.append("key=").append(val == null ? "null" : Integer.valueOf(IgniteUtils.hash(val))).append(", ");
                }
                sb.append("cache=").append(cctx.name()).append("]\n");
            }
            catch (Exception ex) {
                sb.append("Unable to unmarshall deadlock information for key [key=").append((String)e.getValue()).append("]\n");
            }
        }
        return sb.toString();
    }

    private static <T> String label(T id, String prefix, Map<T, String> map) {
        String lb = map.get(id);
        if (lb == null) {
            lb = prefix + (map.size() + 1);
            map.put(id, lb);
        }
        return lb;
    }
}

