/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.query.CacheQueryFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryBean;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public abstract class GridCacheQueryFutureAdapter<K, V, R>
extends GridFutureAdapter<Collection<R>>
implements CacheQueryFuture<R>,
GridTimeoutObject {
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    protected static IgniteLogger log;
    private static final Object NULL;
    protected GridCacheContext<K, V> cctx;
    protected final GridCacheQueryBean qry;
    private final Collection<K> keys;
    private final Queue<Collection<R>> queue = new LinkedList<Collection<R>>();
    private final AtomicInteger cnt = new AtomicInteger();
    private Iterator<R> iter;
    private IgniteUuid timeoutId = IgniteUuid.randomUuid();
    private long startTime;
    private long endTime;
    protected boolean loc;

    protected GridCacheQueryFutureAdapter() {
        this.qry = null;
        this.keys = null;
    }

    protected GridCacheQueryFutureAdapter(GridCacheContext<K, V> cctx, GridCacheQueryBean qry, boolean loc) {
        this.cctx = cctx;
        this.qry = qry;
        this.loc = loc;
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, GridCacheQueryFutureAdapter.class);
        }
        this.startTime = U.currentTimeMillis();
        long timeout = qry.query().timeout();
        if (timeout > 0L) {
            this.endTime = this.startTime + timeout;
            if (this.endTime < 0L) {
                this.endTime = Long.MAX_VALUE;
            }
            cctx.time().addTimeoutObject(this);
        }
        this.keys = qry.query().enableDedup() ? new HashSet() : null;
    }

    public GridCacheQueryBean query() {
        return this.qry;
    }

    boolean fields() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onDone(Collection<R> res, Throwable err) {
        if (!super.onDone(res, err)) {
            return false;
        }
        this.cctx.time().removeTimeoutObject(this);
        GridCacheQueryFutureAdapter gridCacheQueryFutureAdapter = this;
        synchronized (gridCacheQueryFutureAdapter) {
            this.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onCancelled() {
        if (!super.onCancelled()) {
            return false;
        }
        this.cctx.time().removeTimeoutObject(this);
        GridCacheQueryFutureAdapter gridCacheQueryFutureAdapter = this;
        synchronized (gridCacheQueryFutureAdapter) {
            this.notifyAll();
        }
        return true;
    }

    @Override
    public R next() {
        try {
            R next = this.unmaskNull(this.internalIterator().next());
            this.cnt.decrementAndGet();
            return next;
        }
        catch (NoSuchElementException ignored) {
            return null;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
    }

    public abstract void awaitFirstPage() throws IgniteCheckedException;

    private void checkError() throws IgniteCheckedException {
        if (this.error() != null) {
            this.clear();
            throw U.cast(this.error());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<R> internalIterator() throws IgniteCheckedException {
        this.checkError();
        Iterator<R> it = null;
        while (it == null || !it.hasNext()) {
            Collection<R> c;
            GridCacheQueryFutureAdapter gridCacheQueryFutureAdapter = this;
            synchronized (gridCacheQueryFutureAdapter) {
                it = this.iter;
                if (it != null && it.hasNext()) {
                    break;
                }
                c = this.queue.poll();
                if (c != null) {
                    this.iter = c.iterator();
                    it = this.iter;
                }
                if (this.isDone() && this.queue.peek() == null) {
                    break;
                }
            }
            if (c != null || this.isDone()) continue;
            this.loadPage();
            gridCacheQueryFutureAdapter = this;
            synchronized (gridCacheQueryFutureAdapter) {
                try {
                    if (this.queue.isEmpty() && !this.isDone()) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IgniteCheckedException("Query was interrupted: " + this.qry, e);
                }
            }
        }
        this.checkError();
        return it;
    }

    protected void onNodeLeft(UUID evtNodeId) {
    }

    protected void enqueue(Collection<?> col) {
        assert (Thread.holdsLock(this));
        this.queue.add(col);
        this.cnt.addAndGet(col.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<?> dedupIfRequired(Collection<?> col) {
        if (!this.qry.query().enableDedup()) {
            return col;
        }
        ArrayList dedupCol = new ArrayList(col.size());
        GridCacheQueryFutureAdapter gridCacheQueryFutureAdapter = this;
        synchronized (gridCacheQueryFutureAdapter) {
            for (Object o : col) {
                if (o instanceof Map.Entry && !this.keys.add(((Map.Entry)o).getKey())) continue;
                dedupCol.add(o);
            }
        }
        return dedupCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPage(@Nullable UUID nodeId, @Nullable Collection<?> data, @Nullable Throwable err, boolean finished) {
        block15: {
            if (this.isCancelled()) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug(S.toString("Received query result page", "nodeId", (Object)nodeId, false, "data", data, true, "err", (Object)err, false, "finished", (Object)finished, false));
            }
            try {
                if (err != null) {
                    GridCacheQueryFutureAdapter gridCacheQueryFutureAdapter = this;
                    synchronized (gridCacheQueryFutureAdapter) {
                        this.enqueue(Collections.emptyList());
                        if (err instanceof IgniteCheckedException) {
                            this.onDone(err);
                        } else {
                            this.onDone(new IgniteCheckedException(nodeId != null ? S.toString("Failed to execute query on node", "query", (Object)this.qry, true, "nodeId", (Object)nodeId, false) : S.toString("Failed to execute query locally", "query", (Object)this.qry, true), err));
                        }
                        this.onPage(nodeId, true);
                        this.notifyAll();
                        break block15;
                    }
                }
                if (data == null) {
                    data = Collections.emptyList();
                }
                data = this.dedupIfRequired(data);
                data = this.cctx.unwrapBinariesIfNeeded(data, this.qry.query().keepBinary());
                GridCacheQueryFutureAdapter gridCacheQueryFutureAdapter = this;
                synchronized (gridCacheQueryFutureAdapter) {
                    this.enqueue(data);
                    if (this.onPage(nodeId, finished)) {
                        this.onDone();
                        this.clear();
                    }
                    this.notifyAll();
                }
            }
            catch (Throwable e) {
                this.onPageError(nodeId, e);
                if (!(e instanceof Error)) break block15;
                throw (Error)e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPageError(@Nullable UUID nodeId, Throwable e) {
        GridCacheQueryFutureAdapter gridCacheQueryFutureAdapter = this;
        synchronized (gridCacheQueryFutureAdapter) {
            this.enqueue(Collections.emptyList());
            this.onPage(nodeId, true);
            this.onDone(e);
            this.notifyAll();
        }
    }

    private Collection<Object> maskNulls(Collection<Object> col) {
        assert (col != null);
        return F.viewReadOnly(col, new C1<Object, Object>(){

            @Override
            public Object apply(Object e) {
                return e != null ? e : NULL;
            }
        }, new IgnitePredicate[0]);
    }

    private Collection<Object> unmaskNulls(Collection<Object> col) {
        assert (col != null);
        return F.viewReadOnly(col, new C1<Object, Object>(){

            @Override
            public Object apply(Object e) {
                return e != NULL ? e : null;
            }
        }, new IgnitePredicate[0]);
    }

    private R unmaskNull(R obj) {
        return (R)(obj != NULL ? obj : null);
    }

    @Override
    public Collection<R> get() throws IgniteCheckedException {
        if (!this.isDone()) {
            this.loadAllPages();
        }
        return (Collection)super.get();
    }

    @Override
    public Collection<R> get(long timeout, TimeUnit unit) throws IgniteCheckedException {
        if (!this.isDone()) {
            this.loadAllPages();
        }
        return (Collection)super.get(timeout, unit);
    }

    @Override
    public Collection<R> getUninterruptibly() throws IgniteCheckedException {
        if (!this.isDone()) {
            this.loadAllPages();
        }
        return (Collection)super.getUninterruptibly();
    }

    protected abstract boolean onPage(UUID var1, boolean var2);

    protected abstract void loadPage();

    protected abstract void loadAllPages() throws IgniteInterruptedCheckedException;

    void clear() {
    }

    @Override
    public boolean cancel() throws IgniteCheckedException {
        if (this.onCancelled()) {
            this.cancelQuery();
            return true;
        }
        return false;
    }

    protected abstract void cancelQuery() throws IgniteCheckedException;

    @Override
    public IgniteUuid timeoutId() {
        return this.timeoutId;
    }

    @Override
    public long endTime() {
        return this.endTime;
    }

    @Override
    public void onTimeout() {
        try {
            if (this.onDone(new IgniteFutureTimeoutCheckedException("Query timed out."))) {
                this.cancelQuery();
            }
        }
        catch (IgniteCheckedException e) {
            log.warning("Exception while canceling query: " + this.toString(), e);
        }
    }

    @Override
    public void close() throws Exception {
        this.cancel();
    }

    @Override
    public String toString() {
        return S.toString(GridCacheQueryFutureAdapter.class, this);
    }

    public void printMemoryStats() {
        X.println(">>> Query future memory statistics.", new Object[0]);
        X.println(">>>  queueSize: " + this.queue.size(), new Object[0]);
        X.println(">>>  keysSize: " + this.keys.size(), new Object[0]);
        X.println(">>>  cnt: " + this.cnt, new Object[0]);
    }

    static {
        NULL = new Object();
    }
}

