/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class ProbedTx
implements Message {
    private static final long serialVersionUID = 0L;
    private UUID nodeId;
    private GridCacheVersion xidVer;
    private GridCacheVersion nearXidVer;
    private long startTime;
    private int lockCntr;

    public ProbedTx() {
    }

    public ProbedTx(UUID nodeId, GridCacheVersion xidVer, GridCacheVersion nearXidVer, long startTime, int lockCntr) {
        this.nodeId = nodeId;
        this.xidVer = xidVer;
        this.nearXidVer = nearXidVer;
        this.startTime = startTime;
        this.lockCntr = lockCntr;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public GridCacheVersion xidVersion() {
        return this.xidVer;
    }

    public GridCacheVersion nearXidVersion() {
        return this.nearXidVer;
    }

    public long startTime() {
        return this.startTime;
    }

    public int lockCounter() {
        return this.lockCntr;
    }

    public ProbedTx withStartTime(long updStartTime) {
        return new ProbedTx(this.nodeId, this.xidVer, this.nearXidVer, updStartTime, this.lockCntr);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeInt("lockCntr", this.lockCntr)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeMessage("nearXidVer", this.nearXidVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeUuid("nodeId", this.nodeId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeLong("startTime", this.startTime)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeMessage("xidVer", this.xidVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.lockCntr = reader.readInt("lockCntr");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.nearXidVer = (GridCacheVersion)reader.readMessage("nearXidVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.nodeId = reader.readUuid("nodeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.startTime = reader.readLong("startTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.xidVer = (GridCacheVersion)reader.readMessage("xidVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ProbedTx.class);
    }

    @Override
    public short directType() {
        return 171;
    }

    @Override
    public byte fieldsCount() {
        return 5;
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(ProbedTx.class, this);
    }
}

