/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheInvalidStateException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.CacheDistributedGetFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetRequest;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class GridPartitionedGetFuture<K, V>
extends CacheDistributedGetFutureAdapter<K, V> {
    protected final String txLbl;
    protected final MvccSnapshot mvccSnapshot;

    public GridPartitionedGetFuture(GridCacheContext<K, V> cctx, Collection<KeyCacheObject> keys, boolean readThrough, boolean forcePrimary, @Nullable UUID subjId, String taskName, boolean deserializeBinary, boolean recovery, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean needVer, boolean keepCacheObjects, @Nullable String txLbl, @Nullable MvccSnapshot mvccSnapshot) {
        super(cctx, keys, readThrough, forcePrimary, subjId, taskName, deserializeBinary, expiryPlc, skipVals, needVer, keepCacheObjects, recovery);
        assert (mvccSnapshot == null == !cctx.mvccEnabled());
        this.mvccSnapshot = mvccSnapshot;
        this.txLbl = txLbl;
        this.initLogger(GridPartitionedGetFuture.class);
    }

    @Nullable
    private MvccSnapshot mvccSnapshot() {
        return this.mvccSnapshot;
    }

    public void init(AffinityTopologyVersion topVer) {
        this.span = this.cctx.kernalContext().tracing().create(SpanType.CACHE_API_PARTITIONED_GET_FUTURE, MTC.span());
        try (MTC.TraceSurroundings ignored = MTC.supportContinual(this.span);){
            AffinityTopologyVersion lockedTopVer = this.cctx.shared().lockedTopologyVersion(null);
            if (lockedTopVer != null) {
                topVer = lockedTopVer;
                this.canRemap = false;
            } else {
                topVer = topVer.topologyVersion() > 0L ? topVer : this.cctx.affinity().affinityTopologyVersion();
            }
            this.map(this.keys, Collections.emptyMap(), topVer);
        }
    }

    @Override
    public boolean onDone(Map<K, V> res, Throwable err) {
        if (super.onDone(res, err)) {
            if (this.trackable) {
                this.cctx.mvcc().removeFuture(this.futId);
            }
            this.cache().sendTtlUpdateRequest(this.expiryPlc);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isMini(IgniteInternalFuture<?> f) {
        return f.getClass().equals(MiniFuture.class);
    }

    @Override
    protected void map(final Collection<KeyCacheObject> keys, final Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mapped, final AffinityTopologyVersion topVer) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.cctx.kernalContext().tracing().create(SpanType.CACHE_API_GET_MAP, this.span));){
            MTC.span().addTag("topology.version", () -> Objects.toString(topVer));
            GridDhtPartitionsExchangeFuture fut = this.cctx.shared().exchange().lastTopologyFuture();
            if (!fut.isDone()) {
                if (topVer.topologyVersion() > 0L && fut.initialVersion().after(topVer) || fut.exchangeActions() != null && fut.exchangeActions().hasStop()) {
                    fut = this.cctx.shared().exchange().lastFinishedFuture();
                } else {
                    fut.listen(new IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>(){

                        @Override
                        public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                            try {
                                final AffinityTopologyVersion topVer0 = fut.get();
                                GridPartitionedGetFuture.this.cctx.closures().runLocalSafe((Runnable)new GridPlainRunnable(){

                                    @Override
                                    public void run() {
                                        GridPartitionedGetFuture.this.map(keys, mapped, topVer.topologyVersion() > 0L ? topVer : topVer0);
                                    }
                                }, true);
                            }
                            catch (IgniteCheckedException e) {
                                GridPartitionedGetFuture.this.onDone(e);
                            }
                        }
                    });
                    return;
                }
            }
            Collection<ClusterNode> cacheNodes = CU.affinityNodes(this.cctx, topVer);
            this.validate(cacheNodes, fut);
            if (this.isDone()) {
                return;
            }
            HashMap<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mappings = U.newHashMap(cacheNodes.size());
            int keysSize = keys.size();
            HashMap locVals = U.newHashMap(keysSize);
            boolean hasRmtNodes = false;
            for (KeyCacheObject keyCacheObject : keys) {
                hasRmtNodes |= this.map(keyCacheObject, topVer, mappings, mapped, locVals);
            }
            if (this.isDone()) {
                return;
            }
            if (!locVals.isEmpty()) {
                this.add(new GridFinishedFuture(locVals));
            }
            if (hasRmtNodes) {
                this.registrateFutureInMvccManager(this);
            }
            for (Map.Entry entry : mappings.entrySet()) {
                ClusterNode n = (ClusterNode)entry.getKey();
                LinkedHashMap mappedKeys = (LinkedHashMap)entry.getValue();
                assert (!mappedKeys.isEmpty());
                if (n.isLocal()) {
                    GridDhtFuture<Collection<GridCacheEntryInfo>> fut0 = this.cache().getDhtAsync(n.id(), -1L, mappedKeys, false, this.readThrough, topVer, this.subjId, this.taskName == null ? 0 : this.taskName.hashCode(), this.expiryPlc, this.skipVals, this.recovery, this.txLbl, this.mvccSnapshot());
                    Collection<Integer> invalidParts = fut0.invalidPartitions();
                    if (!F.isEmpty(invalidParts)) {
                        ArrayList<KeyCacheObject> remapKeys = new ArrayList<KeyCacheObject>(keysSize);
                        for (KeyCacheObject key : keys) {
                            int part = this.cctx.affinity().partition(key);
                            if (key == null || !invalidParts.contains(part)) continue;
                            this.addNodeAsInvalid(n, part, topVer);
                            remapKeys.add(key);
                        }
                        AffinityTopologyVersion updTopVer = this.cctx.shared().exchange().readyAffinityVersion();
                        this.map(remapKeys, mappings, updTopVer);
                    }
                    this.add(fut0.chain(f -> {
                        try {
                            return this.createResultMap((Collection)f.get());
                        }
                        catch (Exception e) {
                            U.error(log, "Failed to get values from dht cache [fut=" + fut0 + "]", e);
                            this.onDone(e);
                            return Collections.emptyMap();
                        }
                    }));
                    continue;
                }
                MiniFuture miniFut = new MiniFuture(n, (LinkedHashMap<KeyCacheObject, Boolean>)mappedKeys, topVer);
                GridNearGetRequest req = miniFut.createGetRequest(this.futId);
                this.add(miniFut);
                try {
                    this.cctx.io().send(n, (GridCacheMessage)req, this.cctx.ioPolicy());
                }
                catch (IgniteCheckedException e) {
                    if (e instanceof ClusterTopologyCheckedException) {
                        miniFut.onNodeLeft((ClusterTopologyCheckedException)e);
                        continue;
                    }
                    miniFut.onResult(e);
                }
            }
            this.markInitialized();
        }
    }

    private boolean map(KeyCacheObject key, AffinityTopologyVersion topVer, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> nodesToKeysMapping, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> missedNodesToKeysMapping, Map<K, V> locVals) {
        boolean remote;
        int part = this.cctx.affinity().partition(key);
        List<ClusterNode> affNodes = this.cctx.affinity().nodesByPartition(part, topVer);
        if (affNodes.isEmpty()) {
            this.onDone(this.serverNotFoundError(part, topVer));
            return false;
        }
        if (this.tryLocalGet(key, part, topVer, affNodes, locVals)) {
            return false;
        }
        Set<ClusterNode> invalidNodeSet = this.getInvalidNodes(part, topVer);
        ClusterNode node = this.cctx.selectAffinityNodeBalanced(affNodes, invalidNodeSet, part, this.canRemap);
        if (node == null) {
            this.onDone(this.serverNotFoundError(part, topVer));
            return false;
        }
        boolean bl = remote = !node.isLocal();
        if (!this.checkRetryPermits(key, node, missedNodesToKeysMapping)) {
            return false;
        }
        this.addNodeMapping(key, node, nodesToKeysMapping);
        return remote;
    }

    private void addNodeMapping(KeyCacheObject key, ClusterNode node, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mappings) {
        LinkedHashMap<KeyCacheObject, Boolean> old = mappings.get(node);
        if (old == null) {
            old = new LinkedHashMap(3, 1.0f);
            mappings.put(node, old);
        }
        old.put(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLocalGet(KeyCacheObject key, int part, AffinityTopologyVersion topVer, List<ClusterNode> affNodes, Map<K, V> locVals) {
        boolean fastLocGet;
        boolean bl = fastLocGet = !this.cctx.mvccEnabled() && (!this.forcePrimary && this.cctx.config().isReadFromBackup() || affNodes.get(0).isLocal()) && this.cctx.reserveForFastLocalGet(part, topVer);
        if (fastLocGet) {
            try {
                if (this.localGet(topVer, key, part, locVals)) {
                    boolean bl2 = true;
                    return bl2;
                }
            }
            finally {
                this.cctx.releaseForFastLocalGet(part, topVer);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean localGet(AffinityTopologyVersion topVer, KeyCacheObject key, int part, Map<K, V> locVals) {
        assert (this.cctx.affinityNode()) : this;
        GridDhtCacheAdapter<K, V> cache = this.cache();
        boolean readNoEntry = this.cctx.readNoEntry(this.expiryPlc, false);
        boolean evt = !this.skipVals;
        while (true) {
            this.cctx.shared().database().checkpointReadLock();
            try {
                boolean topStable;
                GridCacheEntryEx entry2222;
                boolean skipEntry = readNoEntry;
                EntryGetResult getRes = null;
                CacheObject v = null;
                GridCacheVersion ver = null;
                if (readNoEntry) {
                    CacheDataRow row;
                    KeyCacheObject key0;
                    KeyCacheObject keyCacheObject = key0 = key == null ? null : key.prepareForCache(this.cctx.cacheObjectContext(), false);
                    if (this.mvccSnapshot != null) {
                        row = this.cctx.offheap().mvccRead(this.cctx, key0, this.mvccSnapshot);
                    } else {
                        CacheDataRow cacheDataRow = row = this.skipVals ? this.cctx.offheap().find(this.cctx, key0) : this.cctx.offheap().read(this.cctx, key0);
                    }
                    if (row != null) {
                        long expireTime = row.expireTime();
                        if (expireTime == 0L || expireTime > U.currentTimeMillis()) {
                            v = row.value();
                            if (this.needVer) {
                                ver = row.version();
                            }
                            if (evt) {
                                this.cctx.events().readEvent(key, null, this.txLbl, row.value(), this.subjId, this.taskName, !this.deserializeBinary);
                            }
                        } else if (!this.skipVals) {
                            skipEntry = false;
                        }
                    }
                }
                if (!skipEntry && (entry2222 = cache.entryEx(key)) != null) {
                    boolean isNew = entry2222.isNewLocked();
                    if (this.needVer) {
                        getRes = entry2222.innerGetVersioned(null, null, false, evt, this.subjId, null, this.taskName, this.expiryPlc, !this.deserializeBinary, null);
                        if (getRes != null) {
                            v = (CacheObject)getRes.value();
                            ver = getRes.version();
                        }
                    } else {
                        v = entry2222.innerGet(null, null, false, false, evt, this.subjId, null, this.taskName, this.expiryPlc, !this.deserializeBinary);
                    }
                    entry2222.touch();
                    if (v == null && isNew && entry2222.markObsoleteIfEmpty(ver)) {
                        cache.removeEntry(entry2222);
                    }
                }
                if (v != null) {
                    this.cctx.addResult(locVals, key, v, this.skipVals, this.keepCacheObjects, this.deserializeBinary, true, getRes, ver, 0L, 0L, this.needVer, U.deploymentClassLoader(this.cctx.kernalContext(), this.deploymentLdrId));
                    boolean entry2222 = true;
                    return entry2222;
                }
                boolean bl = topStable = this.cctx.isReplicated() || topVer.equals(this.cctx.topology().lastTopologyChangeVersion());
                if (!this.cctx.readThroughConfigured() && (topStable || this.partitionOwned(part))) {
                    if (!this.skipVals && this.cctx.statisticsEnabled()) {
                        cache.metrics0().onRead(false);
                    }
                    boolean bl2 = true;
                    return bl2;
                }
                boolean bl3 = false;
                return bl3;
            }
            catch (GridCacheEntryRemovedException skipEntry) {
                continue;
            }
            catch (GridDhtInvalidPartitionException ignored) {
                boolean bl = false;
                return bl;
            }
            catch (IgniteCheckedException e) {
                this.onDone(e);
                boolean bl = true;
                return bl;
            }
            finally {
                this.cctx.shared().database().checkpointReadUnlock();
                continue;
            }
            break;
        }
    }

    private void validate(Collection<ClusterNode> cacheNodes, GridDhtTopologyFuture topFut) {
        CacheInvalidStateException err;
        assert (topFut != null && topFut.isDone()) : topFut;
        CacheInvalidStateException cacheInvalidStateException = err = topFut != null ? topFut.validateCache(this.cctx, this.recovery, true, null, this.keys) : null;
        if (err != null) {
            this.onDone(err);
            return;
        }
        if (cacheNodes.isEmpty()) {
            this.onDone(new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid) [topVer=" + topFut.topologyVersion() + ", cache=" + this.cctx.name() + ']'));
        }
    }

    private GridDhtCacheAdapter<K, V> cache() {
        return this.cctx.dht();
    }

    private Map<K, V> createResultMap(Collection<GridCacheEntryInfo> infos) {
        int keysSize = infos.size();
        if (keysSize != 0) {
            GridLeanMap map = new GridLeanMap(keysSize);
            for (GridCacheEntryInfo info : infos) {
                assert (this.skipVals == (info.value() == null));
                this.cctx.addResult(map, info.key(), info.value(), this.skipVals, this.keepCacheObjects, this.deserializeBinary, false, this.needVer ? info.version() : null, 0L, 0L, U.deploymentClassLoader(this.cctx.kernalContext(), this.deploymentLdrId));
            }
            return map;
        }
        return Collections.emptyMap();
    }

    @Override
    public String toString() {
        return S.toString(GridPartitionedGetFuture.class, this, "super", (Object)super.toString());
    }

    private class MiniFuture
    extends CacheDistributedGetFutureAdapter.AbstractMiniFuture {
        public MiniFuture(ClusterNode node, LinkedHashMap<KeyCacheObject, Boolean> keys, AffinityTopologyVersion topVer) {
            super(node, keys, topVer);
        }

        @Override
        protected GridNearGetRequest createGetRequest0(IgniteUuid rootFutId, IgniteUuid futId) {
            return new GridNearGetRequest(GridPartitionedGetFuture.this.cctx.cacheId(), rootFutId, futId, null, this.keys, GridPartitionedGetFuture.this.readThrough, this.topVer, GridPartitionedGetFuture.this.subjId, GridPartitionedGetFuture.this.taskName == null ? 0 : GridPartitionedGetFuture.this.taskName.hashCode(), GridPartitionedGetFuture.this.expiryPlc != null ? GridPartitionedGetFuture.this.expiryPlc.forCreate() : -1L, GridPartitionedGetFuture.this.expiryPlc != null ? GridPartitionedGetFuture.this.expiryPlc.forAccess() : -1L, false, GridPartitionedGetFuture.this.skipVals, GridPartitionedGetFuture.this.cctx.deploymentEnabled(), GridPartitionedGetFuture.this.recovery, GridPartitionedGetFuture.this.txLbl, GridPartitionedGetFuture.this.mvccSnapshot());
        }

        @Override
        protected Map<K, V> createResultMap(Collection<GridCacheEntryInfo> entries) {
            return GridPartitionedGetFuture.this.createResultMap(entries);
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this);
        }
    }
}

