/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.processors.cache.IncompleteCacheObject;

public class IncompleteCacheObjectShadow
extends IncompleteCacheObject {
    private int valLen;
    private boolean headerReady;
    private boolean completeWhenHeaderReady;

    public IncompleteCacheObjectShadow(ByteBuffer buf, boolean completeWhenValueLengthReady) {
        this.completeWhenHeaderReady = completeWhenValueLengthReady;
        if (buf.remaining() >= 5) {
            this.valLen = buf.getInt();
            this.type = buf.get();
            this.headerReady();
        } else {
            this.head = new byte[5];
        }
    }

    public IncompleteCacheObjectShadow(ByteBuffer buf) {
        this(buf, false);
    }

    @Override
    public void readData(ByteBuffer buf) {
        int len;
        if (!this.headerReady) {
            assert (this.head != null) : "Header should be initialized before data reading.";
            len = Math.min(5 - this.headOff, buf.remaining());
            buf.get(this.head, this.headOff, len);
            this.headOff += len;
            if (this.headOff == 5) {
                ByteBuffer headBuf = ByteBuffer.wrap(this.head);
                headBuf.order(buf.order());
                this.valLen = headBuf.getInt();
                this.type = headBuf.get();
                this.headerReady();
            }
        }
        if (this.headerReady) {
            len = Math.min(this.valLen - this.off, buf.remaining());
            buf.position(buf.position() + len);
            this.off += len;
        }
    }

    @Override
    public boolean isReady() {
        return this.headerReady && (this.completeWhenHeaderReady || this.off == this.valLen);
    }

    @Override
    public byte[] data() {
        throw new UnsupportedOperationException("Incomplete cache object shadow does not support materialization");
    }

    @Override
    public int dataLength() {
        return this.valLen;
    }

    @Override
    protected void headerReady() {
        super.headerReady();
        this.headerReady = true;
    }
}

