/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.deployment;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.events.DeploymentEvent;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.deployment.GridDeploymentClassLoader;
import org.apache.ignite.internal.managers.deployment.GridDeploymentCommunication;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfo;
import org.apache.ignite.internal.managers.deployment.GridDeploymentMetadata;
import org.apache.ignite.internal.managers.deployment.GridDeploymentStoreAdapter;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.util.GridAnnotationsCache;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashSet;
import org.apache.ignite.internal.util.GridClassLoaderCache;
import org.apache.ignite.internal.util.GridStripedLock;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.AbstractMarshaller;
import org.apache.ignite.spi.deployment.DeploymentSpi;
import org.jetbrains.annotations.Nullable;

public class GridDeploymentPerVersionStore
extends GridDeploymentStoreAdapter {
    private final Map<String, List<SharedDeployment>> cache = new HashMap<String, List<SharedDeployment>>();
    private final Collection<IgniteUuid> deadClsLdrs = new GridBoundedConcurrentLinkedHashSet<IgniteUuid>(1024, 64);
    private GridLocalEventListener discoLsnr;
    private final ConcurrentMap<IgniteUuid, Map<String, Boolean>> rsrcCache;
    private final Object mux = new Object();
    private final int missedRsrcCacheSize;
    private final GridStripedLock loadRmtLock = new GridStripedLock(16);

    GridDeploymentPerVersionStore(DeploymentSpi spi, GridKernalContext ctx, GridDeploymentCommunication comm) {
        super(spi, ctx, comm);
        this.missedRsrcCacheSize = ctx.config().getPeerClassLoadingMissedResourcesCacheSize();
        this.rsrcCache = new ConcurrentHashMap<IgniteUuid, Map<String, Boolean>>();
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.discoLsnr = new GridLocalEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEvent(Event evt) {
                assert (evt instanceof DiscoveryEvent);
                assert (evt.type() == 11 || evt.type() == 12);
                DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
                LinkedList<SharedDeployment> undeployed = new LinkedList<SharedDeployment>();
                if (GridDeploymentPerVersionStore.this.log.isDebugEnabled()) {
                    GridDeploymentPerVersionStore.this.log.debug("Processing node departure event: " + evt);
                }
                Object object = GridDeploymentPerVersionStore.this.mux;
                synchronized (object) {
                    Iterator i1 = GridDeploymentPerVersionStore.this.cache.values().iterator();
                    while (i1.hasNext()) {
                        List deps = (List)i1.next();
                        Iterator i2 = deps.iterator();
                        while (i2.hasNext()) {
                            SharedDeployment dep = (SharedDeployment)i2.next();
                            dep.removeParticipant(discoEvt.eventNode().id());
                            if (!dep.hasParticipants()) {
                                if (dep.deployMode() == DeploymentMode.SHARED) {
                                    if (dep.undeployed()) continue;
                                    dep.undeploy();
                                    i2.remove();
                                    assert (!dep.isRemoved());
                                    dep.onRemoved();
                                    undeployed.add(dep);
                                    if (!GridDeploymentPerVersionStore.this.log.isDebugEnabled()) continue;
                                    GridDeploymentPerVersionStore.this.log.debug("Undeployed class loader as there are no participating nodes: " + dep);
                                    continue;
                                }
                                if (!GridDeploymentPerVersionStore.this.log.isDebugEnabled()) continue;
                                GridDeploymentPerVersionStore.this.log.debug("Preserving deployment without node participants: " + dep);
                                continue;
                            }
                            if (!GridDeploymentPerVersionStore.this.log.isDebugEnabled()) continue;
                            GridDeploymentPerVersionStore.this.log.debug("Keeping deployment as it still has participants: " + dep);
                        }
                        if (!deps.isEmpty()) continue;
                        i1.remove();
                    }
                }
                GridDeploymentPerVersionStore.this.recordUndeployed(discoEvt.eventNode().id(), undeployed);
            }
        };
        this.ctx.event().addLocalEventListener(this.discoLsnr, 12, 11);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        HashSet<SharedDeployment> cp = new HashSet<SharedDeployment>();
        Iterator iterator = this.mux;
        synchronized (iterator) {
            for (List<SharedDeployment> deps : this.cache.values()) {
                for (SharedDeployment dep : deps) {
                    dep.undeploy();
                    cp.add(dep);
                }
            }
            this.cache.clear();
        }
        for (SharedDeployment dep : cp) {
            dep.recordUndeployed(null);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onKernalStart() throws IgniteCheckedException {
        LinkedList<SharedDeployment> undeployed = new LinkedList<SharedDeployment>();
        Object object = this.mux;
        synchronized (object) {
            Iterator<List<SharedDeployment>> i1 = this.cache.values().iterator();
            while (i1.hasNext()) {
                List<SharedDeployment> deps = i1.next();
                Iterator<SharedDeployment> i2 = deps.iterator();
                while (i2.hasNext()) {
                    SharedDeployment dep = i2.next();
                    for (UUID nodeId : dep.getParticipantNodeIds()) {
                        if (this.ctx.discovery().node(nodeId) != null) continue;
                        dep.removeParticipant(nodeId);
                    }
                    if (!dep.hasParticipants()) {
                        if (dep.deployMode() == DeploymentMode.SHARED) {
                            if (dep.undeployed()) continue;
                            dep.undeploy();
                            i2.remove();
                            dep.onRemoved();
                            undeployed.add(dep);
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug("Undeployed class loader as there are no participating nodes: " + dep);
                            continue;
                        }
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Preserving deployment without node participants: " + dep);
                        continue;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Keeping deployment as it still has participants: " + dep);
                }
                if (!deps.isEmpty()) continue;
                i1.remove();
            }
        }
        this.recordUndeployed(null, undeployed);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Registered deployment discovery listener: " + this.discoLsnr);
        }
    }

    @Override
    public void onKernalStop() {
        if (this.discoLsnr != null) {
            this.ctx.event().removeLocalEventListener(this.discoLsnr, new int[0]);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unregistered deployment discovery listener: " + this.discoLsnr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<GridDeployment> getDeployments() {
        LinkedList<GridDeployment> deps = new LinkedList<GridDeployment>();
        Object object = this.mux;
        synchronized (object) {
            for (List<SharedDeployment> list : this.cache.values()) {
                for (SharedDeployment d : list) {
                    deps.add(d);
                }
            }
        }
        return deps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridDeployment getDeployment(final IgniteUuid ldrId) {
        Object object = this.mux;
        synchronized (object) {
            return F.find(F.flat(this.cache.values()), null, new P1<SharedDeployment>(){

                @Override
                public boolean apply(SharedDeployment d) {
                    return d.classLoaderId().equals(ldrId);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridDeployment searchDeploymentCache(GridDeploymentMetadata meta) {
        Object object = this.mux;
        synchronized (object) {
            List<SharedDeployment> deps = this.cache.get(meta.userVersion());
            if (deps != null) {
                assert (!deps.isEmpty());
                for (SharedDeployment d : deps) {
                    if (!d.hasParticipant(meta.senderNodeId(), meta.classLoaderId())) continue;
                    return d;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public GridDeployment getDeployment(GridDeploymentMetadata meta) {
        IgniteBiTuple<Class<?>, Throwable> cls;
        SharedDeployment dep;
        block62: {
            List<SharedDeployment> deps;
            assert (meta != null);
            assert (this.ctx.config().isPeerClassLoadingEnabled());
            assert (meta.classLoaderId() != null);
            assert (meta.senderNodeId() != null);
            assert (meta.sequenceNumber() >= -1L);
            assert (meta.parentLoader() == null);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Starting to peer-load class based on deployment metadata: " + meta);
            }
            if (meta.participants() == null && !this.checkLoadRemoteClass(meta.className(), meta)) {
                if (!this.log.isDebugEnabled()) return null;
                this.log.debug("Skipping deployment check as remote node does not have required class: " + meta);
                return null;
            }
            while (true) {
                Class<?> cls2;
                LinkedList<SharedDeployment> depsToCheck;
                block63: {
                    block65: {
                        Iterator<Object> iterator;
                        block66: {
                            block64: {
                                depsToCheck = null;
                                dep = null;
                                Object object = this.mux;
                                // MONITORENTER : object
                                if (this.isDeadClassLoader(meta)) {
                                    // MONITOREXIT : object
                                    return null;
                                }
                                if (F.isEmpty(meta.participants())) {
                                    if (this.ctx.discovery().node(meta.senderNodeId()) == null) {
                                        if (this.log.isDebugEnabled()) {
                                            this.log.debug("Sender node has gone: " + meta);
                                        }
                                        // MONITOREXIT : object
                                        return null;
                                    }
                                } else {
                                    LinkedHashMap<UUID, IgniteUuid> participants = new LinkedHashMap<UUID, IgniteUuid>();
                                    for (Map.Entry<UUID, IgniteUuid> e : meta.participants().entrySet()) {
                                        if (this.ctx.localNodeId().equals(e.getKey())) {
                                            if (meta.deploymentMode() == DeploymentMode.CONTINUOUS) continue;
                                            LT.warn(this.log, "Local node is in participants (most probably, IgniteConfiguration.getPeerClassLoadingLocalClassPathExclude() is not used properly [locNodeId=" + this.ctx.localNodeId() + ", meta=" + meta + ']');
                                            continue;
                                        }
                                        if (this.ctx.discovery().node(e.getKey()) == null) continue;
                                        participants.put(e.getKey(), e.getValue());
                                    }
                                    if (!participants.isEmpty()) {
                                        meta = new GridDeploymentMetadata(meta);
                                        meta.participants(participants);
                                        if (this.log.isDebugEnabled()) {
                                            this.log.debug("Created new meta with updated participants: " + meta);
                                        }
                                    } else {
                                        if (this.log.isDebugEnabled()) {
                                            this.log.debug("All participants has gone: " + meta);
                                        }
                                        if (meta.deploymentMode() != DeploymentMode.CONTINUOUS) {
                                            // MONITOREXIT : object
                                            return null;
                                        }
                                    }
                                }
                                if ((dep = (SharedDeployment)this.searchDeploymentCache(meta)) != null) break block63;
                                deps = this.cache.get(meta.userVersion());
                                if (deps == null) break block64;
                                assert (!deps.isEmpty());
                                this.checkRedeploy(meta);
                                if (this.ctx.config().getDeploymentMode() != DeploymentMode.CONTINUOUS) break block65;
                                iterator = deps.iterator();
                                break block66;
                            }
                            this.checkRedeploy(meta);
                            dep = this.createNewDeployment(meta, true);
                            break block63;
                        }
                        while (iterator.hasNext()) {
                            IgniteUuid ldrId;
                            SharedDeployment d = (SharedDeployment)iterator.next();
                            if (d.pendingUndeploy() || d.undeployed()) continue;
                            Map<UUID, IgniteUuid> parties = d.participants();
                            if (parties != null && (ldrId = parties.get(meta.senderNodeId())) != null) {
                                assert (!ldrId.equals(meta.classLoaderId()));
                                if (!this.log.isDebugEnabled()) continue;
                                this.log.debug("Skipping deployment (loaders on remote node are different) [dep=" + d + ", meta=" + meta + ']');
                                continue;
                            }
                            if (depsToCheck == null) {
                                depsToCheck = new LinkedList<SharedDeployment>();
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Adding deployment to check: " + d);
                            }
                            depsToCheck.add(d);
                        }
                    }
                    if (depsToCheck == null) {
                        dep = this.createNewDeployment(meta, false);
                        deps.add(dep);
                    }
                }
                // MONITOREXIT : object
                if (dep != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Found SHARED or CONTINUOUS deployment after first check: " + dep);
                    }
                    if ((cls = dep.deployedClass(meta.className(), meta.alias())).get1() != null) return dep;
                    U.warn(this.log, "Failed to load peer class (ignore if class got undeployed during preloading) [alias=" + meta.alias() + ", dep=" + dep + ']', (Throwable)cls.get2());
                    return null;
                }
                assert (meta.parentLoader() == null);
                assert (depsToCheck != null);
                assert (!depsToCheck.isEmpty());
                for (SharedDeployment d : depsToCheck) {
                    cls2 = d.deployedClass(meta.className(), meta.alias()).get1();
                    if (cls2 != null) {
                        Iterator<SharedDeployment> iterator = this.mux;
                        // MONITORENTER : iterator
                        if (!d.undeployed() && !d.pendingUndeploy()) {
                            if (!this.addParticipant(d, meta)) {
                                // MONITOREXIT : iterator
                                return null;
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Acquired deployment after verifying it's availability on existing nodes [depCls=" + cls2 + ", dep=" + d + ", meta=" + meta + ']');
                            }
                            // MONITOREXIT : iterator
                            return d;
                        }
                        // MONITOREXIT : iterator
                        continue;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Deployment cannot be reused (class does not exist on participating nodes) [dep=" + d + ", meta=" + meta + ']');
                }
                for (SharedDeployment d : depsToCheck) {
                    if (meta.participants() != null || this.checkLoadRemoteClass(d.sampleClassName(), meta)) {
                        cls2 = this.mux;
                        // MONITORENTER : cls2
                        if (d.undeployed() || d.pendingUndeploy()) {
                            // MONITOREXIT : cls2
                            continue;
                        }
                        if (!this.addParticipant(d, meta)) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Failed to add participant to deployment [meta=" + meta + ", dep=" + dep + ']');
                            }
                            // MONITOREXIT : cls2
                            return null;
                        }
                        // MONITOREXIT : cls2
                        IgniteBiTuple<Class<?>, Throwable> depCls = d.deployedClass(meta.className(), meta.alias());
                        if (depCls.get1() == null) {
                            U.error(this.log, "Failed to peer load class after loading it as a resource [alias=" + meta.alias() + ", dep=" + dep + ']', depCls.get2());
                            return null;
                        }
                        if (!this.log.isDebugEnabled()) return d;
                        this.log.debug("Acquired deployment class after verifying other class availability on sender node [depCls=" + depCls + ", rndCls=" + d.sampleClassName() + ", sampleClsName=" + d.sampleClassName() + ", meta=" + meta + ']');
                        return d;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Deployment cannot be reused (random class could not be loaded from sender node) [dep=" + d + ", meta=" + meta + ']');
                }
                cls = this.mux;
                // MONITORENTER : cls
                if (this.log.isDebugEnabled()) {
                    this.log.debug("None of the existing class-loaders fits (will try to create a new one): " + meta);
                }
                if (this.isDeadClassLoader(meta)) {
                    // MONITOREXIT : cls
                    return null;
                }
                deps = this.cache.get(meta.userVersion());
                if (deps == null) {
                    dep = this.createNewDeployment(meta, true);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Created new deployment within second check [dep=" + dep + ", meta=" + meta + ']');
                    }
                    break block62;
                }
                assert (!deps.isEmpty());
                boolean retry = false;
                for (SharedDeployment d : deps) {
                    Map<UUID, IgniteUuid> parties;
                    if (d.hasParticipant(meta.senderNodeId(), meta.classLoaderId())) {
                        dep = d;
                        retry = false;
                        break;
                    }
                    if (d.pendingUndeploy() || d.undeployed() || depsToCheck.contains(d) || (parties = d.participants()) != null && parties.get(meta.senderNodeId()) != null) continue;
                    retry = true;
                }
                if (!retry) break;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Retrying due to concurrency issues: " + meta);
                }
                // MONITOREXIT : cls
            }
            if (dep == null) {
                dep = this.createNewDeployment(meta, false);
                deps.add(dep);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Adding new deployment within second check [dep=" + dep + ", meta=" + meta + ']');
                }
            }
        }
        // MONITOREXIT : cls
        if (dep == null) return dep;
        cls = dep.deployedClass(meta.className(), meta.alias());
        if (cls.get1() != null) return dep;
        U.warn(this.log, "Failed to load peer class (ignore if class got undeployed during preloading) [alias=" + meta.alias() + ", dep=" + dep + ']', cls.get2());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addParticipants(Map<UUID, IgniteUuid> allParticipants, Map<UUID, IgniteUuid> addedParticipants) {
        Object object = this.mux;
        synchronized (object) {
            for (List<SharedDeployment> deps : this.cache.values()) {
                for (SharedDeployment dep : deps) {
                    if (dep.undeployed() || dep.pendingUndeploy() || dep.deployMode() == DeploymentMode.CONTINUOUS || !this.hasAnyParticipant(dep, allParticipants)) continue;
                    for (Map.Entry<UUID, IgniteUuid> added : addedParticipants.entrySet()) {
                        UUID nodeId = added.getKey();
                        if (this.ctx.discovery().node(nodeId) == null || dep.hasParticipant(nodeId, added.getValue()) || !dep.addParticipant(nodeId, added.getValue()) || !this.log.isDebugEnabled()) continue;
                        this.log.debug("Explicitly added participant [dep=" + dep + ", nodeId=" + nodeId + ", ldrId=" + added.getValue() + ']');
                    }
                }
            }
        }
    }

    private boolean hasAnyParticipant(SharedDeployment dep, Map<UUID, IgniteUuid> participants) {
        assert (Thread.holdsLock(this.mux));
        for (Map.Entry<UUID, IgniteUuid> entry : participants.entrySet()) {
            if (!dep.hasParticipant(entry.getKey(), entry.getValue())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean checkLoadRemoteClass(String clsName, GridDeploymentMetadata meta) {
        if (!GridDeploymentPerVersionStore.$assertionsDisabled && clsName == null) {
            throw new AssertionError();
        }
        if (!GridDeploymentPerVersionStore.$assertionsDisabled && meta == null) {
            throw new AssertionError();
        }
        if (!GridDeploymentPerVersionStore.$assertionsDisabled && meta.participants() != null) {
            throw new AssertionError();
        }
        ldrRsrcCache = (Map)this.rsrcCache.get(meta.classLoaderId());
        if (ldrRsrcCache != null && (res = (Boolean)ldrRsrcCache.get(clsName)) != null) {
            return res;
        }
        if (this.deadClsLdrs.contains(meta.classLoaderId())) {
            return false;
        }
        lockId = clsName.hashCode() * 31 + meta.classLoaderId().hashCode();
        this.loadRmtLock.lock(lockId);
        try {
            block21: {
                ldrRsrcCache = (Map)this.rsrcCache.get(meta.classLoaderId());
                if (ldrRsrcCache != null && (res = (Boolean)ldrRsrcCache.get(clsName)) != null) {
                    var6_8 = res;
                    return var6_8;
                }
                if (this.deadClsLdrs.contains(meta.classLoaderId())) {
                    res = false;
                    return res;
                }
                temp = new GridDeploymentClassLoader(IgniteUuid.fromUuid(this.ctx.localNodeId()), meta.userVersion(), meta.deploymentMode(), true, this.ctx, this.ctx.config().getClassLoader() != null ? this.ctx.config().getClassLoader() : U.gridClassLoader(), meta.classLoaderId(), meta.senderNodeId(), this.comm, this.ctx.config().getNetworkTimeout(), this.log, this.ctx.config().getPeerClassLoadingLocalClassPathExclude(), 0, false, true);
                path = U.classNameToResourceName(clsName);
                rsrcIn = null;
                try {
                    timeout = false;
                    try {
                        rsrcIn = temp.getResourceAsStreamEx(path);
                    }
                    catch (TimeoutException e) {
                        timeout = true;
                    }
                    v0 = found = rsrcIn != null;
                    if (!found && this.missedRsrcCacheSize <= 0) ** GOTO lbl53
                    if (ldrRsrcCache == null) {
                        ldrRsrcCache = F.addIfAbsent(this.rsrcCache, meta.classLoaderId(), new ConcurrentHashMap<K, V>());
                    }
                    if (!this.deadClsLdrs.contains(meta.classLoaderId())) break block21;
                    this.rsrcCache.remove(meta.classLoaderId());
                    var10_14 = false;
                }
                catch (Throwable var11_16) {
                    U.closeQuiet(rsrcIn);
                    throw var11_16;
                }
                U.closeQuiet(rsrcIn);
                return var10_14;
            }
            if (!timeout) {
                ldrRsrcCache.put(clsName, found);
            }
lbl53:
            // 4 sources

            var10_15 = found;
            U.closeQuiet(rsrcIn);
            return var10_15;
        }
        finally {
            this.loadRmtLock.unlock(lockId);
        }
    }

    private void recordUndeployed(@Nullable UUID nodeId, Collection<SharedDeployment> undeployed) {
        if (!F.isEmpty(undeployed)) {
            for (SharedDeployment d : undeployed) {
                d.recordUndeployed(nodeId);
            }
        }
    }

    private boolean isDeadClassLoader(GridDeploymentMetadata meta) {
        assert (Thread.holdsLock(this.mux));
        if (this.deadClsLdrs.contains(meta.classLoaderId())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Ignoring request for obsolete class loader: " + meta);
            }
            return true;
        }
        return false;
    }

    private boolean addParticipant(SharedDeployment dep, GridDeploymentMetadata meta) {
        assert (dep != null);
        assert (meta != null);
        assert (Thread.holdsLock(this.mux));
        if (!this.checkModeMatch(dep, meta)) {
            return false;
        }
        if (meta.participants() != null) {
            for (Map.Entry<UUID, IgniteUuid> e : meta.participants().entrySet()) {
                if (this.ctx.discovery().node(e.getKey()) != null) {
                    dep.addParticipant(e.getKey(), e.getValue());
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Added new participant [nodeId=" + e.getKey() + ", clsLdrId=" + e.getValue() + ", seqNum=" + e.getValue().localId() + ']');
                    continue;
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Skipped participant (node left?) [nodeId=" + e.getKey() + ", clsLdrId=" + e.getValue() + ", seqNum=" + e.getValue().localId() + ']');
            }
        }
        if (dep.deployMode() == DeploymentMode.CONTINUOUS || meta.participants() == null) {
            if (!dep.addParticipant(meta.senderNodeId(), meta.classLoaderId())) {
                U.warn(this.log, "Failed to create shared mode deployment (requested class loader was already undeployed, did sender node leave grid?) [clsLdrId=" + meta.classLoaderId() + ", senderNodeId=" + meta.senderNodeId() + ']');
                return false;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Added new participant [nodeId=" + meta.senderNodeId() + ", clsLdrId=" + meta.classLoaderId() + ", seqNum=" + meta.sequenceNumber() + ']');
            }
        }
        return true;
    }

    private boolean checkModeMatch(GridDeploymentInfo dep, GridDeploymentMetadata meta) {
        if (dep.deployMode() != meta.deploymentMode()) {
            U.warn(this.log, "Received invalid deployment mode (will not deploy, make sure that all nodes executing the same classes in shared mode have identical GridDeploymentMode parameter) [mode=" + (Object)((Object)meta.deploymentMode()) + ", expected=" + (Object)((Object)dep.deployMode()) + ']');
            return false;
        }
        return true;
    }

    private void checkRedeploy(GridDeploymentMetadata meta) {
        assert (Thread.holdsLock(this.mux));
        for (List<SharedDeployment> deps : this.cache.values()) {
            for (SharedDeployment dep : deps) {
                if (dep.undeployed() || dep.pendingUndeploy()) continue;
                long undeployTimeout = this.ctx.config().getNetworkTimeout();
                if (dep.hasParticipants() || dep.deployMode() != DeploymentMode.CONTINUOUS || dep.existingDeployedClass(meta.className()) == null || meta.userVersion().equals(dep.userVersion())) continue;
                dep.onUndeployScheduled();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Deployment was scheduled for undeploy: " + dep);
                }
                final long endTime = U.currentTimeMillis() + undeployTimeout;
                final SharedDeployment undep = dep;
                if (endTime <= 0L) continue;
                this.ctx.timeout().addTimeoutObject(new GridTimeoutObject(){

                    @Override
                    public IgniteUuid timeoutId() {
                        return undep.classLoaderId();
                    }

                    @Override
                    public long endTime() {
                        return endTime < 0L ? Long.MAX_VALUE : endTime;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onTimeout() {
                        boolean rmv = false;
                        Object object = GridDeploymentPerVersionStore.this.mux;
                        synchronized (object) {
                            assert (undep.pendingUndeploy());
                            if (!undep.undeployed()) {
                                undep.undeploy();
                                undep.onRemoved();
                                rmv = true;
                                Collection deps = (Collection)GridDeploymentPerVersionStore.this.cache.get(undep.userVersion());
                                if (deps != null) {
                                    Iterator i = deps.iterator();
                                    while (i.hasNext()) {
                                        if (i.next() != undep) continue;
                                        i.remove();
                                    }
                                    if (deps.isEmpty()) {
                                        GridDeploymentPerVersionStore.this.cache.remove(undep.userVersion());
                                    }
                                }
                                if (GridDeploymentPerVersionStore.this.log.isInfoEnabled()) {
                                    GridDeploymentPerVersionStore.this.log.info("Undeployed class loader due to deployment mode change, user version change, or hot redeployment: " + undep);
                                }
                            }
                        }
                        if (rmv) {
                            undep.recordUndeployed(null);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void explicitUndeploy(UUID nodeId, String rsrcName) {
        LinkedList<SharedDeployment> undeployed = new LinkedList<SharedDeployment>();
        Object object = this.mux;
        synchronized (object) {
            Iterator<List<SharedDeployment>> i1 = this.cache.values().iterator();
            while (i1.hasNext()) {
                List<SharedDeployment> deps = i1.next();
                Iterator<SharedDeployment> i2 = deps.iterator();
                while (i2.hasNext()) {
                    SharedDeployment dep = i2.next();
                    if (!dep.hasName(rsrcName)) continue;
                    if (dep.undeployed()) break;
                    dep.undeploy();
                    dep.onRemoved();
                    i2.remove();
                    undeployed.add(dep);
                    if (!this.log.isInfoEnabled()) break;
                    this.log.info("Undeployed per-version class loader: " + dep);
                    break;
                }
                if (!deps.isEmpty()) continue;
                i1.remove();
            }
        }
        this.recordUndeployed(null, undeployed);
    }

    private SharedDeployment createNewDeployment(GridDeploymentMetadata meta, boolean isCache) {
        GridDeploymentClassLoader clsLdr;
        assert (Thread.holdsLock(this.mux));
        assert (meta.parentLoader() == null);
        IgniteUuid ldrId = IgniteUuid.fromUuid(this.ctx.localNodeId());
        if (meta.deploymentMode() == DeploymentMode.CONTINUOUS || meta.participants() == null) {
            clsLdr = new GridDeploymentClassLoader(ldrId, meta.userVersion(), meta.deploymentMode(), false, this.ctx, this.ctx.config().getClassLoader() != null ? this.ctx.config().getClassLoader() : U.gridClassLoader(), meta.classLoaderId(), meta.senderNodeId(), this.comm, this.ctx.config().getNetworkTimeout(), this.log, this.ctx.config().getPeerClassLoadingLocalClassPathExclude(), this.ctx.config().getPeerClassLoadingMissedResourcesCacheSize(), meta.deploymentMode() == DeploymentMode.CONTINUOUS, false);
            if (meta.participants() != null) {
                for (Map.Entry<UUID, IgniteUuid> e : meta.participants().entrySet()) {
                    clsLdr.register(e.getKey(), e.getValue());
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Created class loader in CONTINUOUS mode or without participants [ldr=" + clsLdr + ", meta=" + meta + ']');
            }
        } else {
            assert (meta.deploymentMode() == DeploymentMode.SHARED);
            clsLdr = new GridDeploymentClassLoader(ldrId, meta.userVersion(), meta.deploymentMode(), false, this.ctx, U.gridClassLoader(), meta.participants(), this.comm, this.ctx.config().getNetworkTimeout(), this.log, this.ctx.config().getPeerClassLoadingLocalClassPathExclude(), this.ctx.config().getPeerClassLoadingMissedResourcesCacheSize(), false, false);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Created classloader in SHARED mode with participants [ldr=" + clsLdr + ", meta=" + meta + ']');
            }
        }
        SharedDeployment dep = new SharedDeployment(meta.deploymentMode(), clsLdr, ldrId, meta.userVersion(), meta.alias());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created new deployment: " + dep);
        }
        if (isCache) {
            List deps = F.addIfAbsent(this.cache, meta.userVersion(), new LinkedList());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Append new deployment: " + dep);
            }
            assert (deps != null);
            deps.add(dep);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Added deployment to cache: " + this.cache);
            }
        }
        return dep;
    }

    @Override
    public String toString() {
        return S.toString(GridDeploymentPerVersionStore.class, this);
    }

    private class SharedDeployment
    extends GridDeployment {
        private boolean rmv;

        SharedDeployment(DeploymentMode depMode, GridDeploymentClassLoader clsLdr, IgniteUuid clsLdrId, String userVer, String sampleClsName) {
            super(depMode, clsLdr, clsLdrId, userVer, sampleClsName, false);
        }

        @Override
        public GridDeploymentClassLoader classLoader() {
            return (GridDeploymentClassLoader)super.classLoader();
        }

        boolean addParticipant(UUID nodeId, IgniteUuid ldrId) {
            assert (nodeId != null);
            assert (ldrId != null);
            assert (Thread.holdsLock(GridDeploymentPerVersionStore.this.mux));
            if (!GridDeploymentPerVersionStore.this.deadClsLdrs.contains(ldrId)) {
                this.classLoader().register(nodeId, ldrId);
                return true;
            }
            return false;
        }

        void removeParticipant(UUID nodeId) {
            assert (nodeId != null);
            assert (Thread.holdsLock(GridDeploymentPerVersionStore.this.mux));
            IgniteUuid ldrId = this.classLoader().unregister(nodeId);
            if (GridDeploymentPerVersionStore.this.log.isDebugEnabled()) {
                GridDeploymentPerVersionStore.this.log.debug("Registering dead class loader ID: " + ldrId);
            }
            if (ldrId == null) {
                return;
            }
            GridDeploymentPerVersionStore.this.deadClsLdrs.add(ldrId);
            GridDeploymentPerVersionStore.this.rsrcCache.remove(ldrId);
        }

        Collection<UUID> getParticipantNodeIds() {
            assert (Thread.holdsLock(GridDeploymentPerVersionStore.this.mux));
            return this.classLoader().registeredNodeIds();
        }

        IgniteUuid getClassLoaderId(UUID nodeId) {
            assert (nodeId != null);
            assert (Thread.holdsLock(GridDeploymentPerVersionStore.this.mux));
            return this.classLoader().registeredClassLoaderId(nodeId);
        }

        Collection<IgniteUuid> getClassLoaderIds() {
            assert (Thread.holdsLock(GridDeploymentPerVersionStore.this.mux));
            return this.classLoader().registeredClassLoaderIds();
        }

        boolean hasParticipants() {
            assert (Thread.holdsLock(GridDeploymentPerVersionStore.this.mux));
            return this.classLoader().hasRegisteredNodes();
        }

        boolean hasParticipant(UUID nodeId, IgniteUuid ldrId) {
            assert (nodeId != null);
            assert (ldrId != null);
            return this.classLoader().hasRegisteredNode(nodeId, ldrId);
        }

        boolean isRemoved() {
            assert (Thread.holdsLock(GridDeploymentPerVersionStore.this.mux));
            return this.rmv;
        }

        void onRemoved() {
            assert (Thread.holdsLock(GridDeploymentPerVersionStore.this.mux));
            this.rmv = true;
            Collection<IgniteUuid> deadIds = this.classLoader().registeredClassLoaderIds();
            if (GridDeploymentPerVersionStore.this.log.isDebugEnabled()) {
                GridDeploymentPerVersionStore.this.log.debug("Registering dead class loader IDs: " + deadIds);
            }
            GridDeploymentPerVersionStore.this.deadClsLdrs.addAll(deadIds);
            for (IgniteUuid clsLdrId : deadIds) {
                GridDeploymentPerVersionStore.this.rsrcCache.remove(clsLdrId);
            }
        }

        @Override
        public void onDeployed(Class<?> cls) {
            int type;
            assert (!Thread.holdsLock(GridDeploymentPerVersionStore.this.mux));
            boolean isTask = GridDeploymentPerVersionStore.this.isTask(cls);
            String msg = (isTask ? "Task" : "Class") + " was deployed in SHARED or CONTINUOUS mode: " + cls;
            int n = type = isTask ? 33 : 30;
            if (GridDeploymentPerVersionStore.this.ctx.event().isRecordable(type)) {
                DeploymentEvent evt = new DeploymentEvent();
                evt.node(GridDeploymentPerVersionStore.this.ctx.discovery().localNode());
                evt.message(msg);
                evt.type(type);
                evt.alias(cls.getName());
                GridDeploymentPerVersionStore.this.ctx.event().record(evt);
            }
            if (GridDeploymentPerVersionStore.this.log.isInfoEnabled()) {
                GridDeploymentPerVersionStore.this.log.info(msg);
            }
        }

        void recordUndeployed(@Nullable UUID leftNodeId) {
            assert (!Thread.holdsLock(GridDeploymentPerVersionStore.this.mux));
            for (Map.Entry<String, Class<?>> depCls : this.deployedClassMap().entrySet()) {
                int type;
                boolean isTask = GridDeploymentPerVersionStore.this.isTask(depCls.getValue());
                String msg = (isTask ? "Task" : "Class") + " was undeployed in SHARED or CONTINUOUS mode [cls=" + depCls.getValue() + ", alias=" + depCls.getKey() + ']';
                int n = type = isTask ? 34 : 31;
                if (GridDeploymentPerVersionStore.this.ctx.event().isRecordable(type)) {
                    DeploymentEvent evt = new DeploymentEvent();
                    evt.node(GridDeploymentPerVersionStore.this.ctx.discovery().localNode());
                    evt.message(msg);
                    evt.type(type);
                    evt.alias(depCls.getKey());
                    GridDeploymentPerVersionStore.this.ctx.event().record(evt);
                }
                if (!GridDeploymentPerVersionStore.this.log.isInfoEnabled()) continue;
                GridDeploymentPerVersionStore.this.log.info(msg);
            }
            if (this.obsolete()) {
                GridDeploymentPerVersionStore.this.ctx.resource().onUndeployed(this);
                GridDeploymentClassLoader ldr = this.classLoader();
                GridDeploymentPerVersionStore.this.ctx.cache().onUndeployed(ldr);
                U.clearClassFromClassCache(GridDeploymentPerVersionStore.this.ctx.cache().context().deploy().globalLoader(), this.sampleClassName());
                for (String alias : this.deployedClassMap().keySet()) {
                    U.clearClassFromClassCache(GridDeploymentPerVersionStore.this.ctx.cache().context().deploy().globalLoader(), alias);
                }
                if (GridDeploymentPerVersionStore.this.ctx.config().getMarshaller() instanceof AbstractMarshaller) {
                    ((AbstractMarshaller)GridDeploymentPerVersionStore.this.ctx.config().getMarshaller()).onUndeploy(ldr);
                }
                GridDeploymentPerVersionStore.this.clearSerializationCaches();
                GridAnnotationsCache.onUndeployed(ldr);
                GridClassLoaderCache.onUndeployed(ldr);
            }
        }

        @Override
        public String toString() {
            return S.toString(SharedDeployment.class, this, "super", (Object)super.toString());
        }
    }
}

