/*
 * Decompiled with CFR 0.152.
 */
package com.gridgain.cdc.gg9togg8;

import com.gridgain.cdc.gg9togg8.ConversionService;
import com.gridgain.cdc.gg9togg8.ConversionServiceImpl;
import com.gridgain.cdc.gg9togg8.meta.Gg8TableMetadata;
import com.gridgain.cdc.gg9togg8.meta.Gg9TableMetadata;
import com.gridgain.cdc.gg9togg8.meta.MetadataUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignition;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.TableRowEvent;
import org.apache.ignite.table.Tuple;
import org.gridgain.internal.cdc.api.sink.SinkDefinition;
import org.gridgain.internal.cdc.api.sink.TableSink;

public class GridGain8TableSink
implements TableSink {
    private IgniteClient cl;
    private ConversionService conversionService;
    private ClientCache<Object, Object> cache;

    public void init(QualifiedName tableName, List<Column> columns, SinkDefinition sinkDefinition) {
        Map params = sinkDefinition.parameters().parameters();
        Config config = ConfigFactory.parseString((String)params.get("options"));
        List<String> addr = config.getStringList("options.clusterAddresses");
        Gg9TableMetadata gg9TabMeta = MetadataUtils.getGg9TableMetadata(tableName, columns);
        Gg8TableMetadata gg8TabMeta = MetadataUtils.getGg8TableMetadata(config);
        this.cl = Ignition.startClient(new ClientConfiguration().setAddresses((String[])addr.toArray(String[]::new)));
        this.cache = this.cl.cache(gg8TabMeta.cacheName());
        this.conversionService = new ConversionServiceImpl(gg8TabMeta, gg9TabMeta, this.cl.binary());
    }

    public void writeBatch(List<TableRowEvent<Map.Entry<Tuple, Tuple>>> events) {
        HashMap<Object, Object> batch = new HashMap<Object, Object>();
        block4: for (TableRowEvent<Map.Entry<Tuple, Tuple>> event : events) {
            switch (event.type()) {
                case CREATED: 
                case UPDATED: {
                    Map.Entry entry = (Map.Entry)event.entry();
                    Tuple key = (Tuple)entry.getKey();
                    Tuple val = (Tuple)entry.getValue();
                    Object resKey = this.conversionService.convertKeyTuple(key);
                    Object resVal = this.conversionService.convertValTuple(val);
                    batch.put(resKey, resVal);
                    continue block4;
                }
                case REMOVED: 
                case ARCHIVED: {
                    continue block4;
                }
            }
            throw new IllegalStateException("Unexpected event type: " + event.type());
        }
        if (!batch.isEmpty()) {
            this.cache.putAll(batch);
        }
    }

    public void flush() {
    }

    public void close() {
        this.cl.close();
    }
}

