/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.jetbrains.annotations.NotNull;

public class CompactedTopologyHistory
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int NEW_NODE = 0;
    private static final int DELTA_NODE = 1;
    private static final int SAME_NODE = 2;
    private SortedMap<Long, Collection<ClusterNode>> topHist;
    private long earliestTopVer;

    public CompactedTopologyHistory(@NotNull Map<Long, Collection<ClusterNode>> topHist) {
        assert (topHist instanceof SortedMap && !topHist.isEmpty()) : topHist + " is invalid";
        this.topHist = (SortedMap)topHist;
        this.earliestTopVer = this.topHist.firstKey();
    }

    public CompactedTopologyHistory() {
    }

    public SortedMap<Long, Collection<ClusterNode>> asMap() {
        return this.topHist;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.earliestTopVer);
        int size = this.topHist.size();
        out.writeInt(size);
        HashMap<Object, TcpDiscoveryNode> nodesMap = new HashMap<Object, TcpDiscoveryNode>();
        for (Map.Entry<Long, Collection<ClusterNode>> entry : this.topHist.entrySet()) {
            long ver = entry.getKey();
            Collection<ClusterNode> top = entry.getValue();
            out.writeInt((int)(ver - this.earliestTopVer));
            out.writeInt(top.size());
            for (ClusterNode clusterNode : top) {
                TcpDiscoveryNode newNode = (TcpDiscoveryNode)clusterNode;
                Object consistentId = newNode.consistentId();
                TcpDiscoveryNode oldNode = (TcpDiscoveryNode)nodesMap.get(consistentId);
                if (oldNode == null) {
                    nodesMap.put(consistentId, newNode);
                    out.write(0);
                    CompactedTopologyHistory.writeTcpDiscoveryNode(out, newNode);
                    continue;
                }
                if (oldNode != newNode) {
                    nodesMap.put(consistentId, newNode);
                    out.write(1);
                    CompactedTopologyHistory.writeTcpDiscoveryNode(out, CompactedTopologyHistory.diff(oldNode, newNode));
                    continue;
                }
                out.write(2);
                out.writeObject(consistentId);
            }
        }
    }

    private static void writeTcpDiscoveryNode(ObjectOutput out, TcpDiscoveryNode node) throws IOException {
        node.writeExternal(out);
    }

    private static TcpDiscoveryNode readTcpDiscoveryNode(ObjectInput in) throws IOException, ClassNotFoundException {
        TcpDiscoveryNode node = new TcpDiscoveryNode();
        node.readExternal(in);
        return node;
    }

    private static TcpDiscoveryNode diff(TcpDiscoveryNode oldNode, TcpDiscoveryNode newNode) {
        Map<String, Object> oldAttrs = oldNode.getAttributes();
        Map<String, Object> newAttrs = newNode.getAttributes();
        DiffState diffState = new DiffState();
        newAttrs.forEach((key, val) -> {
            Object oldAttr = oldAttrs.get(key);
            boolean oldAttrsContainKey = oldAttr != null || oldAttrs.containsKey(key);
            diffState.hasAllKeys &= oldAttrsContainKey;
            if (!oldAttrsContainKey || !Objects.deepEquals(oldAttr, val)) {
                if (diffState.delta == null) {
                    diffState.delta = new HashMap<String, Object>(4);
                }
                diffState.delta.put((String)key, val);
            }
        });
        if (!diffState.hasAllKeys || oldAttrs.size() != newAttrs.size()) {
            oldAttrs.forEach((k, v) -> {
                if (!newAttrs.containsKey(k)) {
                    if (diffState.delta == null) {
                        diffState.delta = new HashMap<String, Object>(4);
                    }
                    diffState.delta.put((String)k, null);
                }
            });
        }
        if (diffState.delta == null) {
            diffState.delta = Collections.singletonMap("org.apache.ignite.consistent.id", oldNode.consistentId());
        } else {
            diffState.delta.put("org.apache.ignite.consistent.id", oldNode.consistentId());
        }
        TcpDiscoveryNode res = TcpDiscoveryNode.copy(newNode);
        res.setAttributesNoCopy(diffState.delta);
        return res;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.topHist = new TreeMap<Long, Collection<ClusterNode>>();
        this.earliestTopVer = in.readLong();
        int size = in.readInt();
        HashMap<Object, TcpDiscoveryNode> nodesMap = new HashMap<Object, TcpDiscoveryNode>();
        for (int i = 0; i < size; ++i) {
            long ver = this.earliestTopVer + (long)in.readInt();
            int topSize = in.readInt();
            ArrayList<TcpDiscoveryNode> top = new ArrayList<TcpDiscoveryNode>(topSize);
            block6: for (int j = 0; j < topSize; ++j) {
                int type = in.read();
                switch (type) {
                    case 0: {
                        TcpDiscoveryNode node = CompactedTopologyHistory.readTcpDiscoveryNode(in);
                        nodesMap.put(node.consistentId(), node);
                        top.add(node);
                        continue block6;
                    }
                    case 1: {
                        TcpDiscoveryNode newNode = CompactedTopologyHistory.readTcpDiscoveryNode(in);
                        TcpDiscoveryNode oldNode = (TcpDiscoveryNode)nodesMap.get(newNode.consistentId());
                        assert (oldNode != null) : "Can't find old node while deserializing compacted topology history [consistentId=" + newNode.consistentId() + ']';
                        HashMap<String, Object> newAttrs = new HashMap<String, Object>(oldNode.getAttributes());
                        newNode.getAttributes().forEach((k, v) -> {
                            if (v != null) {
                                newAttrs.put((String)k, v);
                            } else {
                                newAttrs.remove(k);
                            }
                        });
                        newNode.setAttributesNoCopy(newAttrs);
                        nodesMap.put(newNode.consistentId(), newNode);
                        top.add(newNode);
                        continue block6;
                    }
                    case 2: {
                        Object consistentId = in.readObject();
                        TcpDiscoveryNode oldNode = (TcpDiscoveryNode)nodesMap.get(consistentId);
                        assert (oldNode != null) : "Can't find old node while deserializing compacted topology history [consistentId=" + consistentId + ']';
                        top.add(oldNode);
                        continue block6;
                    }
                    default: {
                        throw new IOException("Unexpected node serialization type: " + type);
                    }
                }
            }
            this.topHist.put(ver, top);
        }
    }

    private static class DiffState {
        boolean hasAllKeys = true;
        Map<String, Object> delta = null;

        private DiffState() {
        }
    }
}

