/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.client.message;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.processors.rest.client.message.GridClientAbstractMessage;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridClientClusterStateRequestV2
extends GridClientAbstractMessage {
    private static final long serialVersionUID = 0L;
    private boolean forceDeactivation;
    private boolean reqCurrentState;
    private ClusterState state;

    public boolean isReqCurrentState() {
        return this.reqCurrentState;
    }

    public ClusterState state() {
        return this.state;
    }

    public static GridClientClusterStateRequestV2 state(ClusterState state, boolean forceDeactivation) {
        GridClientClusterStateRequestV2 req = new GridClientClusterStateRequestV2();
        req.state = state;
        req.forceDeactivation = forceDeactivation;
        return req;
    }

    public static GridClientClusterStateRequestV2 currentState() {
        GridClientClusterStateRequestV2 msg = new GridClientClusterStateRequestV2();
        msg.reqCurrentState = true;
        return msg;
    }

    public static GridClientClusterStateRequestV2 state(ClusterState state) {
        GridClientClusterStateRequestV2 msg = new GridClientClusterStateRequestV2();
        msg.state = state;
        return msg;
    }

    public boolean forceDeactivation() {
        return this.forceDeactivation;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.reqCurrentState);
        U.writeEnum(out, this.state);
        out.writeBoolean(this.forceDeactivation);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.reqCurrentState = in.readBoolean();
        this.state = ClusterState.fromOrdinal(in.readByte());
        this.forceDeactivation = in.readBoolean();
    }
}

