/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.resource;

import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteServicesEx;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.processors.resource.GridResourceBasicInjector;
import org.apache.ignite.internal.processors.resource.GridResourceField;
import org.apache.ignite.internal.processors.resource.GridResourceMethod;
import org.apache.ignite.internal.processors.resource.GridResourceUtils;
import org.apache.ignite.internal.processors.service.ServiceCallContextHolder;
import org.apache.ignite.resources.ServiceResource;
import org.apache.ignite.services.Service;
import org.jetbrains.annotations.Nullable;

public class GridResourceServiceInjector
extends GridResourceBasicInjector<Collection<Service>> {
    private IgniteEx ignite;

    public GridResourceServiceInjector(IgniteEx ignite) {
        super(null);
        this.ignite = ignite;
    }

    @Override
    public void inject(GridResourceField field, Object target, Class<?> depCls, GridDeployment dep) throws IgniteCheckedException {
        Object svc = this.getService((ServiceResource)field.getAnnotation());
        if (svc != null) {
            GridResourceUtils.inject(field.getField(), target, svc);
        }
    }

    @Override
    public void inject(GridResourceMethod mtd, Object target, Class<?> depCls, GridDeployment dep) throws IgniteCheckedException {
        Object svc = this.getService((ServiceResource)mtd.getAnnotation());
        if (svc != null) {
            GridResourceUtils.inject(mtd.getMethod(), target, svc);
        }
    }

    @Nullable
    private <T> T getService(ServiceResource ann) {
        if (ann.proxyInterface() == Void.class) {
            return this.ignite.services().service(ann.serviceName());
        }
        return (T)((IgniteServicesEx)this.ignite.services()).serviceProxy(ann.serviceName(), ann.proxyInterface(), ann.proxySticky(), ann.forwardCallerContext() ? ServiceCallContextHolder::current : null, 0L);
    }
}

