/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.datastructures;

import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.CollectionConfiguration;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheSetProxy;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;

public class ClientIgniteSetGetOrCreateRequest
extends ClientRequest {
    private final String name;
    private final CollectionConfiguration collectionConfiguration;

    public ClientIgniteSetGetOrCreateRequest(BinaryRawReader reader) {
        super(reader);
        this.name = reader.readString();
        boolean create = reader.readBoolean();
        this.collectionConfiguration = create ? new CollectionConfiguration().setAtomicityMode(CacheAtomicityMode.fromOrdinal(reader.readByte())).setCacheMode(CacheMode.fromOrdinal(reader.readByte())).setBackups(reader.readInt()).setGroupName(reader.readString()).setCollocated(reader.readBoolean()) : null;
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        GridCacheSetProxy set = (GridCacheSetProxy)ctx.kernalContext().grid().set(this.name, this.collectionConfiguration);
        if (set == null) {
            return new Response(this.requestId(), false, null);
        }
        return new Response(this.requestId(), set.collocated(), set.delegate().context().cacheId());
    }

    private static class Response
    extends ClientResponse {
        private final boolean collocated;
        private final Integer cacheId;

        public Response(long reqId, boolean collocated, Integer cacheId) {
            super(reqId);
            this.collocated = collocated;
            this.cacheId = cacheId;
        }

        @Override
        public void encode(ClientConnectionContext ctx, BinaryRawWriterEx writer) {
            super.encode(ctx, writer);
            if (this.cacheId != null) {
                writer.writeBoolean(true);
                writer.writeBoolean(this.collocated);
                writer.writeInt(this.cacheId);
            } else {
                writer.writeBoolean(false);
            }
        }
    }
}

