/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metastorage.persistence;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

final class DistributedMetaStorageHistoryItem
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    public static final DistributedMetaStorageHistoryItem[] EMPTY_ARRAY = new DistributedMetaStorageHistoryItem[0];
    @GridToStringInclude
    public String[] keys;
    @GridToStringInclude
    public byte[][] valBytesArray;
    private transient long longHash;

    public DistributedMetaStorageHistoryItem() {
    }

    public DistributedMetaStorageHistoryItem(String key, byte[] valBytes) {
        this.keys = new String[]{key};
        this.valBytesArray = new byte[][]{valBytes};
    }

    public DistributedMetaStorageHistoryItem(String[] keys, byte[][] valBytesArray) {
        assert (keys.length == valBytesArray.length);
        this.keys = keys;
        this.valBytesArray = valBytesArray;
    }

    public long estimateSize() {
        int len = this.keys.length;
        long size = 8L + 8L * (long)len;
        for (int i = 0; i < len; ++i) {
            size += (long)(this.keys[i].length() * 2 + (this.valBytesArray[i] == null ? 0 : this.valBytesArray[i].length));
        }
        return size;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeInt(this.keys.length);
        for (int i = 0; i < this.keys.length; ++i) {
            U.writeString(out, this.keys[i]);
            U.writeByteArray(out, this.valBytesArray[i]);
        }
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException {
        int len = in.readInt();
        this.keys = new String[len];
        this.valBytesArray = new byte[len][];
        for (int i = 0; i < len; ++i) {
            this.keys[i] = U.readString(in);
            this.valBytesArray[i] = U.readByteArray(in);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributedMetaStorageHistoryItem item = (DistributedMetaStorageHistoryItem)o;
        return Arrays.equals(this.keys, item.keys) && Arrays.deepEquals((Object[])this.valBytesArray, (Object[])item.valBytesArray);
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.keys) + Arrays.deepHashCode((Object[])this.valBytesArray);
    }

    public long longHash() {
        long hash = this.longHash;
        if (hash == 0L) {
            hash = 1L;
            for (String key : this.keys) {
                hash = hash * 31L + (long)key.hashCode();
            }
            for (byte[] valBytes : this.valBytesArray) {
                if (valBytes == null) {
                    hash *= 31L;
                    continue;
                }
                for (byte b : valBytes) {
                    hash = hash * 31L + (long)b;
                }
            }
            if (hash == 0L) {
                hash = 1L;
            }
            this.longHash = hash;
        }
        return hash;
    }

    public String toString() {
        return S.toString(DistributedMetaStorageHistoryItem.class, this);
    }
}

