/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.continuous;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfo;
import org.apache.ignite.internal.processors.continuous.GridContinuousHandler;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.marshaller.Marshaller;
import org.jetbrains.annotations.Nullable;

class StartRequestData
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private IgnitePredicate<ClusterNode> prjPred;
    private byte[] prjPredBytes;
    private String clsName;
    private GridDeploymentInfo depInfo;
    private GridContinuousHandler hnd;
    private int bufSize;
    private long interval;
    private boolean autoUnsubscribe;

    public StartRequestData() {
    }

    StartRequestData(@Nullable IgnitePredicate<ClusterNode> prjPred, GridContinuousHandler hnd, int bufSize, long interval, boolean autoUnsubscribe) {
        assert (hnd != null);
        assert (bufSize > 0);
        assert (interval >= 0L);
        this.prjPred = prjPred;
        this.hnd = hnd;
        this.bufSize = bufSize;
        this.interval = interval;
        this.autoUnsubscribe = autoUnsubscribe;
    }

    void p2pMarshal(Marshaller marsh) throws IgniteCheckedException {
        assert (marsh != null);
        this.prjPredBytes = U.marshal(marsh, this.prjPred);
    }

    void p2pUnmarshal(Marshaller marsh, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        assert (marsh != null);
        assert (this.prjPred == null);
        assert (this.prjPredBytes != null);
        this.prjPred = (IgnitePredicate)U.unmarshal(marsh, this.prjPredBytes, ldr);
    }

    public IgnitePredicate<ClusterNode> projectionPredicate() {
        return this.prjPred;
    }

    public void projectionPredicate(IgnitePredicate<ClusterNode> prjPred) {
        this.prjPred = prjPred;
    }

    public byte[] projectionPredicateBytes() {
        return this.prjPredBytes;
    }

    public void projectionPredicateBytes(byte[] prjPredBytes) {
        this.prjPredBytes = prjPredBytes;
    }

    public String className() {
        return this.clsName;
    }

    public void className(String clsName) {
        this.clsName = clsName;
    }

    public GridDeploymentInfo deploymentInfo() {
        return this.depInfo;
    }

    public void deploymentInfo(GridDeploymentInfo depInfo) {
        this.depInfo = depInfo;
    }

    public GridContinuousHandler handler() {
        return this.hnd;
    }

    public void handler(GridContinuousHandler hnd) {
        this.hnd = hnd;
    }

    public int bufferSize() {
        return this.bufSize;
    }

    public void bufferSize(int bufSize) {
        this.bufSize = bufSize;
    }

    public long interval() {
        return this.interval;
    }

    public void interval(long interval) {
        this.interval = interval;
    }

    public boolean autoUnsubscribe() {
        return this.autoUnsubscribe;
    }

    public void autoUnsubscribe(boolean autoUnsubscribe) {
        this.autoUnsubscribe = autoUnsubscribe;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        boolean b = this.prjPredBytes != null;
        out.writeBoolean(b);
        if (b) {
            U.writeByteArray(out, this.prjPredBytes);
            U.writeString(out, this.clsName);
            out.writeObject(this.depInfo);
        } else {
            out.writeObject(this.prjPred);
        }
        out.writeObject(this.hnd);
        out.writeInt(this.bufSize);
        out.writeLong(this.interval);
        out.writeBoolean(this.autoUnsubscribe);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean b = in.readBoolean();
        if (b) {
            this.prjPredBytes = U.readByteArray(in);
            this.clsName = U.readString(in);
            this.depInfo = (GridDeploymentInfo)in.readObject();
        } else {
            this.prjPred = (IgnitePredicate)in.readObject();
        }
        this.hnd = (GridContinuousHandler)in.readObject();
        this.bufSize = in.readInt();
        this.interval = in.readLong();
        this.autoUnsubscribe = in.readBoolean();
    }

    public String toString() {
        return S.toString(StartRequestData.class, this);
    }
}

