/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cluster.DistributedBaselineConfiguration;
import org.apache.ignite.internal.processors.cluster.GridClusterStateProcessor;
import org.apache.ignite.mxbean.BaselineAutoAdjustMXBean;

public class BaselineAutoAdjustMXBeanImpl
implements BaselineAutoAdjustMXBean {
    private final DistributedBaselineConfiguration baselineConfiguration;
    private final GridClusterStateProcessor state;
    private final GridKernalContext ctx;

    public BaselineAutoAdjustMXBeanImpl(GridKernalContext ctx) {
        this.baselineConfiguration = ctx.state().baselineConfiguration();
        this.state = ctx.state();
        this.ctx = ctx;
    }

    @Override
    public boolean isAutoAdjustmentEnabled() {
        return this.baselineConfiguration.isBaselineAutoAdjustEnabled();
    }

    @Override
    public long getAutoAdjustmentTimeout() {
        return this.baselineConfiguration.getBaselineAutoAdjustTimeout();
    }

    @Override
    public long getTimeUntilAutoAdjust() {
        return this.state.baselineAutoAdjustStatus().getTimeUntilAutoAdjust();
    }

    @Override
    public String getTaskState() {
        return this.state.baselineAutoAdjustStatus().getTaskState().toString();
    }

    @Override
    public void setAutoAdjustmentEnabled(boolean enabled) {
        try {
            this.baselineConfiguration.updateBaselineAutoAdjustEnabledAsync(this.ctx, enabled).get();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public void setAutoAdjustmentTimeout(long timeout) {
        try {
            this.baselineConfiguration.updateBaselineAutoAdjustTimeoutAsync(this.ctx, timeout).get();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }
}

