/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree.updatelog;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerManager;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.CorruptedTreeException;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.tree.updatelog.CacheIdAwareUpdateLogInnerIO;
import org.apache.ignite.internal.processors.cache.tree.updatelog.CacheIdAwareUpdateLogLeafIO;
import org.apache.ignite.internal.processors.cache.tree.updatelog.DuplicateUpdateCounterException;
import org.apache.ignite.internal.processors.cache.tree.updatelog.UpdateLogInnerIO;
import org.apache.ignite.internal.processors.cache.tree.updatelog.UpdateLogLeafIO;
import org.apache.ignite.internal.processors.cache.tree.updatelog.UpdateLogRow;
import org.apache.ignite.internal.processors.cache.tree.updatelog.UpdateLogRowIO;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.maintenance.MaintenanceTask;

public class PartitionLogTree
extends BPlusTree<UpdateLogRow, UpdateLogRow> {
    public static final String PART_LOG_TREE_REBUILD_MNTC_TASK_NAME = "PartitionLogTreeRebuildMaintenanceTask";
    public static final String PART_LOG_TREE_CLEANUP_MNTC_TASK_NAME = "PartitionLogTreeCleanupMaintenanceTask";
    public static final String PARAMETER_SEPARATOR = "|";
    public static final String PARAMETER_SEPARATOR_REGEX = "\\|";
    public static final String TASK_DESCRIPTION = "Partition log tree rebuild";
    public static final String CLEANUP_TASK_DESCRIPTION = "Partition log tree cleanup";
    public static final Object FULL_ROW = new Object();
    private final CacheGroupContext grp;
    private final int part;
    private final boolean strictConsistencyCheck = IgniteSystemProperties.getBoolean("IGNITE_STRICT_CONSISTENCY_CHECK");
    private final IgniteLogger log;

    public PartitionLogTree(CacheGroupContext grp, int part, String name, PageMemory pageMem, long metaPageId, ReuseList reuseList, boolean initNew, PageLockTrackerManager pageLockTrackerManager, byte pageFlag, IgniteLogger log) throws IgniteCheckedException {
        super(name, grp.groupId(), grp.name(), pageMem, grp.dataRegion().config().isPersistenceEnabled() ? grp.shared().wal() : null, grp.offheap().globalRemoveId(), metaPageId, reuseList, grp.sharedGroup() ? CacheIdAwareUpdateLogInnerIO.VERSIONS : UpdateLogInnerIO.VERSIONS, grp.sharedGroup() ? CacheIdAwareUpdateLogLeafIO.VERSIONS : UpdateLogLeafIO.VERSIONS, pageFlag, grp.shared().kernalContext().failure(), pageLockTrackerManager);
        this.part = part;
        this.grp = grp;
        this.log = log;
        assert (!grp.dataRegion().config().isPersistenceEnabled() || grp.shared().database().checkpointLockIsHeldByThread());
        this.initTree(initNew);
    }

    @Override
    protected int compare(BPlusIO<UpdateLogRow> iox, long pageAddr, int idx, UpdateLogRow row) {
        long updCntr;
        int cmp;
        UpdateLogRowIO io = (UpdateLogRowIO)((Object)iox);
        if (this.grp.sharedGroup()) {
            assert (row.cacheId != 0) : "Cache ID is not provided!";
            assert (io.getCacheId(pageAddr, idx) != 0) : "Cache ID is not stored!";
            cmp = Integer.compare(io.getCacheId(pageAddr, idx), row.cacheId);
            if (cmp != 0) {
                return cmp;
            }
            if (row.updCntr == 0L && row.link == 0L) {
                return cmp;
            }
        }
        if ((cmp = Long.compare(updCntr = io.getUpdateCounter(pageAddr, idx), row.updCntr)) == 0 && row.link != 0L && io.getLink(pageAddr, idx) != row.link) {
            String msg = "Duplicate update counter at update log tree [grp=" + this.grp.cacheOrGroupName() + ", part=" + this.part + ", updCounter=" + updCntr + 93;
            if (this.strictConsistencyCheck) {
                throw new DuplicateUpdateCounterException(msg);
            }
            this.log.warning(msg);
        }
        return cmp;
    }

    @Override
    public UpdateLogRow getRow(BPlusIO<UpdateLogRow> io, long pageAddr, int idx, Object flag) throws IgniteCheckedException {
        UpdateLogRow row = io.getLookupRow(this, pageAddr, idx);
        return flag == FULL_ROW ? row.initRow(this.grp) : row;
    }

    @Override
    protected CorruptedTreeException corruptedTreeException(String msg, Throwable cause, int grpId, long ... pageIds) {
        if (cause instanceof DuplicateUpdateCounterException) {
            return super.corruptedTreeException(msg, cause, grpId, pageIds);
        }
        CorruptedTreeException e = new CorruptedTreeException(msg, cause, this.grpName, null, this.name(), grpId, pageIds);
        String errorMsg = "Partition log tree of partition `" + this.part + "` of cache group `" + this.grpName + "` is corrupted, to fix this issue a rebuild is required. On the next restart, node will enter the maintenance mode and rebuild corrupted tree.";
        this.log.warning(errorMsg);
        try {
            MaintenanceTask task = PartitionLogTree.toMaintenanceTask(grpId);
            this.grp.shared().kernalContext().maintenanceRegistry().registerMaintenanceTask(task, oldTask -> PartitionLogTree.mergeTasks(oldTask, task));
        }
        catch (IgniteCheckedException ex) {
            this.log.warning("Failed to register maintenance record for corrupted partition files.", ex);
        }
        this.processFailure(FailureType.CRITICAL_ERROR, e);
        return e;
    }

    public static MaintenanceTask toMaintenanceTask(int groupId) {
        return new MaintenanceTask(PART_LOG_TREE_REBUILD_MNTC_TASK_NAME, TASK_DESCRIPTION, U.hexInt(groupId));
    }

    public static MaintenanceTask toMaintenanceTask(Set<Integer> groupIds) {
        assert (!groupIds.isEmpty());
        return new MaintenanceTask(PART_LOG_TREE_REBUILD_MNTC_TASK_NAME, TASK_DESCRIPTION, groupIds.stream().map(IgniteUtils::hexInt).collect(Collectors.joining(PARAMETER_SEPARATOR)));
    }

    public static MaintenanceTask toCleanupMaintenanceTask(Set<Integer> groupIds) {
        assert (!groupIds.isEmpty());
        return new MaintenanceTask(PART_LOG_TREE_CLEANUP_MNTC_TASK_NAME, CLEANUP_TASK_DESCRIPTION, groupIds.stream().map(IgniteUtils::hexInt).collect(Collectors.joining(PARAMETER_SEPARATOR)));
    }

    public static MaintenanceTask mergeTasks(MaintenanceTask oldTask, MaintenanceTask newTask) {
        assert (Objects.equals(PART_LOG_TREE_REBUILD_MNTC_TASK_NAME, oldTask.name()));
        assert (Objects.equals(oldTask.name(), newTask.name()));
        return PartitionLogTree.mergeTaskParameters(oldTask, newTask);
    }

    public static MaintenanceTask mergeCleanupTasks(MaintenanceTask oldTask, MaintenanceTask newTask) {
        assert (Objects.equals(PART_LOG_TREE_CLEANUP_MNTC_TASK_NAME, oldTask.name()));
        assert (Objects.equals(oldTask.name(), newTask.name()));
        return PartitionLogTree.mergeTaskParameters(oldTask, newTask);
    }

    private static MaintenanceTask mergeTaskParameters(MaintenanceTask oldTask, MaintenanceTask newTask) {
        String oldTaskParams = oldTask.parameters();
        String newTaskParams = newTask.parameters();
        assert (oldTaskParams != null);
        assert (newTaskParams != null);
        if (oldTaskParams.contains(newTaskParams)) {
            return oldTask;
        }
        String mergedParams = Stream.concat(Arrays.stream(oldTaskParams.split(PARAMETER_SEPARATOR_REGEX)), Arrays.stream(newTaskParams.split(PARAMETER_SEPARATOR_REGEX))).distinct().collect(Collectors.joining(PARAMETER_SEPARATOR));
        return new MaintenanceTask(oldTask.name(), oldTask.description(), mergedParams);
    }
}

