/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIO;
import org.apache.ignite.internal.util.GridStringBuilder;

public class PageMetaIOV2
extends PageMetaIO {
    private static final int ENCRYPT_PAGE_IDX_OFF = 104;
    private static final int ENCRYPT_PAGE_MAX_OFF = 108;

    public PageMetaIOV2(int ver) {
        super(ver);
    }

    public int getEncryptedPageIndex(long pageAddr) {
        return PageUtils.getInt(pageAddr, 104);
    }

    public boolean setEncryptedPageIndex(long pageAddr, int pageIdx) {
        this.assertPageType(pageAddr);
        if (this.getEncryptedPageIndex(pageAddr) == pageIdx) {
            return false;
        }
        PageUtils.putLong(pageAddr, 104, pageIdx);
        return true;
    }

    public int getEncryptedPageCount(long pageAddr) {
        return PageUtils.getInt(pageAddr, 108);
    }

    public boolean setEncryptedPageCount(long pageAddr, int pagesCnt) {
        this.assertPageType(pageAddr);
        if (this.getEncryptedPageCount(pageAddr) == pagesCnt) {
            return false;
        }
        PageUtils.putInt(pageAddr, 108, pagesCnt);
        return true;
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize, PageMetrics metrics) {
        super.initNewPage(pageAddr, pageId, pageSize, metrics);
        this.setEncryptedPageCount(pageAddr, 0);
        this.setEncryptedPageIndex(pageAddr, 0);
    }

    @Override
    protected void printPage(long addr, int pageSize, GridStringBuilder sb) {
        sb.a("PageMeta[\n\ttreeRoot=").a(this.getTreeRoot(addr)).a(",\n\treuseListRoot=").a(this.getReuseListRoot(addr)).a(",\n\tlastSuccessfulFullSnapshotId=").a(this.getLastSuccessfulFullSnapshotId(addr)).a(",\n\tlastSuccessfulSnapshotId=").a(this.getLastSuccessfulSnapshotId(addr)).a(",\n\tnextSnapshotTag=").a(this.getNextSnapshotTag(addr)).a(",\n\tlastSuccessfulSnapshotTag=").a(this.getLastSuccessfulSnapshotTag(addr)).a(",\n\tlastAllocatedPageCount=").a(this.getLastAllocatedPageCount(addr)).a(",\n\tcandidatePageCount=").a(this.getCandidatePageCount(addr)).a(",\n\tencryptedPageCount=").a(this.getEncryptedPageCount(addr)).a(",\n\tencryptedPageIndex=").a(this.getEncryptedPageIndex(addr)).a("\n]");
    }

    public void upgradePage(long pageAddr) {
        this.assertPageType(pageAddr);
        assert (PageIO.getType(pageAddr) == this.getType());
        PageIO.setVersion(pageAddr, this.getVersion());
        this.setEncryptedPageIndex(pageAddr, 0);
        this.setEncryptedPageCount(pageAddr, 0);
    }
}

