/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.topology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.SystemProperty;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheMetricsImpl;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.tree.PendingRow;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.lang.IgniteClosure2X;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.apache.ignite.util.deque.FastSizeDeque;
import org.jetbrains.annotations.Nullable;

public class PartitionsEvictManager
extends GridCacheSharedManagerAdapter {
    private static final int DEFAULT_SHOW_EVICTION_PROGRESS_FREQ_MS = 120000;
    @SystemProperty(value="Eviction progress frequency in milliseconds", type=Long.class, defaults="120000")
    public static final String SHOW_EVICTION_PROGRESS_FREQ = "SHOW_EVICTION_PROGRESS_FREQ";
    private final long evictionProgressFreqMs = IgniteSystemProperties.getLong("SHOW_EVICTION_PROGRESS_FREQ", 120000L);
    private final AtomicBoolean showProgressGuard = new AtomicBoolean();
    private static final int MAX_EVICT_QUEUE_SIZE = IgniteSystemProperties.getInteger("MAX_EVICT_QUEUE_SIZE", 10000);
    private static final IgniteUuid FILL_EVICT_QUEUE_TASK_ID_TTL = IgniteUuid.randomUuid();
    private static final IgniteUuid FILL_EVICT_QUEUE_TASK_ID_TOMBSTONE = IgniteUuid.randomUuid();
    private final int processEmptyEvictQueueFreq = IgniteSystemProperties.getInteger("PROCESS_EMPTY_EVICT_QUEUE_FREQ", 500);
    private long lastShowProgressTimeNanos = System.nanoTime() - U.millisToNanos(this.evictionProgressFreqMs);
    private final Map<Integer, GroupEvictionContext> evictionGroupsMap = new ConcurrentHashMap<Integer, GroupEvictionContext>();
    private final Map<Integer, Map<Integer, EvictReason>> logEvictPartByGrps = new HashMap<Integer, Map<Integer, EvictReason>>();
    private final Object mux = new Object();
    private volatile IgniteThreadPoolExecutor executor;
    private final ConcurrentMap<PartitionKey, PartitionEvictionTask> futs = new ConcurrentHashMap<PartitionKey, PartitionEvictionTask>();
    private FastSizeDeque<PendingRow> tombstoneEvictQueue = new FastSizeDeque(new ConcurrentLinkedDeque());
    private FastSizeDeque<PendingRow> ttlEvictQueue = new FastSizeDeque(new ConcurrentLinkedDeque());
    private static final BiConsumer<EvictReason, CacheMetricsImpl> INCREMENT = new BiConsumer<EvictReason, CacheMetricsImpl>(){

        @Override
        public void accept(EvictReason reason, CacheMetricsImpl cacheMetrics) {
            if (reason == EvictReason.CLEARING) {
                cacheMetrics.incrementRebalanceClearingPartitions();
            } else {
                cacheMetrics.incrementEvictingPartitions();
            }
        }
    };
    private static final BiConsumer<EvictReason, CacheMetricsImpl> DECREMENT = new BiConsumer<EvictReason, CacheMetricsImpl>(){

        @Override
        public void accept(EvictReason reason, CacheMetricsImpl cacheMetrics) {
            if (reason == EvictReason.CLEARING) {
                cacheMetrics.decrementRebalanceClearingPartitions();
            } else {
                cacheMetrics.decrementEvictingPartitions();
            }
        }
    };

    public void onCacheGroupStarted(CacheGroupContext grp) {
        this.evictionGroupsMap.put(grp.groupId(), new GroupEvictionContext(grp));
    }

    public void onCacheGroupStopped(CacheGroupContext grp) {
        GroupEvictionContext grpEvictionCtx = this.evictionGroupsMap.computeIfAbsent(grp.groupId(), p -> new GroupEvictionContext(grp));
        grpEvictionCtx.stop(new CacheStoppedException(grp.cacheOrGroupName()));
    }

    public PartitionEvictionTask clearTombstonesAsync(CacheGroupContext grp, GridDhtLocalPartition part) {
        assert (grp.supportsTombstone()) : grp;
        PartitionEvictionTask task = this.scheduleEviction(grp, part, EvictReason.TOMBSTONE);
        task.start();
        return task;
    }

    public PartitionEvictionTask scheduleEviction(CacheGroupContext grp, GridDhtLocalPartition part, EvictReason reason) {
        assert (Objects.nonNull(grp));
        assert (Objects.nonNull(part));
        int grpId = grp.groupId();
        GroupEvictionContext grpEvictionCtx = this.evictionGroupsMap.computeIfAbsent(grpId, k -> new GroupEvictionContext(grp));
        PartitionKey key = new PartitionKey(grp.groupId(), part.id());
        GridFutureAdapter finishFut = new GridFutureAdapter();
        PartitionEvictionTask task = new PartitionEvictionTask(part, grpEvictionCtx, reason, finishFut);
        finishFut.listen(fut -> {
            PartitionEvictionTask cfr_ignored_0 = (PartitionEvictionTask)this.futs.remove(key);
        });
        while (true) {
            if (grp.cacheObjectContext().kernalContext().isStopping()) {
                finishFut.onDone(new NodeStoppingException("Node is stopping"));
                return task;
            }
            PartitionEvictionTask prev = this.futs.putIfAbsent(key, task);
            if (prev == null) {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug("Enqueued partition clearing [grp=" + grp.cacheOrGroupName() + ", task=" + task + ']');
                break;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cancelling the clearing [grp=" + grp.cacheOrGroupName() + ", topVer=" + (grp.topology().initialized() ? grp.topology().readyTopologyVersion() : "NA") + ", task=" + task + ", prev=" + prev + ']');
            }
            prev.cancel();
            prev.awaitCompletion();
        }
        if (part.state() == GridDhtPartitionState.EVICTED && reason == EvictReason.EVICTION) {
            finishFut.onDone();
            return task;
        }
        if (this.cctx.cache().cacheGroup(grpId) == null) {
            finishFut.onDone(new CacheStoppedException(grp.cacheOrGroupName()));
            return task;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("The partition has been scheduled for clearing [grp=" + grp.cacheOrGroupName() + ", topVer=" + (grp.topology().initialized() ? grp.topology().readyTopologyVersion() : "NA") + ", task" + task + ']');
        }
        return task;
    }

    @Nullable
    public PartitionEvictionTask clearingTask(int grpId, int partId) {
        return (PartitionEvictionTask)this.futs.get(new PartitionKey(grpId, partId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showProgress() {
        if (U.millisSinceNanos(this.lastShowProgressTimeNanos) >= this.evictionProgressFreqMs && this.showProgressGuard.compareAndSet(false, true)) {
            int size = this.executor.getQueue().size();
            if (this.log.isInfoEnabled()) {
                this.log.info("Eviction in progress [groups=" + this.evictionGroupsMap.keySet().size() + ", remainingPartsToEvict=" + size + ']');
                this.evictionGroupsMap.values().forEach(rec$ -> ((GroupEvictionContext)rec$).showProgress());
                Object object = this.mux;
                synchronized (object) {
                    if (!this.logEvictPartByGrps.isEmpty()) {
                        StringJoiner evictPartJoiner = new StringJoiner(", ");
                        this.logEvictPartByGrps.forEach((grpId, map) -> {
                            CacheGroupContext grpCtx = this.cctx.cache().cacheGroup((int)grpId);
                            String grpName = Objects.nonNull(grpCtx) ? grpCtx.cacheOrGroupName() : null;
                            evictPartJoiner.add("[grpId=" + grpId + ", grpName=" + grpName + ", " + this.toString((Map<Integer, EvictReason>)map) + ']');
                        });
                        this.log.info("Partitions have been scheduled for eviction: " + evictPartJoiner);
                        this.logEvictPartByGrps.clear();
                    }
                }
            }
            this.lastShowProgressTimeNanos = System.nanoTime();
            this.showProgressGuard.set(false);
        }
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        super.start0();
        this.executor = (IgniteThreadPoolExecutor)this.cctx.kernalContext().pools().getRebalanceExecutorService();
        if (this.processEmptyEvictQueueFreq <= 0) {
            return;
        }
        this.processEvictions(true);
        this.processEvictions(false);
    }

    private boolean processEvictions(boolean tombstone) {
        GridKernalContext ctx = this.cctx.kernalContext();
        return ctx.timeout().addTimeoutObject(new FillEvictQueueTask(tombstone));
    }

    public FastSizeDeque<PendingRow> evictQueue(boolean tombstone) {
        return tombstone ? this.tombstoneEvictQueue : this.ttlEvictQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long fillEvictQueue(boolean tombstone, long upper) {
        long nextExpireTs = Long.MAX_VALUE;
        FastSizeDeque<PendingRow> queue = this.evictQueue(tombstone);
        if (!queue.isEmptyx()) {
            return nextExpireTs;
        }
        int total = 0;
        try {
            for (GroupEvictionContext ctx0 : this.evictionGroupsMap.values()) {
                if (this.cctx.kernalContext().isStopping()) {
                    return nextExpireTs;
                }
                if (!ctx0.busyLock.readLock().tryLock()) continue;
                int startQueueSize = queue.sizex();
                try {
                    if (queue.sizex() < MAX_EVICT_QUEUE_SIZE) {
                        try {
                            long nextGrpEntryExpireTs = ctx0.grp.offheap().fillQueue(tombstone, upper, key -> {
                                if (queue.sizex() >= MAX_EVICT_QUEUE_SIZE) {
                                    return 1;
                                }
                                queue.addLast((PendingRow)key);
                                return 0;
                            });
                            nextExpireTs = Math.min(nextExpireTs, nextGrpEntryExpireTs);
                        }
                        catch (IgniteCheckedException e) {
                            this.log.error("Failed to expire entries", e);
                        }
                    }
                }
                finally {
                    ctx0.busyLock.readLock().unlock();
                }
                int estimationCnt = queue.sizex() - startQueueSize;
                if (this.log.isDebugEnabled() && estimationCnt > 0) {
                    this.log.debug("Filled the queue for the group [grpName=" + ctx0.grp.cacheOrGroupName() + ", tombstone=" + tombstone + ", total=" + estimationCnt + ']');
                }
                total += estimationCnt;
            }
            if (this.log.isDebugEnabled() && total > 0) {
                this.log.debug("After filling the evict queue [total=" + total + ", tombstone=" + tombstone + ", qSize=" + queue.sizex() + ']');
            }
        }
        catch (Throwable e) {
            this.log.error("Failed to fill eviction queue [tombstone=" + tombstone + ']', e);
        }
        return nextExpireTs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean expire(boolean tombstone, IgniteClosure2X<GridCacheEntryEx, Long, Boolean> c, int amount, long now) {
        FastSizeDeque<PendingRow> queue = this.evictQueue(tombstone);
        int cleared = 0;
        this.cctx.database().checkpointReadLock();
        try {
            PendingRow row;
            int before = queue.sizex();
            while ((row = queue.pollFirst()) != null) {
                GridCacheContext ctx = this.cctx.cache().context().cacheContext(row.cacheId);
                if (ctx != null && ctx.isNear()) {
                    ctx = ctx.near().dht().context();
                }
                if (ctx != null && ctx.dynamicDeploymentId().equals(row.deploymentId)) {
                    try {
                        GridCacheEntryEx entry = ctx.cache().entryEx(row.key);
                        c.apply(entry, now);
                    }
                    catch (GridDhtInvalidPartitionException ignored) {
                        try {
                            ctx.offheap().removePendingRow(row);
                        }
                        catch (IgniteCheckedException e) {
                            this.log.error("Failed to remove pending row [row=" + row + ']', e);
                        }
                    }
                }
                if ((++cleared & 0x7F) == 0) {
                    this.cctx.database().checkpointReadUnlock();
                    this.cctx.database().checkpointReadLock();
                }
                if (amount == -1 || cleared != amount) continue;
                break;
            }
            if (cleared > 0 && this.log.isDebugEnabled()) {
                this.log.debug("After the expiration [cleared=" + cleared + ", tombstone=" + tombstone + ", initialSize=" + before + ", remaining=" + queue.sizex() + ']');
            }
            if (queue.isEmptyx()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = amount != -1 && cleared == amount;
            return bl;
        }
        finally {
            this.cctx.database().checkpointReadUnlock();
        }
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        super.onKernalStop0(cancel);
        Collection<GroupEvictionContext> evictionGrps = this.evictionGroupsMap.values();
        NodeStoppingException ex = new NodeStoppingException("Node is stopping");
        for (GroupEvictionContext evictionGrp : evictionGrps) {
            evictionGrp.stop(ex);
        }
    }

    private String toString(Map<Integer, EvictReason> evictParts) {
        assert (Objects.nonNull(evictParts));
        EnumMap<EvictReason, Collection> partByReason = new EnumMap<EvictReason, Collection>(EvictReason.class);
        for (Map.Entry<Integer, EvictReason> entry : evictParts.entrySet()) {
            partByReason.computeIfAbsent(entry.getValue(), b -> new ArrayList()).add(entry.getKey());
        }
        StringJoiner joiner = new StringJoiner(", ");
        partByReason.forEach((reason, partIds) -> joiner.add(reason.toString() + '=' + S.compact(partIds)));
        return joiner.toString();
    }

    public void cleanupRemovedGroup(int grpId) {
        this.evictionGroupsMap.remove(grpId);
    }

    public int total() {
        return this.evictionGroupsMap.values().stream().mapToInt(ctx -> ((GroupEvictionContext)ctx).totalTasks.get()).sum();
    }

    private void updateMetrics(CacheGroupContext grp, EvictReason reason, BiConsumer<EvictReason, CacheMetricsImpl> c) {
        if (reason != EvictReason.CLEARING_ON_RECOVERY) {
            for (GridCacheContext cctx : grp.caches()) {
                if (!cctx.statisticsEnabled()) continue;
                CacheMetricsImpl metrics = cctx.cache().metrics0();
                c.accept(reason, metrics);
            }
        }
    }

    private final class FillEvictQueueTask
    extends GridTimeoutObjectAdapter {
        private final boolean tombstone;

        FillEvictQueueTask(boolean tombstone) {
            this(tombstone, 0);
        }

        FillEvictQueueTask(boolean tombstone, int timeout) {
            super(tombstone ? FILL_EVICT_QUEUE_TASK_ID_TOMBSTONE : FILL_EVICT_QUEUE_TASK_ID_TTL, timeout < PartitionsEvictManager.this.processEmptyEvictQueueFreq ? (long)PartitionsEvictManager.this.processEmptyEvictQueueFreq : (long)timeout);
            this.tombstone = tombstone;
        }

        @Override
        public void onTimeout() {
            PartitionsEvictManager.this.cctx.kernalContext().closure().runLocalSafe(new GridPlainRunnable(){

                @Override
                public void run() {
                    long now = U.currentTimeMillis();
                    long nextExpireTs = PartitionsEvictManager.this.fillEvictQueue(FillEvictQueueTask.this.tombstone, now);
                    if (PartitionsEvictManager.this.processEmptyEvictQueueFreq > 0) {
                        long nextExpirationTask = Math.min(nextExpireTs, now + (long)PartitionsEvictManager.this.processEmptyEvictQueueFreq * 10L);
                        int nextTimeout = (int)(nextExpirationTask - now);
                        PartitionsEvictManager.this.cctx.kernalContext().timeout().addTimeoutObject(new FillEvictQueueTask(FillEvictQueueTask.this.tombstone, nextTimeout));
                    }
                }
            });
        }
    }

    private static final class PartitionKey {
        final int grpId;
        final int partId;

        public PartitionKey(int grpId, int partId) {
            this.grpId = grpId;
            this.partId = partId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionKey that = (PartitionKey)o;
            if (this.grpId != that.grpId) {
                return false;
            }
            return this.partId == that.partId;
        }

        public int hashCode() {
            int result = this.grpId;
            result = 31 * result + this.partId;
            return result;
        }
    }

    public static enum EvictReason {
        EVICTION,
        CLEARING,
        TOMBSTONE,
        CLEARING_ON_RECOVERY;

    }

    public class PartitionEvictionTask
    implements Runnable {
        private final GridDhtLocalPartition part;
        private final EvictReason reason;
        @GridToStringExclude
        private final GroupEvictionContext grpEvictionCtx;
        @GridToStringExclude
        private final GridFutureAdapter<Void> finishFut;
        @GridToStringExclude
        private final AtomicReference<Boolean> state = new AtomicReference<Object>(null);

        private PartitionEvictionTask(GridDhtLocalPartition part, GroupEvictionContext grpEvictionCtx, EvictReason reason, GridFutureAdapter<Void> finishFut) {
            this.part = part;
            this.grpEvictionCtx = grpEvictionCtx;
            this.reason = reason;
            this.finishFut = finishFut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.state.compareAndSet(null, Boolean.TRUE)) {
                assert (this.finishFut.isDone()) : "Finish future must be completed [fut=" + this.finishFut + ", state=" + this.state + ']';
                return;
            }
            if (this.grpEvictionCtx.grp.cacheObjectContext().kernalContext().isStopping()) {
                this.finishFut.onDone(new NodeStoppingException("Node is stopping"));
                return;
            }
            if (!this.grpEvictionCtx.busyLock.readLock().tryLock()) {
                this.finishFut.onDone((Throwable)this.grpEvictionCtx.stopExRef.get());
                return;
            }
            BooleanSupplier stopClo = () -> {
                boolean stop;
                boolean bl = stop = this.grpEvictionCtx.shouldStop() || this.state.get() == Boolean.FALSE;
                if (!stop) {
                    PartitionsEvictManager.this.showProgress();
                }
                return stop;
            };
            try {
                long clearedEntities = this.part.clearAll(stopClo, this);
                if (PartitionsEvictManager.this.log.isDebugEnabled()) {
                    PartitionsEvictManager.this.log.debug("The partition clearing has been finished [grp=" + this.part.group().cacheOrGroupName() + ", topVer=" + this.part.group().topology().readyTopologyVersion() + ", cleared=" + clearedEntities + ", task" + this + ']');
                }
                if (PartitionsEvictManager.this.cctx.kernalContext().isStopping()) {
                    this.finishFut.onDone(new NodeStoppingException("Node is stopping"));
                } else {
                    this.finishFut.onDone();
                }
            }
            catch (Throwable ex) {
                this.finishFut.onDone(ex);
                if (PartitionsEvictManager.this.cctx.kernalContext().isStopping()) {
                    LT.warn(PartitionsEvictManager.this.log, ex, "Partition eviction has been cancelled (local node is stopping) [grp=" + this.grpEvictionCtx.grp.cacheOrGroupName() + ", readyVer=" + this.grpEvictionCtx.grp.topology().readyTopologyVersion() + ']', false, true);
                } else {
                    LT.error(PartitionsEvictManager.this.log, ex, "Partition eviction has failed [grp=" + this.grpEvictionCtx.grp.cacheOrGroupName() + ", part=" + this.part.id() + ']');
                    PartitionsEvictManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, ex));
                }
            }
            finally {
                this.grpEvictionCtx.busyLock.readLock().unlock();
            }
        }

        public EvictReason reason() {
            return this.reason;
        }

        public IgniteInternalFuture<Void> finishFuture() {
            return this.finishFut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean start() {
            try {
                PartitionsEvictManager.this.executor.submit(this);
            }
            catch (Exception ignored) {
                PartitionsEvictManager.this.log.error("Failed to submit the task for the execution [task=" + this + ']');
                return false;
            }
            Object object = PartitionsEvictManager.this.mux;
            synchronized (object) {
                PartitionsEvictManager.this.logEvictPartByGrps.computeIfAbsent(this.grpEvictionCtx.grp.groupId(), grpId -> new HashMap()).put(this.part.id(), this.reason);
                this.grpEvictionCtx.totalTasks.incrementAndGet();
                PartitionsEvictManager.this.updateMetrics(this.grpEvictionCtx.grp, this.reason, INCREMENT);
                PartitionsEvictManager.this.showProgress();
                this.grpEvictionCtx.taskScheduled(this);
            }
            if (PartitionsEvictManager.this.log.isDebugEnabled()) {
                PartitionsEvictManager.this.log.debug("Starting clearing [grp=" + this.grpEvictionCtx.grp.cacheOrGroupName() + ", topVer=" + this.grpEvictionCtx.grp.topology().readyTopologyVersion() + ", task" + this + ']');
            }
            return true;
        }

        public void cancel() {
            if (this.state.compareAndSet(null, Boolean.FALSE)) {
                this.finishFut.onDone();
            } else if (this.state.get() == Boolean.TRUE) {
                this.state.set(Boolean.FALSE);
            }
        }

        public void awaitCompletion() {
            while (true) {
                try {
                    this.finishFut.get(5000L);
                    return;
                }
                catch (IgniteFutureTimeoutCheckedException e) {
                    PartitionsEvictManager.this.log.warning("Failed to wait for clearing finish, retrying [task=" + this + ']');
                    continue;
                }
                catch (IgniteCheckedException e) {
                    PartitionsEvictManager.this.log.warning("The clearing has finished with error [part=" + this.part + ']', e);
                    return;
                }
                break;
            }
        }

        public String toString() {
            return S.toString(PartitionEvictionTask.class, this, "grp", (Object)this.grpEvictionCtx.grp.cacheOrGroupName(), "reason", (Object)this.reason, "state", (Object)(this.state.get() == null ? "NotStarted" : (this.state.get() != false ? "Started" : "Cancelled")), "done", (Object)this.finishFut.isDone(), "err", (Object)(this.finishFut.error() != null ? 1 : 0));
        }
    }

    private class GroupEvictionContext {
        private final CacheGroupContext grp;
        private AtomicReference<Exception> stopExRef = new AtomicReference();
        private AtomicInteger totalTasks = new AtomicInteger();
        private int taskInProgress;
        private ReadWriteLock busyLock = new ReentrantReadWriteLock();

        private GroupEvictionContext(CacheGroupContext grp) {
            this.grp = grp;
        }

        private synchronized void taskScheduled(PartitionEvictionTask task) {
            ++this.taskInProgress;
            GridFutureAdapter fut = task.finishFut;
            fut.listen(f -> {
                GroupEvictionContext groupEvictionContext = this;
                synchronized (groupEvictionContext) {
                    --this.taskInProgress;
                    this.totalTasks.decrementAndGet();
                    PartitionsEvictManager.this.updateMetrics(((PartitionEvictionTask)task).grpEvictionCtx.grp, task.reason, DECREMENT);
                }
            });
        }

        public boolean shouldStop() {
            return this.stopExRef.get() != null;
        }

        void stop(Exception ex) {
            if (!this.stopExRef.compareAndSet(null, ex)) {
                return;
            }
            this.busyLock.writeLock().lock();
        }

        private void showProgress() {
            if (PartitionsEvictManager.this.log.isInfoEnabled() && !this.grp.isLocal()) {
                PartitionsEvictManager.this.log.info("Group eviction in progress [grpName=" + this.grp.cacheOrGroupName() + ", grpId=" + this.grp.groupId() + ", remainingPartsToEvict=" + (this.totalTasks.get() - this.taskInProgress) + ", partsEvictInProgress=" + this.taskInProgress + ", totalParts=" + this.grp.topology().localPartitions().size() + "]");
            }
        }
    }
}

