/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.checker.util;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;

public class DelayedHolder<T>
implements Delayed {
    private final long finishTime;
    private final T task;

    public DelayedHolder(long time, T task) {
        this.finishTime = time;
        this.task = task;
    }

    public T getTask() {
        return this.task;
    }

    @Override
    public long getDelay(@NotNull TimeUnit unit) {
        return unit.convert(this.finishTime - U.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(@NotNull Delayed o) {
        return Long.compare(this.finishTime, ((DelayedHolder)o).finishTime);
    }
}

