/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metric;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.metric.IoStatisticsQueryHelper;
import org.apache.ignite.internal.metric.IoStatisticsType;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IoStatisticsHolderCache
implements IoStatisticsHolder {
    public static final String PHYSICAL_READS = "PHYSICAL_READS";
    public static final String LOGICAL_READS = "LOGICAL_READS";
    private final LongAdderMetric logicalReadCtr;
    private final LongAdderMetric physicalReadCtr;
    private final String grpName;
    private final int grpId;

    public IoStatisticsHolderCache(String grpName, int grpId, GridMetricManager mmgr) {
        assert (grpName != null);
        this.grpName = grpName;
        this.grpId = grpId;
        MetricRegistry mreg = mmgr.registry(this.metricRegistryName());
        mreg.longMetric("startTime", null).value(U.currentTimeMillis());
        mreg.objectMetric("name", String.class, null).value(grpName);
        mreg.intMetric("grpId", null).value(grpId);
        this.logicalReadCtr = mreg.longAdderMetric(LOGICAL_READS, null);
        this.physicalReadCtr = mreg.longAdderMetric(PHYSICAL_READS, null);
    }

    @Override
    public void trackLogicalRead(long pageAddr) {
        int pageIoType = PageIO.getType(pageAddr);
        if (pageIoType == 1) {
            this.logicalReadCtr.increment();
            IoStatisticsQueryHelper.trackLogicalReadQuery(pageAddr);
        }
    }

    @Override
    public void trackPhysicalAndLogicalRead(long pageAddr) {
        int pageIoType = PageIO.getType(pageAddr);
        if (pageIoType == 1) {
            this.logicalReadCtr.increment();
            this.physicalReadCtr.increment();
            IoStatisticsQueryHelper.trackPhysicalAndLogicalReadQuery(pageAddr);
        }
    }

    @Override
    public long logicalReads() {
        return this.logicalReadCtr.value();
    }

    @Override
    public long physicalReads() {
        return this.physicalReadCtr.value();
    }

    @Override
    public Map<String, Long> logicalReadsMap() {
        HashMap<String, Long> res = new HashMap<String, Long>(2);
        res.put(LOGICAL_READS, this.logicalReads());
        return res;
    }

    @Override
    public Map<String, Long> physicalReadsMap() {
        HashMap<String, Long> res = new HashMap<String, Long>(2);
        res.put(PHYSICAL_READS, this.physicalReads());
        return res;
    }

    @Override
    public void resetStatistics() {
        this.logicalReadCtr.reset();
        this.physicalReadCtr.reset();
    }

    @Override
    public String metricRegistryName() {
        return MetricUtils.metricName(IoStatisticsType.CACHE_GROUP.metricGroupName(), this.grpName);
    }

    public int cacheGroupId() {
        return this.grpId;
    }

    public String toString() {
        return S.toString(IoStatisticsHolderCache.class, this, "logicalReadCtr", (Object)this.logicalReadCtr, "physicalReadCtr", (Object)this.physicalReadCtr, "grpName", (Object)this.grpName);
    }
}

