/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class ConsistentIdMapper {
    private final GridDiscoveryManager discoveryMgr;

    public ConsistentIdMapper(GridDiscoveryManager discoveryMgr) {
        this.discoveryMgr = discoveryMgr;
    }

    public short mapToCompactId(AffinityTopologyVersion topVer, UUID nodeId) {
        Map<UUID, Short> m = this.discoveryMgr.consistentId(topVer);
        if (m == null) {
            throw new IllegalStateException("Unable to find consistent id map [topVer" + topVer + ']');
        }
        Short constId = m.get(nodeId);
        if (constId == null) {
            throw new IllegalStateException("Unable to find consistentId by UUID [nodeId=" + nodeId + ", topVer=" + topVer + ']');
        }
        return constId;
    }

    public UUID mapToUuid(AffinityTopologyVersion topVer, short nodeConstId) {
        Map<Short, UUID> map = this.discoveryMgr.nodeIdMap(topVer);
        if (map == null) {
            return null;
        }
        UUID constId = map.get(nodeConstId);
        if (constId == null) {
            throw new IllegalStateException("Unable to find UUID by constId [nodeId=" + nodeConstId + ", topVer=" + topVer + ']');
        }
        return constId;
    }

    public Map<Short, Collection<Short>> mapToCompactIds(AffinityTopologyVersion topVer, @Nullable Map<UUID, Collection<UUID>> txNodes) {
        if (txNodes == null) {
            return null;
        }
        Map<UUID, Short> m = this.discoveryMgr.consistentId(topVer);
        boolean fullBaseline = this.discoveryMgr.fullBaseline(topVer);
        int bltNodes = m.size();
        HashMap<Short, Collection<Short>> consistentMap = U.newHashMap(txNodes.size());
        int nodeCnt = 0;
        for (Map.Entry<UUID, Collection<UUID>> e : txNodes.entrySet()) {
            UUID node = e.getKey();
            if (!m.containsKey(node)) continue;
            Collection<UUID> backupNodes = e.getValue();
            List<Short> backups = new ArrayList<Short>(backupNodes.size());
            for (UUID backup : backupNodes) {
                if (!m.containsKey(backup)) continue;
                ++nodeCnt;
                backups.add(this.mapToCompactId(topVer, backup));
            }
            if (fullBaseline && backups.size() == nodeCnt && nodeCnt == bltNodes - 1) {
                backups = Collections.singletonList((short)Short.MAX_VALUE);
            }
            consistentMap.put(this.mapToCompactId(topVer, node), backups);
        }
        return consistentMap;
    }
}

