/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.dto;

import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import org.apache.ignite.internal.util.io.GridByteArrayOutputStream;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;

public class IgniteDataTransferObjectOutput
implements ObjectOutput {
    private final ObjectOutput out;
    private final GridByteArrayOutputStream bos;
    private final ObjectOutputStream oos;

    public IgniteDataTransferObjectOutput(ObjectOutput out) throws IOException {
        this.out = out;
        this.bos = new GridByteArrayOutputStream();
        this.oos = new ObjectOutputStream(this.bos);
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        this.oos.writeObject(obj);
    }

    @Override
    public void write(int b) throws IOException {
        this.oos.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.oos.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.oos.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.oos.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.oos.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.oos.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.oos.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.oos.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.oos.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.oos.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.oos.writeDouble(v);
    }

    @Override
    public void writeBytes(@NotNull String s) throws IOException {
        this.oos.writeBytes(s);
    }

    @Override
    public void writeChars(@NotNull String s) throws IOException {
        this.oos.writeChars(s);
    }

    @Override
    public void writeUTF(@NotNull String s) throws IOException {
        this.oos.writeUTF(s);
    }

    @Override
    public void flush() throws IOException {
        this.oos.flush();
    }

    @Override
    public void close() throws IOException {
        this.oos.flush();
        U.writeByteArray(this.out, this.bos.internalArray(), this.bos.size());
        this.oos.close();
    }
}

