/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite.client.IgniteClientFuture;

public class IgniteClientFutureImpl<T>
implements IgniteClientFuture<T> {
    private final CompletableFuture<T> fut;
    private final Function<Boolean, Boolean> onCancel;

    public IgniteClientFutureImpl(CompletableFuture<T> fut, Function<Boolean, Boolean> onCancel) {
        assert (fut != null);
        this.fut = fut;
        this.onCancel = onCancel;
    }

    public IgniteClientFutureImpl(CompletionStage<T> fut) {
        assert (fut != null);
        this.fut = fut.toCompletableFuture();
        this.onCancel = null;
    }

    public static <T> IgniteClientFutureImpl<T> completedFuture(T res) {
        CompletableFuture<T> fut = new CompletableFuture<T>();
        fut.complete(res);
        return new IgniteClientFutureImpl(fut);
    }

    @Override
    public boolean isDone() {
        return this.fut.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.fut.get();
    }

    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.fut.get(l, timeUnit);
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> function) {
        return this.fut.thenApply(function);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> function) {
        return this.fut.thenApplyAsync(function);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> function, Executor executor) {
        return this.fut.thenApplyAsync(function, executor);
    }

    public CompletableFuture<Void> thenAccept(Consumer<? super T> consumer) {
        return this.fut.thenAccept((Consumer)consumer);
    }

    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> consumer) {
        return this.fut.thenAcceptAsync((Consumer)consumer);
    }

    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> consumer, Executor executor) {
        return this.fut.thenAcceptAsync((Consumer)consumer, executor);
    }

    public CompletableFuture<Void> thenRun(Runnable runnable) {
        return this.fut.thenRun(runnable);
    }

    public CompletableFuture<Void> thenRunAsync(Runnable runnable) {
        return this.fut.thenRunAsync(runnable);
    }

    public CompletableFuture<Void> thenRunAsync(Runnable runnable, Executor executor) {
        return this.fut.thenRunAsync(runnable, executor);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> completionStage, BiFunction<? super T, ? super U, ? extends V> biFunction) {
        return this.fut.thenCombine(completionStage, biFunction);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> completionStage, BiFunction<? super T, ? super U, ? extends V> biFunction) {
        return this.fut.thenCombineAsync(completionStage, biFunction);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> completionStage, BiFunction<? super T, ? super U, ? extends V> biFunction, Executor executor) {
        return this.fut.thenCombineAsync(completionStage, biFunction, executor);
    }

    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> completionStage, BiConsumer<? super T, ? super U> biConsumer) {
        return this.fut.thenAcceptBoth(completionStage, (BiConsumer)biConsumer);
    }

    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> completionStage, BiConsumer<? super T, ? super U> biConsumer) {
        return this.fut.thenAcceptBothAsync(completionStage, (BiConsumer)biConsumer);
    }

    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> completionStage, BiConsumer<? super T, ? super U> biConsumer, Executor executor) {
        return this.fut.thenAcceptBothAsync(completionStage, (BiConsumer)biConsumer, executor);
    }

    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> completionStage, Runnable runnable) {
        return this.fut.runAfterBoth((CompletionStage)completionStage, runnable);
    }

    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> completionStage, Runnable runnable) {
        return this.fut.runAfterBothAsync((CompletionStage)completionStage, runnable);
    }

    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> completionStage, Runnable runnable, Executor executor) {
        return this.fut.runAfterBothAsync((CompletionStage)completionStage, runnable, executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> completionStage, Function<? super T, U> function) {
        return this.fut.applyToEither((CompletionStage)completionStage, function);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> completionStage, Function<? super T, U> function) {
        return this.fut.applyToEitherAsync((CompletionStage)completionStage, function);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> completionStage, Function<? super T, U> function, Executor executor) {
        return this.fut.applyToEitherAsync((CompletionStage)completionStage, function, executor);
    }

    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> completionStage, Consumer<? super T> consumer) {
        return this.fut.acceptEither((CompletionStage)completionStage, (Consumer)consumer);
    }

    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> completionStage, Consumer<? super T> consumer) {
        return this.fut.acceptEitherAsync((CompletionStage)completionStage, (Consumer)consumer);
    }

    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> completionStage, Consumer<? super T> consumer, Executor executor) {
        return this.fut.acceptEitherAsync((CompletionStage)completionStage, (Consumer)consumer, executor);
    }

    public CompletableFuture<Void> runAfterEither(CompletionStage<?> completionStage, Runnable runnable) {
        return this.fut.runAfterEither((CompletionStage)completionStage, runnable);
    }

    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> completionStage, Runnable runnable) {
        return this.fut.runAfterEitherAsync((CompletionStage)completionStage, runnable);
    }

    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> completionStage, Runnable runnable, Executor executor) {
        return this.fut.runAfterEitherAsync((CompletionStage)completionStage, runnable, executor);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> function) {
        return this.fut.thenCompose(function);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> function) {
        return this.fut.thenComposeAsync(function);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> function, Executor executor) {
        return this.fut.thenComposeAsync(function, executor);
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> biConsumer) {
        return this.fut.whenComplete(biConsumer);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> biConsumer) {
        return this.fut.whenCompleteAsync(biConsumer);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> biConsumer, Executor executor) {
        return this.fut.whenCompleteAsync(biConsumer, executor);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> biFunction) {
        return this.fut.handle(biFunction);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> biFunction) {
        return this.fut.handleAsync(biFunction);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> biFunction, Executor executor) {
        return this.fut.handleAsync(biFunction, executor);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this.fut;
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> function) {
        return this.fut.exceptionally(function);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.onCancel != null) {
            return this.onCancel.apply(mayInterruptIfRunning);
        }
        return this.fut.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.fut.isCancelled();
    }
}

