/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.monitoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.function.Consumer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.client.events.ConnectionClosedEvent;
import org.apache.ignite.client.events.ConnectionDescription;
import org.apache.ignite.client.events.ConnectionEventListener;
import org.apache.ignite.client.events.HandshakeFailEvent;
import org.apache.ignite.client.events.HandshakeStartEvent;
import org.apache.ignite.client.events.HandshakeSuccessEvent;
import org.apache.ignite.client.events.RequestEventListener;
import org.apache.ignite.client.events.RequestFailEvent;
import org.apache.ignite.client.events.RequestStartEvent;
import org.apache.ignite.client.events.RequestSuccessEvent;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.logger.NullLogger;

public class EventListenerDemultiplexer {
    private static final EventListenerDemultiplexer NO_OP = new EventListenerDemultiplexer();
    final List<RequestEventListener> reqEventListeners;
    final List<ConnectionEventListener> connEventListeners;
    final IgniteLogger logger;

    EventListenerDemultiplexer() {
        this.reqEventListeners = null;
        this.connEventListeners = null;
        this.logger = NullLogger.INSTANCE;
    }

    EventListenerDemultiplexer(List<RequestEventListener> reqEventListeners, List<ConnectionEventListener> connEventListeners, IgniteLogger logger) {
        this.logger = logger;
        this.reqEventListeners = !F.isEmpty(reqEventListeners) ? Collections.unmodifiableList(reqEventListeners) : null;
        this.connEventListeners = !F.isEmpty(connEventListeners) ? Collections.unmodifiableList(connEventListeners) : null;
    }

    public static EventListenerDemultiplexer create(ClientConfiguration cfg) {
        if (F.isEmpty(cfg.getEventListeners())) {
            return NO_OP;
        }
        ArrayList<RequestEventListener> qryEventListeners = new ArrayList<RequestEventListener>();
        ArrayList<ConnectionEventListener> connEventListeners = new ArrayList<ConnectionEventListener>();
        for (EventListener l : cfg.getEventListeners()) {
            if (l instanceof RequestEventListener) {
                qryEventListeners.add((RequestEventListener)l);
                continue;
            }
            if (!(l instanceof ConnectionEventListener)) continue;
            connEventListeners.add((ConnectionEventListener)l);
        }
        if (F.isEmpty(qryEventListeners) && F.isEmpty(connEventListeners)) {
            return NO_OP;
        }
        return new EventListenerDemultiplexer(qryEventListeners, connEventListeners, NullLogger.whenNull(cfg.getLogger()));
    }

    public void onRequestStart(ConnectionDescription conn, long requestId, short opCode, String opName) {
        if (F.isEmpty(this.reqEventListeners)) {
            return;
        }
        this.executeForEach(this.reqEventListeners, l -> l.onRequestStart(new RequestStartEvent(conn, requestId, opCode, opName)));
    }

    public void onRequestSuccess(ConnectionDescription conn, long requestId, short opCode, String opName, long elapsedTimeNanos) {
        if (F.isEmpty(this.reqEventListeners)) {
            return;
        }
        this.executeForEach(this.reqEventListeners, l -> l.onRequestSuccess(new RequestSuccessEvent(conn, requestId, opCode, opName, elapsedTimeNanos)));
    }

    public void onRequestFail(ConnectionDescription conn, long requestId, short opCode, String opName, long elapsedTimeNanos, Throwable throwable) {
        if (F.isEmpty(this.reqEventListeners)) {
            return;
        }
        this.executeForEach(this.reqEventListeners, l -> l.onRequestFail(new RequestFailEvent(conn, requestId, opCode, opName, elapsedTimeNanos, throwable)));
    }

    public void onHandshakeStart(ConnectionDescription conn) {
        if (F.isEmpty(this.connEventListeners)) {
            return;
        }
        this.executeForEach(this.connEventListeners, l -> l.onHandshakeStart(new HandshakeStartEvent(conn)));
    }

    public void onHandshakeSuccess(ConnectionDescription conn, long elapsedTimeNanos) {
        if (F.isEmpty(this.connEventListeners)) {
            return;
        }
        this.executeForEach(this.connEventListeners, l -> l.onHandshakeSuccess(new HandshakeSuccessEvent(conn, elapsedTimeNanos)));
    }

    public void onHandshakeFail(ConnectionDescription conn, long elapsedTimeNanos, Throwable throwable) {
        if (F.isEmpty(this.connEventListeners)) {
            return;
        }
        this.executeForEach(this.connEventListeners, l -> l.onHandshakeFail(new HandshakeFailEvent(conn, elapsedTimeNanos, throwable)));
    }

    public void onConnectionClosed(ConnectionDescription conn, Throwable throwable) {
        if (F.isEmpty(this.connEventListeners)) {
            return;
        }
        this.executeForEach(this.connEventListeners, l -> l.onConnectionClosed(new ConnectionClosedEvent(conn, throwable)));
    }

    private <T> void executeForEach(List<T> listeners, Consumer<T> action) {
        assert (!F.isEmpty(listeners));
        for (T listener : listeners) {
            try {
                action.accept(listener);
            }
            catch (Exception e) {
                this.logger.warning("Exception thrown while consuming event in listener " + listener, e);
            }
        }
    }
}

