/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.builder;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.builder.BinaryBuilderReader;
import org.apache.ignite.internal.binary.builder.BinaryBuilderSerializationAware;
import org.apache.ignite.internal.binary.builder.BinaryBuilderSerializer;
import org.apache.ignite.internal.binary.builder.BinaryLazyValue;
import org.jetbrains.annotations.Nullable;

class BinaryLazyMap
extends AbstractMap<Object, Object>
implements BinaryBuilderSerializationAware {
    private final BinaryBuilderReader reader;
    private final int off;
    private Map<Object, Object> delegate;

    private BinaryLazyMap(BinaryBuilderReader reader, int off) {
        this.reader = reader;
        this.off = off;
    }

    @Nullable
    public static BinaryLazyMap parseMap(BinaryBuilderReader reader) {
        int off = reader.position() - 1;
        int size = reader.readInt();
        reader.skip(1);
        for (int i = 0; i < size; ++i) {
            reader.skipValue();
            reader.skipValue();
        }
        return new BinaryLazyMap(reader, off);
    }

    private void ensureDelegateInit() {
        if (this.delegate == null) {
            int size = this.reader.readIntPositioned(this.off + 1);
            this.reader.position(this.off + 1 + 4 + 1);
            this.delegate = new LinkedHashMap<Object, Object>();
            for (int i = 0; i < size; ++i) {
                this.delegate.put(BinaryUtils.unwrapLazy(this.reader.parseValue()), this.reader.parseValue());
            }
        }
    }

    @Override
    public void writeTo(BinaryWriterExImpl writer, BinaryBuilderSerializer ctx) {
        if (this.delegate == null) {
            int size = this.reader.readIntPositioned(this.off + 1);
            int hdrSize = 6;
            writer.write(this.reader.array(), this.off, hdrSize);
            this.reader.position(this.off + hdrSize);
            for (int i = 0; i < size; ++i) {
                ctx.writeValue(writer, this.reader.parseValue());
                ctx.writeValue(writer, this.reader.parseValue());
            }
        } else {
            writer.writeByte((byte)25);
            writer.writeInt(this.delegate.size());
            byte colType = this.reader.array()[this.off + 1 + 4];
            writer.writeByte(colType);
            for (Map.Entry<Object, Object> entry : this.delegate.entrySet()) {
                ctx.writeValue(writer, entry.getKey());
                ctx.writeValue(writer, entry.getValue());
            }
        }
    }

    @Override
    public int size() {
        if (this.delegate == null) {
            return this.reader.readIntPositioned(this.off + 1);
        }
        return this.delegate.size();
    }

    @Override
    public boolean containsKey(Object key) {
        this.ensureDelegateInit();
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object val) {
        return this.values().contains(val);
    }

    @Override
    public Set<Object> keySet() {
        this.ensureDelegateInit();
        return this.delegate.keySet();
    }

    @Override
    public void clear() {
        if (this.delegate == null) {
            this.delegate = new LinkedHashMap<Object, Object>();
        } else {
            this.delegate.clear();
        }
    }

    @Override
    public Object get(Object key) {
        this.ensureDelegateInit();
        return BinaryUtils.unwrapLazy(this.delegate.get(key));
    }

    @Override
    public Object put(Object key, Object val) {
        this.ensureDelegateInit();
        return BinaryUtils.unwrapLazy(this.delegate.put(key, val));
    }

    @Override
    public Object remove(Object key) {
        this.ensureDelegateInit();
        return BinaryUtils.unwrapLazy(this.delegate.remove(key));
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        this.ensureDelegateInit();
        return new AbstractSet<Map.Entry<Object, Object>>(){

            @Override
            public boolean contains(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Map.Entry<Object, Object>> iterator() {
                return new Iterator<Map.Entry<Object, Object>>(){
                    private final Iterator<Map.Entry<Object, Object>> itr;
                    {
                        this.itr = BinaryLazyMap.this.delegate.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.itr.hasNext();
                    }

                    @Override
                    public Map.Entry<Object, Object> next() {
                        Map.Entry<Object, Object> res = this.itr.next();
                        final Object val = res.getValue();
                        if (val instanceof BinaryLazyValue) {
                            return new AbstractMap.SimpleEntry<Object, Object>(res.getKey(), val){
                                private static final long serialVersionUID = 0L;

                                @Override
                                public Object getValue() {
                                    return ((BinaryLazyValue)val).value();
                                }
                            };
                        }
                        return res;
                    }

                    @Override
                    public void remove() {
                        this.itr.remove();
                    }
                };
            }

            @Override
            public int size() {
                return BinaryLazyMap.this.delegate.size();
            }
        };
    }
}

