/*
 * Decompiled with CFR 0.152.
 */
package com.gridgain.cdc.gg9togg8;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

public enum PrimitiveType {
    BOOLEAN(Boolean.class, Boolean.class),
    TINYINT(Byte.class, Byte.class),
    SMALLINT(Short.class, Short.class),
    INT(Integer.class, Integer.class),
    BIGINT(Long.class, Long.class),
    UUID(UUID.class, UUID.class),
    REAL(Float.class, Float.class),
    DOUBLE(Double.class, Double.class),
    DECIMAL(BigDecimal.class, BigDecimal.class),
    VARCHAR(String.class, String.class),
    VARBINARY(byte[].class, byte[].class),
    DATE(LocalDate.class, Date.class, Date::valueOf),
    TIME(LocalTime.class, Time.class, Time::valueOf),
    DATETIME(LocalDateTime.class, Timestamp.class, Timestamp::valueOf),
    TIMESTAMP(Instant.class, Timestamp.class, Timestamp::from);

    private static final Map<Class<?>, PrimitiveType> byGg9Type;
    private static final Map<Class<?>, PrimitiveType> byGg8Type;
    private final Class<?> gg9Type;
    private final Class<?> gg8Type;
    private final Function<?, ?> conversionFunc;

    public static PrimitiveType fromGg9Type(Class<?> gg9Type) {
        PrimitiveType res = byGg9Type.get(gg9Type);
        if (res == null) {
            throw new IllegalArgumentException("Unsupported gg9 type:" + gg9Type.getName());
        }
        return res;
    }

    public static PrimitiveType fromGg8Type(Class<?> gg8Type) {
        PrimitiveType res = byGg8Type.get(gg8Type);
        if (res == null) {
            throw new IllegalArgumentException("Unsupported gg8 type:" + gg8Type.getName());
        }
        return res;
    }

    private <S, R> PrimitiveType(Class<S> gg9Type, Class<R> gg8Type, Function<S, R> conversionFunc) {
        this.gg9Type = gg9Type;
        this.gg8Type = gg8Type;
        this.conversionFunc = conversionFunc;
    }

    private <T> PrimitiveType(Class<T> gg9Type, Class<T> gg8Type) {
        this.gg9Type = gg9Type;
        this.gg8Type = gg8Type;
        this.conversionFunc = Function.identity();
    }

    public Class<?> gg9Type() {
        return this.gg9Type;
    }

    public Class<?> gg8Type() {
        return this.gg8Type;
    }

    public <S, R> R convertValue(S src) {
        return (R)this.conversionFunc.apply(src);
    }

    static {
        byGg9Type = new HashMap();
        byGg8Type = new HashMap();
        for (PrimitiveType primitiveType : PrimitiveType.values()) {
            byGg9Type.put(primitiveType.gg9Type(), primitiveType);
            byGg8Type.put(primitiveType.gg8Type(), primitiveType);
        }
    }
}

