/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.startup.cmdline;

import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class CommandLineTransformer {
    static final String JVM_OPTION_PREFIX = "-J";
    private static final String TRANSFORMATION_FAILED_FLAG = "CommandLineTransformerError";
    private static final String ARGS_DELIMITER = " ";
    private boolean interactive;
    private boolean verbose = true;
    private boolean noPause;
    private String jvmOptions = "";
    private String springCfgPath = "";

    private CommandLineTransformer() {
    }

    public static void main(String[] args) {
        block3: {
            PrintStream ps = null;
            try {
                String encoding = System.getProperty("file.encoding", Charset.defaultCharset().name());
                ps = new PrintStream((OutputStream)System.out, true, encoding);
                ps.println(CommandLineTransformer.transform(args));
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (ps != null) {
                    ps.println(TRANSFORMATION_FAILED_FLAG);
                }
                if (!(t instanceof Error)) break block3;
                throw (Error)t;
            }
        }
    }

    public static String transform(String ... args) {
        assert (args != null);
        return new CommandLineTransformer().doTransformation(args);
    }

    private String doTransformation(String[] args) {
        ArrayList<String> argsList = new ArrayList<String>();
        String[] stringArray = args;
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String arg;
            switch (arg = stringArray[i]) {
                case "-i": {
                    this.interactive = true;
                    continue block12;
                }
                case "-v": {
                    this.verbose = true;
                    continue block12;
                }
                case "-q": {
                    this.verbose = false;
                    continue block12;
                }
                case "-np": {
                    this.noPause = true;
                    continue block12;
                }
                default: {
                    argsList.add(arg);
                }
            }
        }
        return this.reformatArguments(argsList);
    }

    private String reformatArguments(List<String> args) {
        StringBuilder sb = new StringBuilder();
        this.addArgWithValue(sb, "INTERACTIVE", this.formatBooleanValue(this.interactive));
        this.addArgWithValue(sb, "QUIET", "-DIGNITE_QUIET=" + !this.verbose);
        this.addArgWithValue(sb, "NO_PAUSE", this.formatBooleanValue(this.noPause));
        this.parseJvmOptionsAndSpringConfig(args);
        this.addArgWithValue(sb, "JVM_XOPTS", this.jvmOptions);
        this.addArgWithValue(sb, "CONFIG", this.springCfgPath);
        return sb.toString().trim();
    }

    private String formatBooleanValue(boolean val) {
        return String.valueOf(val ? 1 : 0);
    }

    private void addArgWithValue(StringBuilder sb, String arg, Object val) {
        sb.append("\"");
        sb.append(arg);
        sb.append("=");
        sb.append(val);
        sb.append("\"");
        sb.append(ARGS_DELIMITER);
    }

    private void parseJvmOptionsAndSpringConfig(Iterable<String> args) {
        boolean hadFileEncoding = false;
        for (String arg : args) {
            if (arg.startsWith(JVM_OPTION_PREFIX)) {
                String jvmOpt = arg.substring(JVM_OPTION_PREFIX.length());
                if (jvmOpt.startsWith("-Dfile.encoding=")) {
                    hadFileEncoding = true;
                }
                if (!this.checkJVMOptionIsSupported(jvmOpt)) {
                    throw new RuntimeException("-J JVM parameters for Ignite batch scripts with double quotes are not supported. Use JVM_OPTS environment variable to pass any custom JVM option.");
                }
                this.jvmOptions = this.jvmOptions.isEmpty() ? jvmOpt : this.jvmOptions + ARGS_DELIMITER + jvmOpt;
                continue;
            }
            if (this.springCfgPath.isEmpty()) {
                this.springCfgPath = arg;
                continue;
            }
            throw new RuntimeException("Unrecognised parameter has been found: " + arg);
        }
        if (!hadFileEncoding) {
            this.jvmOptions = (this.jvmOptions.isEmpty() ? "" : this.jvmOptions + ARGS_DELIMITER) + "-Dfile.encoding=UTF-8";
        }
    }

    private boolean checkJVMOptionIsSupported(String jvmOpt) {
        return !jvmOpt.contains("-XX:OnError") && !jvmOpt.contains("-XX:OnOutOfMemoryError");
    }
}

