/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.util;

import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.ClusterActivationEvent;
import org.apache.ignite.events.DeploymentEvent;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.JobEvent;
import org.apache.ignite.events.TaskEvent;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.event.VisorGridDeploymentEvent;
import org.apache.ignite.internal.visor.event.VisorGridDiscoveryEvent;
import org.apache.ignite.internal.visor.event.VisorGridEvent;
import org.apache.ignite.internal.visor.event.VisorGridJobEvent;
import org.apache.ignite.internal.visor.event.VisorGridTaskEvent;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteUuid;

public class VisorEventMapper
implements IgniteClosure<Event, VisorGridEvent> {
    private static final long serialVersionUID = 0L;

    protected VisorGridEvent map(Event evt, int type, IgniteUuid id, String name, UUID nid, long ts, String msg, String shortDisplay) {
        if (evt instanceof TaskEvent) {
            return this.taskEvent((TaskEvent)evt, type, id, name, nid, ts, msg, shortDisplay);
        }
        if (evt instanceof JobEvent) {
            return this.jobEvent((JobEvent)evt, type, id, name, nid, ts, msg, shortDisplay);
        }
        if (evt instanceof DeploymentEvent) {
            return this.deploymentEvent((DeploymentEvent)evt, type, id, name, nid, ts, msg, shortDisplay);
        }
        if (evt instanceof DiscoveryEvent) {
            return this.discoveryEvent((DiscoveryEvent)evt, type, id, name, nid, ts, msg, shortDisplay);
        }
        if (evt instanceof ClusterActivationEvent) {
            return new VisorGridEvent(type, id, name, nid, ts, msg, shortDisplay);
        }
        return new VisorGridEvent(type, id, name, nid, ts, msg, shortDisplay);
    }

    protected VisorGridEvent taskEvent(TaskEvent te, int type, IgniteUuid id, String name, UUID nid, long ts, String msg, String shortDisplay) {
        return new VisorGridTaskEvent(type, id, name, nid, ts, msg, shortDisplay, te.taskName(), te.taskClassName(), te.taskSessionId(), te.internal());
    }

    protected VisorGridEvent jobEvent(JobEvent je, int type, IgniteUuid id, String name, UUID nid, long ts, String msg, String shortDisplay) {
        return new VisorGridJobEvent(type, id, name, nid, ts, msg, shortDisplay, je.taskName(), je.taskClassName(), je.taskSessionId(), je.jobId());
    }

    protected VisorGridEvent deploymentEvent(DeploymentEvent de, int type, IgniteUuid id, String name, UUID nid, long ts, String msg, String shortDisplay) {
        return new VisorGridDeploymentEvent(type, id, name, nid, ts, msg, shortDisplay, de.alias());
    }

    protected VisorGridEvent discoveryEvent(DiscoveryEvent de, int type, IgniteUuid id, String name, UUID nid, long ts, String msg, String shortDisplay) {
        ClusterNode node = de.eventNode();
        return new VisorGridDiscoveryEvent(type, id, name, nid, ts, msg, shortDisplay, node.id(), F.first(node.addresses()), node.isDaemon(), de.topologyVersion());
    }

    @Override
    public VisorGridEvent apply(Event evt) {
        return this.map(evt, evt.type(), evt.id(), evt.name(), evt.node().id(), evt.timestamp(), evt.message(), evt.shortDisplay());
    }
}

