/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.dr;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.tree.updatelog.PartitionLogTree;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.dr.VisorDrRebuildTreeTaskArgs;
import org.apache.ignite.internal.visor.dr.VisorDrRebuildTreeTaskResult;
import org.apache.ignite.maintenance.MaintenanceAction;
import org.apache.ignite.maintenance.MaintenanceRegistry;
import org.apache.ignite.maintenance.MaintenanceTask;
import org.jetbrains.annotations.Nullable;

@GridInternal
@GridVisorManagementTask
public class VisorDrRebuildTreeTask
extends VisorOneNodeTask<VisorDrRebuildTreeTaskArgs, VisorDrRebuildTreeTaskResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<VisorDrRebuildTreeTaskArgs, VisorDrRebuildTreeTaskResult> job(VisorDrRebuildTreeTaskArgs arg) {
        return new RebuildJob(arg, this.debug);
    }

    private static class RebuildJob
    extends VisorJob<VisorDrRebuildTreeTaskArgs, VisorDrRebuildTreeTaskResult> {
        private static final long serialVersionUID = 0L;

        RebuildJob(@Nullable VisorDrRebuildTreeTaskArgs arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorDrRebuildTreeTaskResult run(@Nullable VisorDrRebuildTreeTaskArgs arg) throws IgniteException {
            if (arg != null) {
                switch (arg.op()) {
                    case STATUS: {
                        return this.runStatus();
                    }
                    case CANCEL: {
                        return this.runCancel();
                    }
                }
            }
            Set<Integer> groupIds = new HashSet<Integer>();
            ArrayList<String> failures = new ArrayList<String>();
            if (arg != null) {
                this.extractGroupIds(arg, groupIds::add, failures::add);
            }
            if (groupIds.isEmpty() && failures.isEmpty() && (groupIds = this.ignite.context().cache().cacheGroups().stream().filter(CacheGroupContext::isDrEnabled).map(CacheGroupContext::groupId).collect(Collectors.toSet())).isEmpty()) {
                failures.add("No cache groups with DR caches found.");
            }
            if (groupIds.isEmpty()) {
                return new VisorDrRebuildTreeTaskResult(failures);
            }
            MaintenanceRegistry mntcReg = this.ignite.context().maintenanceRegistry();
            if (mntcReg.isMaintenanceMode()) {
                return this.runMaintenanceTask(groupIds, mntcReg);
            }
            return this.scheduleMaintenanceTask(groupIds, mntcReg);
        }

        private VisorDrRebuildTreeTaskResult scheduleMaintenanceTask(Set<Integer> groupIds, MaintenanceRegistry mntcReg) {
            try {
                MaintenanceTask task = PartitionLogTree.toMaintenanceTask(groupIds);
                mntcReg.registerMaintenanceTask(task, oldTask -> PartitionLogTree.mergeTasks(oldTask, task));
                return new VisorDrRebuildTreeTaskResult(true, "Maintenance task was (re)scheduled: " + this.taskName());
            }
            catch (IgniteCheckedException ex) {
                this.ignite.log().warning("Failed to register maintenance record for corrupted partition files.", ex);
                return new VisorDrRebuildTreeTaskResult(false, "Failed schedule maintenance task: " + this.taskName());
            }
        }

        private VisorDrRebuildTreeTaskResult runMaintenanceTask(Set<Integer> groupIds, MaintenanceRegistry mntcReg) {
            if (mntcReg.requestedTask("PartitionLogTreeRebuildMaintenanceTask") != null) {
                return new VisorDrRebuildTreeTaskResult(false, "Maintenance task is already in progress: " + this.taskName());
            }
            try {
                MaintenanceTask task = PartitionLogTree.toMaintenanceTask(groupIds);
                mntcReg.registerMaintenanceTask(task, oldTask -> PartitionLogTree.mergeTasks(oldTask, task));
                mntcReg.actionsForMaintenanceTask("PartitionLogTreeRebuildMaintenanceTask").forEach(MaintenanceAction::execute);
                mntcReg.unregisterMaintenanceTask("PartitionLogTreeRebuildMaintenanceTask");
                return new VisorDrRebuildTreeTaskResult(true, "Maintenance task finished: " + this.taskName());
            }
            catch (IgniteCheckedException ex) {
                this.ignite.log().warning("Failed to register maintenance record for corrupted partition files.", ex);
                return new VisorDrRebuildTreeTaskResult(false, "Failed run maintenance task: " + this.taskName());
            }
        }

        private VisorDrRebuildTreeTaskResult runCancel() {
            MaintenanceRegistry mntcReg = this.ignite.context().maintenanceRegistry();
            if (mntcReg.isMaintenanceMode()) {
                return new VisorDrRebuildTreeTaskResult(false, "Maintenance task can't be cancelled while in progress: " + this.taskName());
            }
            if (mntcReg.unregisterMaintenanceTask("PartitionLogTreeRebuildMaintenanceTask")) {
                return new VisorDrRebuildTreeTaskResult(true, "Maintenance task is cancelled: " + this.taskName());
            }
            return new VisorDrRebuildTreeTaskResult(false, "Nothing to do. Maintenance task wasn't scheduled: " + this.taskName());
        }

        private VisorDrRebuildTreeTaskResult runStatus() {
            MaintenanceRegistry mntcReg = this.ignite.context().maintenanceRegistry();
            MaintenanceTask task = mntcReg.requestedTask("PartitionLogTreeRebuildMaintenanceTask");
            boolean inMaintenanceMode = mntcReg.isMaintenanceMode();
            String status = inMaintenanceMode ? (task != null ? this.taskName() + " task is in progress: [params=" + task.parameters() + ']' : this.taskName() + " was finished or never scheduled.") : (task != null ? this.taskName() + " task is scheduled: [params=" + task.parameters() + ']' : this.taskName() + " is not scheduled.");
            return new VisorDrRebuildTreeTaskResult(false, status);
        }

        private void extractGroupIds(VisorDrRebuildTreeTaskArgs arg, Consumer<Integer> groupIds, Consumer<String> failures) {
            GridCacheProcessor cacheProc = this.ignite.context().cache();
            if (!F.isEmpty(arg.caches())) {
                arg.caches().forEach(cacheName -> {
                    DynamicCacheDescriptor desc = cacheProc.cacheDescriptor((String)cacheName);
                    if (desc != null) {
                        groupIds.accept(desc.groupId());
                    } else {
                        failures.accept("Failed to find cache: " + cacheName);
                    }
                });
            }
            if (!F.isEmpty(arg.groups())) {
                arg.groups().forEach(grpName -> {
                    CacheGroupDescriptor desc = cacheProc.cacheGroupDescriptor(CU.cacheId(grpName));
                    if (desc != null) {
                        groupIds.accept(desc.groupId());
                    } else {
                        failures.accept("Failed to find cache group: " + grpName);
                    }
                });
            }
        }

        private String taskName() {
            return "Partition log tree rebuild";
        }
    }
}

