/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.baseline;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.managers.discovery.IgniteClusterNode;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.baseline.VisorBaselineNode;

public class VisorBaselineTaskResult
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private boolean active;
    private long topVer;
    private Map<String, VisorBaselineNode> baseline;
    private Map<String, VisorBaselineNode> servers;
    private Boolean autoAdjustEnabled;
    private Long autoAdjustAwaitingTime;
    private long remainingTimeToBaselineAdjust = -1L;
    private boolean baselineAdjustInProgress = false;

    public VisorBaselineTaskResult() {
    }

    private static Map<String, VisorBaselineNode> toMap(Collection<? extends BaselineNode> nodes) {
        if (F.isEmpty(nodes)) {
            return null;
        }
        TreeMap<String, VisorBaselineNode> map = new TreeMap<String, VisorBaselineNode>();
        for (BaselineNode baselineNode : nodes) {
            VisorBaselineNode dto = new VisorBaselineNode(baselineNode, Collections.emptyList());
            map.put(dto.getConsistentId(), dto);
        }
        return map;
    }

    private static Map<String, VisorBaselineNode> toMapWithResolvedAddresses(Collection<? extends BaselineNode> nodes) {
        if (F.isEmpty(nodes)) {
            return null;
        }
        TreeMap<String, VisorBaselineNode> map = new TreeMap<String, VisorBaselineNode>();
        for (BaselineNode baselineNode : nodes) {
            ArrayList<VisorBaselineNode.ResolvedAddresses> addrs = new ArrayList<VisorBaselineNode.ResolvedAddresses>();
            if (baselineNode instanceof IgniteClusterNode) {
                for (InetAddress inetAddress : VisorBaselineTaskResult.resolveInetAddresses((ClusterNode)baselineNode)) {
                    addrs.add(new VisorBaselineNode.ResolvedAddresses(inetAddress));
                }
            }
            VisorBaselineNode dto = new VisorBaselineNode(baselineNode, addrs);
            map.put(dto.getConsistentId(), dto);
        }
        return map;
    }

    private static Collection<InetAddress> resolveInetAddresses(ClusterNode node) {
        HashSet<InetAddress> res = new HashSet<InetAddress>(node.addresses().size());
        Iterator<String> hostNamesIt = node.hostNames().iterator();
        for (String addr : node.addresses()) {
            String hostName = hostNamesIt.hasNext() ? hostNamesIt.next() : null;
            InetAddress inetAddr = null;
            if (!F.isEmpty(hostName)) {
                try {
                    if (IgniteSystemProperties.getBoolean("IGNITE_TEST_ENV")) {
                        if (hostName.endsWith(".hostname")) {
                            String ipStr = hostName.substring(0, hostName.length() - ".hostname".length());
                            inetAddr = InetAddress.getByAddress(hostName, InetAddress.getByName(ipStr).getAddress());
                        }
                    } else {
                        inetAddr = InetAddress.getByName(hostName);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if (inetAddr == null || inetAddr.isLoopbackAddress()) {
                try {
                    inetAddr = IgniteSystemProperties.getBoolean("IGNITE_TEST_ENV") ? InetAddress.getByAddress(addr + ".hostname", InetAddress.getByName(addr).getAddress()) : InetAddress.getByName(addr);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if (inetAddr == null) continue;
            res.add(inetAddr);
        }
        return res;
    }

    public VisorBaselineTaskResult(boolean active, long topVer, Collection<? extends BaselineNode> baseline, Collection<? extends BaselineNode> servers, Boolean autoAdjustEnabled, Long autoAdjustAwaitingTime, long remainingTimeToBaselineAdjust, boolean baselineAdjustInProgress) {
        this.active = active;
        this.topVer = topVer;
        this.baseline = VisorBaselineTaskResult.toMap(baseline);
        this.servers = VisorBaselineTaskResult.toMapWithResolvedAddresses(servers);
        this.autoAdjustEnabled = autoAdjustEnabled;
        this.autoAdjustAwaitingTime = autoAdjustAwaitingTime;
        this.remainingTimeToBaselineAdjust = remainingTimeToBaselineAdjust;
        this.baselineAdjustInProgress = baselineAdjustInProgress;
    }

    public boolean isActive() {
        return this.active;
    }

    public long getTopologyVersion() {
        return this.topVer;
    }

    public Map<String, VisorBaselineNode> getBaseline() {
        return this.baseline;
    }

    public Map<String, VisorBaselineNode> getServers() {
        return this.servers;
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    public Boolean isAutoAdjustEnabled() {
        return this.autoAdjustEnabled;
    }

    public Long getAutoAdjustAwaitingTime() {
        return this.autoAdjustAwaitingTime;
    }

    public long getRemainingTimeToBaselineAdjust() {
        return this.remainingTimeToBaselineAdjust;
    }

    public boolean isBaselineAdjustInProgress() {
        return this.baselineAdjustInProgress;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeBoolean(this.active);
        out.writeLong(this.topVer);
        U.writeMap(out, this.baseline);
        U.writeMap(out, this.servers);
        out.writeObject(this.autoAdjustEnabled);
        out.writeObject(this.autoAdjustAwaitingTime);
        out.writeLong(this.remainingTimeToBaselineAdjust);
        out.writeBoolean(this.baselineAdjustInProgress);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.active = in.readBoolean();
        this.topVer = in.readLong();
        this.baseline = U.readTreeMap(in);
        this.servers = U.readTreeMap(in);
        if (protoVer > 1) {
            this.autoAdjustEnabled = (Boolean)in.readObject();
            this.autoAdjustAwaitingTime = (Long)in.readObject();
            this.remainingTimeToBaselineAdjust = in.readLong();
            this.baselineAdjustInProgress = in.readBoolean();
        }
    }

    public String toString() {
        return S.toString(VisorBaselineTaskResult.class, this);
    }
}

