/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.util.typedef.F;

public final class GridArrays {
    private GridArrays() {
    }

    public static <T> T[] set(T[] arr, int idx, T o) {
        int len = arr.length;
        if (idx >= len) {
            len += len >>> 1;
            len = Math.max(len, idx + 1);
            arr = Arrays.copyOf(arr, len);
        }
        arr[idx] = o;
        return arr;
    }

    public static <T> T[] remove(T[] arr, int idx) {
        int len = arr.length;
        assert (idx >= 0 && idx < len) : idx + " < " + len;
        if (idx == len - 1) {
            return Arrays.copyOfRange(arr, 0, len - 1);
        }
        if (idx == 0) {
            return Arrays.copyOfRange(arr, 1, len);
        }
        Object[] res = (Object[])Array.newInstance(arr.getClass().getComponentType(), len - 1);
        System.arraycopy(arr, 0, res, 0, idx);
        System.arraycopy(arr, idx + 1, res, idx, len - idx - 1);
        return res;
    }

    public static long[] remove(long[] arr, int idx) {
        int len = arr.length;
        assert (idx >= 0 && idx < len) : idx + " < " + len;
        if (idx == len - 1) {
            return Arrays.copyOfRange(arr, 0, len - 1);
        }
        if (idx == 0) {
            return Arrays.copyOfRange(arr, 1, len);
        }
        long[] res = new long[len - 1];
        System.arraycopy(arr, 0, res, 0, idx);
        System.arraycopy(arr, idx + 1, res, idx, len - idx - 1);
        return res;
    }

    public static void clearTail(Object[] arr, int fromIdx) {
        while (fromIdx < arr.length && arr[fromIdx] != null) {
            arr[fromIdx++] = null;
        }
    }

    public static int[] subtract(int[] a, int[] b) {
        Set bSet = Arrays.stream(b).boxed().collect(Collectors.toSet());
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int aVal : a) {
            if (bSet.contains(aVal)) continue;
            res.add(aVal);
        }
        return res.stream().mapToInt(Integer::intValue).toArray();
    }

    public static List<Integer> list(int[] arr) {
        if (F.isEmpty(arr)) {
            return Collections.emptyList();
        }
        ArrayList<Integer> res = new ArrayList<Integer>(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            res.add(arr[i]);
        }
        return res;
    }
}

