/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.odbc;

import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.processors.authentication.AuthorizationContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerAbstractConnectionContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerMessageParser;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponseSender;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcMessageParser;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcRequestHandler;
import org.apache.ignite.internal.processors.query.NestedTxMode;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.nio.GridNioSession;

public class OdbcConnectionContext
extends ClientListenerAbstractConnectionContext {
    public static final ClientListenerProtocolVersion VER_2_1_0 = ClientListenerProtocolVersion.create(2, 1, 0);
    public static final ClientListenerProtocolVersion VER_2_1_5 = ClientListenerProtocolVersion.create(2, 1, 5);
    public static final ClientListenerProtocolVersion VER_2_3_0 = ClientListenerProtocolVersion.create(2, 3, 0);
    public static final ClientListenerProtocolVersion VER_2_3_2 = ClientListenerProtocolVersion.create(2, 3, 2);
    public static final ClientListenerProtocolVersion VER_2_5_0 = ClientListenerProtocolVersion.create(2, 5, 0);
    public static final ClientListenerProtocolVersion VER_2_7_0 = ClientListenerProtocolVersion.create(2, 7, 0);
    public static final ClientListenerProtocolVersion VER_2_8_0;
    private static final ClientListenerProtocolVersion CURRENT_VER;
    private static final Set<ClientListenerProtocolVersion> SUPPORTED_VERS;
    private final GridSpinBusyLock busyLock;
    private final int maxCursors;
    private OdbcMessageParser parser;
    private OdbcRequestHandler handler;
    private final IgniteLogger log;

    public OdbcConnectionContext(GridKernalContext ctx, GridNioSession ses, GridSpinBusyLock busyLock, long connId, int maxCursors) {
        super(ctx, ses, connId);
        this.busyLock = busyLock;
        this.maxCursors = maxCursors;
        this.log = ctx.log(this.getClass());
    }

    @Override
    public byte clientType() {
        return 0;
    }

    @Override
    public boolean isVersionSupported(ClientListenerProtocolVersion ver) {
        return SUPPORTED_VERS.contains(ver);
    }

    @Override
    public ClientListenerProtocolVersion defaultVersion() {
        return CURRENT_VER;
    }

    @Override
    public void initializeFromHandshake(final GridNioSession ses, ClientListenerProtocolVersion ver, BinaryReaderExImpl reader) throws IgniteCheckedException {
        assert (SUPPORTED_VERS.contains(ver)) : "Unsupported ODBC protocol version.";
        boolean distributedJoins = reader.readBoolean();
        boolean enforceJoinOrder = reader.readBoolean();
        boolean replicatedOnly = reader.readBoolean();
        boolean collocated = reader.readBoolean();
        boolean lazy = false;
        if (ver.compareTo(VER_2_1_5) >= 0) {
            lazy = reader.readBoolean();
        }
        boolean skipReducerOnUpdate = false;
        if (ver.compareTo(VER_2_3_0) >= 0) {
            skipReducerOnUpdate = reader.readBoolean();
        }
        String user = null;
        String passwd = null;
        NestedTxMode nestedTxMode = NestedTxMode.DEFAULT;
        if (ver.compareTo(VER_2_5_0) >= 0) {
            user = reader.readString();
            passwd = reader.readString();
        }
        if (ver.compareTo(VER_2_7_0) >= 0) {
            byte nestedTxModeVal = reader.readByte();
            nestedTxMode = NestedTxMode.fromByte(nestedTxModeVal);
        }
        AuthorizationContext actx = this.authenticate(ses.remoteAddress(), ses.certificates(), user, passwd);
        ClientListenerResponseSender sender = new ClientListenerResponseSender(){

            @Override
            public void send(ClientListenerResponse resp) {
                if (resp != null) {
                    if (OdbcConnectionContext.this.log.isDebugEnabled()) {
                        OdbcConnectionContext.this.log.debug("Async response: [resp=" + resp.status() + ']');
                    }
                    ses.send(OdbcConnectionContext.this.parser.encode(resp));
                }
            }
        };
        this.initClientDescriptor("odbc");
        this.handler = new OdbcRequestHandler(this.ctx, this.busyLock, sender, this.maxCursors, distributedJoins, enforceJoinOrder, replicatedOnly, collocated, lazy, skipReducerOnUpdate, actx, nestedTxMode, ver, this);
        this.parser = new OdbcMessageParser(this.ctx, ver);
        this.handler.start();
    }

    @Override
    public ClientListenerRequestHandler handler() {
        return this.handler;
    }

    @Override
    public ClientListenerMessageParser parser() {
        return this.parser;
    }

    @Override
    public void onDisconnected() {
        this.handler.onDisconnect();
        super.onDisconnected();
    }

    static {
        CURRENT_VER = VER_2_8_0 = ClientListenerProtocolVersion.create(2, 8, 0);
        SUPPORTED_VERS = new HashSet<ClientListenerProtocolVersion>();
        SUPPORTED_VERS.add(CURRENT_VER);
        SUPPORTED_VERS.add(VER_2_7_0);
        SUPPORTED_VERS.add(VER_2_5_0);
        SUPPORTED_VERS.add(VER_2_3_0);
        SUPPORTED_VERS.add(VER_2_3_2);
        SUPPORTED_VERS.add(VER_2_1_5);
        SUPPORTED_VERS.add(VER_2_1_0);
    }
}

