/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcMetaTablesRequest
extends JdbcRequest {
    private String schemaName;
    private String tblName;
    private String[] tblTypes;

    JdbcMetaTablesRequest() {
        super((byte)7);
    }

    public JdbcMetaTablesRequest(String schemaName, String tblName, String[] tblTypes) {
        super((byte)7);
        this.schemaName = schemaName;
        this.tblName = tblName;
        this.tblTypes = tblTypes;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tblName;
    }

    public String[] tableTypes() {
        return this.tblTypes;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.writeBinary(writer, protoCtx);
        writer.writeString(this.schemaName);
        writer.writeString(this.tblName);
        if (protoCtx.isTableTypesSupported()) {
            writer.writeStringArray(this.tblTypes);
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.readBinary(reader, protoCtx);
        this.schemaName = reader.readString();
        this.tblName = reader.readString();
        try {
            if (protoCtx.isTableTypesSupported()) {
                this.tblTypes = reader.readStringArray();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        return S.toString(JdbcMetaTablesRequest.class, this);
    }
}

