/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class TxLock
implements Message {
    private static final long serialVersionUID = 0L;
    static final byte OWNERSHIP_OWNER = 1;
    static final byte OWNERSHIP_CANDIDATE = 2;
    static final byte OWNERSHIP_REQUESTED = 3;
    private UUID nearNodeId;
    private GridCacheVersion txId;
    private long threadId;
    private byte ownership;

    public TxLock() {
    }

    public TxLock(GridCacheVersion txId, UUID nearNodeId, long threadId, byte ownership) {
        this.txId = txId;
        this.nearNodeId = nearNodeId;
        this.threadId = threadId;
        this.ownership = ownership;
    }

    public UUID nearNodeId() {
        return this.nearNodeId;
    }

    public GridCacheVersion txId() {
        return this.txId;
    }

    public long threadId() {
        return this.threadId;
    }

    public boolean owner() {
        return this.ownership == 1;
    }

    public boolean candiate() {
        return this.ownership == 2;
    }

    public boolean requested() {
        return this.ownership == 3;
    }

    public String toString() {
        return S.toString(TxLock.class, this);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeUuid("nearNodeId", this.nearNodeId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByte("ownership", this.ownership)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeLong("threadId", this.threadId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeMessage("txId", this.txId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.nearNodeId = reader.readUuid("nearNodeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.ownership = reader.readByte("ownership");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.threadId = reader.readLong("threadId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.txId = (GridCacheVersion)reader.readMessage("txId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxLock.class);
    }

    @Override
    public short directType() {
        return -25;
    }

    @Override
    public byte fieldsCount() {
        return 4;
    }

    @Override
    public void onAckReceived() {
    }
}

