/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheMvccManager;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.HistogramMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.IntMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.transactions.TransactionMetrics;
import org.apache.ignite.transactions.TransactionState;

public class TransactionMetricsAdapter
implements TransactionMetrics {
    public static final String METRIC_TOTAL_SYSTEM_TIME = "totalNodeSystemTime";
    public static final String METRIC_SYSTEM_TIME_HISTOGRAM = "nodeSystemTimeHistogram";
    public static final String METRIC_TOTAL_USER_TIME = "totalNodeUserTime";
    public static final String METRIC_USER_TIME_HISTOGRAM = "nodeUserTimeHistogram";
    public static final long[] METRIC_TIME_BUCKETS = new long[]{1L, 2L, 4L, 8L, 16L, 25L, 50L, 75L, 100L, 250L, 500L, 750L, 1000L, 3000L, 5000L, 10000L, 25000L, 60000L};
    private final GridKernalContext gridKernalCtx;
    private final IntMetricImpl txCommits;
    private final IntMetricImpl txRollbacks;
    private final AtomicLongMetric commitTime;
    private final AtomicLongMetric rollbackTime;
    private LongAdderMetric totalTxSystemTime;
    private LongAdderMetric totalTxUserTime;
    private HistogramMetricImpl txSystemTimeHistogram;
    private HistogramMetricImpl txUserTimeHistogram;

    public TransactionMetricsAdapter(GridKernalContext ctx) {
        this.gridKernalCtx = ctx;
        MetricRegistry mreg = this.gridKernalCtx.metric().registry("tx");
        this.txCommits = mreg.intMetric("txCommits", "Number of transaction commits.");
        this.txRollbacks = mreg.intMetric("txRollbacks", "Number of transaction rollbacks.");
        this.commitTime = mreg.longMetric("commitTime", "Last commit time.");
        this.rollbackTime = mreg.longMetric("rollbackTime", "Last rollback time.");
        this.totalTxSystemTime = mreg.longAdderMetric(METRIC_TOTAL_SYSTEM_TIME, "Total transactions system time on node.");
        this.totalTxUserTime = mreg.longAdderMetric(METRIC_TOTAL_USER_TIME, "Total transactions user time on node.");
        this.txSystemTimeHistogram = mreg.histogram(METRIC_SYSTEM_TIME_HISTOGRAM, METRIC_TIME_BUCKETS, "Transactions system times on node represented as histogram.");
        this.txUserTimeHistogram = mreg.histogram(METRIC_USER_TIME_HISTOGRAM, METRIC_TIME_BUCKETS, "Transactions user times on node represented as histogram.");
    }

    public void onTxManagerStarted() {
        MetricRegistry mreg = this.gridKernalCtx.metric().registry("tx");
        mreg.register("AllOwnerTransactions", this::getAllOwnerTransactions, Map.class, "Map of local node owning transactions.");
        mreg.register("TransactionsHoldingLockNumber", this::getTransactionsHoldingLockNumber, "The number of active transactions holding at least one key lock.");
        mreg.register("LockedKeysNumber", this::txLockedKeysNum, "The number of keys locked on the node.");
        mreg.register("OwnerTransactionsNumber", this::nearTxNum, "The number of active transactions for which this node is the initiator.");
    }

    @Override
    public long commitTime() {
        return this.commitTime.value();
    }

    @Override
    public long rollbackTime() {
        return this.rollbackTime.value();
    }

    @Override
    public int txCommits() {
        return this.txCommits.value();
    }

    @Override
    public int txRollbacks() {
        return this.txRollbacks.value();
    }

    @Override
    public Map<String, String> getAllOwnerTransactions() {
        return this.getNearTxs(0L);
    }

    @Override
    public Map<String, String> getLongRunningOwnerTransactions(int duration) {
        return this.getNearTxs(duration);
    }

    @Override
    public long getTransactionsCommittedNumber() {
        return this.gridKernalCtx.cache().context().txMetrics().txCommits();
    }

    @Override
    public long getTransactionsRolledBackNumber() {
        return this.gridKernalCtx.cache().context().txMetrics().txRollbacks();
    }

    @Override
    public long getTransactionsHoldingLockNumber() {
        return this.txHoldingLockNum();
    }

    @Override
    public long getLockedKeysNumber() {
        return this.txLockedKeysNum();
    }

    @Override
    public long getOwnerTransactionsNumber() {
        return this.nearTxNum();
    }

    public void onTxCommit() {
        this.commitTime.value(U.currentTimeMillis());
        this.txCommits.increment();
    }

    public void onTxRollback() {
        this.rollbackTime.value(U.currentTimeMillis());
        this.txRollbacks.increment();
    }

    public void onNearTxComplete(long sysTime, long userTime) {
        if (sysTime >= 0L) {
            this.totalTxSystemTime.add(sysTime);
            this.txSystemTimeHistogram.value(sysTime);
        }
        if (userTime >= 0L) {
            this.totalTxUserTime.add(userTime);
            this.txUserTimeHistogram.value(userTime);
        }
    }

    public void reset() {
        this.commitTime.reset();
        this.txCommits.reset();
        this.rollbackTime.reset();
        this.txRollbacks.reset();
    }

    public TransactionMetrics snapshot() {
        return new TransactionMetricsSnapshot(this);
    }

    private Map<String, String> getNearTxs(long duration) {
        Collection<GridNearTxLocal> txs = this.nearTxs(duration);
        HashMap<String, String> res = new HashMap<String, String>(txs.size());
        for (GridNearTxLocal tx : txs) {
            res.put(tx.xid().toString(), this.composeTx(tx));
        }
        return res;
    }

    private String composeNodeInfo(UUID id) {
        ClusterNode node = this.gridKernalCtx.discovery().node(id);
        if (node == null) {
            return "";
        }
        return String.format("%s %s", node.id(), node.hostNames());
    }

    private String composeNodeInfo(Set<UUID> ids) {
        GridStringBuilder sb = new GridStringBuilder();
        sb.a("[");
        String delim = "";
        for (UUID id : ids) {
            sb.a(delim).a(this.composeNodeInfo(id));
            delim = ", ";
        }
        sb.a("]");
        return sb.toString();
    }

    private String composeTx(GridNearTxLocal tx) {
        Set<UUID> primaryNodes;
        Map<UUID, Collection<UUID>> transactionNodes;
        TransactionState txState = tx.state();
        String top = (Object)((Object)txState) + ", NEAR, ";
        if (txState == TransactionState.PREPARING && !F.isEmpty(transactionNodes = tx.transactionNodes()) && !F.isEmpty(primaryNodes = transactionNodes.keySet())) {
            top = top + "PRIMARY: " + this.composeNodeInfo(primaryNodes) + ", ";
        }
        Long duration = System.currentTimeMillis() - tx.startTime();
        return top + "DURATION: " + duration;
    }

    private Collection<GridNearTxLocal> nearTxs(final long duration) {
        final long start = System.currentTimeMillis();
        IgniteClosure<IgniteInternalTx, GridNearTxLocal> c = new IgniteClosure<IgniteInternalTx, GridNearTxLocal>(){

            @Override
            public GridNearTxLocal apply(IgniteInternalTx tx) {
                return (GridNearTxLocal)tx;
            }
        };
        IgnitePredicate<IgniteInternalTx> pred = new IgnitePredicate<IgniteInternalTx>(){

            @Override
            public boolean apply(IgniteInternalTx tx) {
                return tx.local() && tx.near() && start - tx.startTime() >= duration;
            }
        };
        return F.viewReadOnly(this.gridKernalCtx.cache().context().tm().activeTransactions(), c, pred);
    }

    private long nearTxNum() {
        IgnitePredicate<IgniteInternalTx> pred = new IgnitePredicate<IgniteInternalTx>(){

            @Override
            public boolean apply(IgniteInternalTx tx) {
                return tx.local() && tx.near();
            }
        };
        return F.size(this.gridKernalCtx.cache().context().tm().activeTransactions(), pred);
    }

    private long txHoldingLockNum() {
        long holdingLockCounter = 0L;
        IgniteTxManager tm = this.gridKernalCtx.cache().context().tm();
        for (IgniteInternalTx tx : tm.activeTransactions()) {
            if (tx.optimistic() && tx.state() == TransactionState.ACTIVE || tx.empty() || !tx.local()) continue;
            ++holdingLockCounter;
        }
        return holdingLockCounter;
    }

    private long txLockedKeysNum() {
        GridCacheMvccManager mvccManager = this.gridKernalCtx.cache().context().mvcc();
        if (mvccManager == null) {
            return 0L;
        }
        return mvccManager.lockedKeys().size() + mvccManager.nearLockedKeys().size();
    }

    public String toString() {
        return S.toString(TransactionMetricsAdapter.class, this);
    }

    public static class TransactionMetricsSnapshot
    implements TransactionMetrics,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private volatile int txCommits;
        private volatile int txRollbacks;
        private volatile long commitTime;
        private volatile long rollbackTime;
        private volatile TransactionMetricsAdapter adapter;

        public TransactionMetricsSnapshot() {
            this(null);
        }

        public TransactionMetricsSnapshot(TransactionMetricsAdapter adapter) {
            this.adapter = adapter;
        }

        @Override
        public long commitTime() {
            return this.adapter != null ? this.adapter.commitTime() : this.commitTime;
        }

        @Override
        public long rollbackTime() {
            return this.adapter != null ? this.adapter.rollbackTime() : this.rollbackTime;
        }

        @Override
        public int txCommits() {
            return this.adapter != null ? this.adapter.txCommits() : this.txCommits;
        }

        @Override
        public int txRollbacks() {
            return this.adapter != null ? this.adapter.txRollbacks() : this.txRollbacks;
        }

        @Override
        public Map<String, String> getAllOwnerTransactions() {
            return this.adapter != null ? this.adapter.getAllOwnerTransactions() : null;
        }

        @Override
        public Map<String, String> getLongRunningOwnerTransactions(int duration) {
            return this.adapter != null ? this.adapter.getLongRunningOwnerTransactions(duration) : null;
        }

        @Override
        public long getTransactionsCommittedNumber() {
            return this.adapter != null ? this.adapter.getTransactionsCommittedNumber() : 0L;
        }

        @Override
        public long getTransactionsRolledBackNumber() {
            return this.adapter != null ? this.adapter.getTransactionsRolledBackNumber() : 0L;
        }

        @Override
        public long getTransactionsHoldingLockNumber() {
            return this.adapter != null ? this.adapter.getTransactionsHoldingLockNumber() : 0L;
        }

        @Override
        public long getLockedKeysNumber() {
            return this.adapter != null ? this.adapter.getLockedKeysNumber() : 0L;
        }

        @Override
        public long getOwnerTransactionsNumber() {
            return this.adapter != null ? this.adapter.getOwnerTransactionsNumber() : 0L;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.commitTime);
            out.writeLong(this.rollbackTime);
            out.writeInt(this.txCommits);
            out.writeInt(this.txRollbacks);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.commitTime = in.readLong();
            this.rollbackTime = in.readLong();
            this.txCommits = in.readInt();
            this.txRollbacks = in.readInt();
        }
    }
}

