/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.FastCrc;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.spi.encryption.EncryptionSpi;

public class EncryptionUtil {
    private final EncryptionSpi encSpi;
    private final int pageSize;
    private final int encryptionOverhead;
    private final byte[] zeroes;

    public EncryptionUtil(EncryptionSpi spi, int pageSize) {
        this.encSpi = spi;
        this.pageSize = pageSize;
        this.encryptionOverhead = pageSize - CU.encryptedPageSize(pageSize, this.encSpi);
        this.zeroes = new byte[this.encryptionOverhead];
    }

    public void encrypt(ByteBuffer srcBuf, ByteBuffer res, GroupKey grpKey) {
        assert (srcBuf.remaining() >= this.pageSize) : "The number of elements remaining in buffer should be more or equal to page size [srcBuf.remaining() = " + srcBuf.remaining() + ", pageSize = " + this.pageSize + "]";
        assert (this.tailIsEmpty(srcBuf, PageIO.getType(srcBuf)));
        int srcLimit = srcBuf.limit();
        srcBuf.limit(srcBuf.position() + this.plainDataSize());
        this.encSpi.encryptNoPadding(srcBuf, grpKey.key(), res);
        res.rewind();
        this.storeCRC(res);
        res.put(grpKey.id());
        srcBuf.limit(srcLimit);
        srcBuf.position(srcBuf.position() + this.encryptionOverhead);
    }

    public void decrypt(ByteBuffer encrypted, ByteBuffer destBuf, GroupKey grpKey) throws IOException {
        assert (encrypted.remaining() >= this.pageSize) : "The number of elements remaining in encrypted buffer should be more or equal to page size [encrypted.remaining() = " + encrypted.remaining() + ", pageSize = " + this.pageSize + "]";
        assert (encrypted.limit() >= this.pageSize) : "The limit of the encrypted buffer should be more or equal to page size [encrypted.limit() = " + encrypted.limit() + ", pageSize = " + this.pageSize + "]";
        int crc = FastCrc.calcCrc(encrypted, this.encryptedDataSize());
        int storedCrc = 0;
        storedCrc |= encrypted.get() << 24;
        storedCrc |= (encrypted.get() & 0xFF) << 16;
        storedCrc |= (encrypted.get() & 0xFF) << 8;
        if (crc != (storedCrc |= encrypted.get() & 0xFF)) {
            throw new IOException("Content of encrypted page is broken. [StoredCrc=" + storedCrc + ", calculatedCrc=" + crc + "]");
        }
        encrypted.position(encrypted.position() - (this.encryptedDataSize() + 4));
        encrypted.limit(this.encryptedDataSize());
        this.encSpi.decryptNoPadding(encrypted, grpKey.key(), destBuf);
        destBuf.put(this.zeroes);
    }

    private void storeCRC(ByteBuffer res) {
        int encryptedDataSize = this.encryptedDataSize();
        int crc = FastCrc.calcCrc(res, encryptedDataSize);
        assert (res.position() == encryptedDataSize) : res.position();
        res.put(this.zeroes, 0, this.encSpi.blockSize());
        res.position(encryptedDataSize);
        res.put((byte)(crc >> 24));
        res.put((byte)(crc >> 16));
        res.put((byte)(crc >> 8));
        res.put((byte)crc);
    }

    public int encryptionOverhead() {
        return this.encryptionOverhead;
    }

    public int encryptedDataSize() {
        return this.pageSize - this.encSpi.blockSize();
    }

    public int plainDataSize() {
        return this.pageSize - this.encryptionOverhead;
    }

    private boolean tailIsEmpty(ByteBuffer src, int pageType) {
        int srcPos = src.position();
        src.position(srcPos + this.plainDataSize());
        for (int i = 0; i < this.encryptionOverhead; ++i) {
            assert (src.get() == 0) : "Tail of src should be empty [i=" + i + ", pageType=" + pageType + "]";
        }
        src.position(srcPos);
        return true;
    }
}

