/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxAbstractEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.DeadlockProbe;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersion;
import org.apache.ignite.internal.processors.cache.mvcc.ProbedTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.plugin.extensions.communication.Message;

public class DeadlockDetectionManager
extends GridCacheSharedManagerAdapter {
    private long detectionStartDelay;

    @Override
    protected void start0() throws IgniteCheckedException {
        this.detectionStartDelay = this.cctx.kernalContext().config().getTransactionConfiguration().getDeadlockTimeout();
        this.cctx.gridIO().addMessageListener(GridTopic.TOPIC_DEADLOCK_DETECTION, (nodeId, msg, plc) -> {
            if (msg instanceof DeadlockProbe) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received a probe message [msg=" + msg + ']');
                }
                DeadlockProbe msg0 = (DeadlockProbe)msg;
                this.handleDeadlockProbe(msg0);
            } else {
                this.log.warning("Unexpected message received [node=" + nodeId + ", msg=" + msg + ']');
            }
        });
    }

    public DelayedDeadlockComputation initDelayedComputation(MvccVersion waiterVer, MvccVersion blockerVer) {
        if (this.detectionStartDelay <= 0L) {
            return null;
        }
        return new DelayedDeadlockComputation(waiterVer, blockerVer, this.detectionStartDelay);
    }

    private void startComputation(MvccVersion waiterVer, MvccVersion blockerVer) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting deadlock detection [waiterVer=" + waiterVer + ", blockerVer=" + blockerVer + ']');
        }
        Optional<GridDhtTxLocalAdapter> waitingTx = this.findTx(waiterVer);
        Optional<GridDhtTxLocalAdapter> blockerTx = this.findTx(blockerVer);
        if (waitingTx.isPresent() && blockerTx.isPresent()) {
            GridDhtTxLocalAdapter wTx = waitingTx.get();
            GridDhtTxLocalAdapter bTx = blockerTx.get();
            this.sendProbe(bTx.eventNodeId(), wTx.xidVersion(), Collections.singleton(new ProbedTx(wTx.nodeId(), wTx.xidVersion(), wTx.nearXidVersion(), -1L, wTx.lockCounter())), new ProbedTx(bTx.nodeId(), bTx.xidVersion(), bTx.nearXidVersion(), -1L, bTx.lockCounter()), true);
        }
    }

    private Optional<GridDhtTxLocalAdapter> findTx(MvccVersion mvccVer) {
        return this.cctx.tm().activeTransactions().stream().filter(tx -> tx.local() && tx.mvccSnapshot() != null).filter(tx -> MvccUtils.belongToSameTx(mvccVer, tx.mvccSnapshot())).map(GridDhtTxLocalAdapter.class::cast).findAny();
    }

    private void handleDeadlockProbe(DeadlockProbe probe) {
        if (probe.nearCheck()) {
            this.handleDeadlockProbeForNear(probe);
        } else {
            this.handleDeadlockProbeForDht(probe);
        }
    }

    private void handleDeadlockProbeForNear(DeadlockProbe probe) {
        ProbedTx blocker = probe.blocker();
        GridNearTxLocal nearTx = (GridNearTxLocal)this.cctx.tm().tx(blocker.nearXidVersion());
        if (nearTx == null) {
            return;
        }
        for (UUID pendingNodeId : this.getPendingResponseNodes(nearTx)) {
            this.sendProbe(pendingNodeId, probe.initiatorVersion(), probe.waitChain(), blocker.withStartTime(nearTx.startTime()), false);
        }
    }

    private void handleDeadlockProbeForDht(DeadlockProbe probe) {
        this.cctx.tm().activeTransactions().stream().filter(IgniteInternalTx::local).filter(tx -> tx.nearXidVersion().equals(probe.blocker().nearXidVersion())).findAny().map(GridDhtTxLocalAdapter.class::cast).ifPresent(tx -> {
            Optional<ProbedTx> repeatedTx = probe.waitChain().stream().filter(wTx -> wTx.xidVersion().equals(tx.xidVersion())).findAny();
            if (repeatedTx.isPresent()) {
                this.resolveDeadlock(probe, repeatedTx.get(), (GridDhtTxLocalAdapter)tx);
            } else {
                this.relayProbeIfLocalTxIsWaiting(probe, (GridDhtTxLocalAdapter)tx);
            }
        });
    }

    private void resolveDeadlock(DeadlockProbe probe, ProbedTx repeatedTx, GridDhtTxLocalAdapter locTx) {
        ProbedTx victim;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deadlock detected [probe=" + probe + ']');
        }
        if ((victim = this.chooseVictim(repeatedTx.withStartTime(probe.blocker().startTime()), probe.waitChain())).xidVersion().equals(locTx.xidVersion())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Chosen victim is on local node, tx will be aborted [victim=" + victim + ']');
            }
            if (victim.lockCounter() == locTx.lockCounter()) {
                this.abortTx(locTx);
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Chosen victim is on remote node, message will be sent [victim=" + victim + ']');
            }
            this.sendProbe(victim.nodeId(), probe.initiatorVersion(), Collections.singleton(victim), victim, false);
        }
    }

    private void relayProbeIfLocalTxIsWaiting(DeadlockProbe probe, GridDhtTxLocalAdapter locTx) {
        assert (locTx.mvccSnapshot() != null);
        this.cctx.coordinators().checkWaiting(locTx.mvccSnapshot()).flatMap(this::findTx).ifPresent(nextBlocker -> {
            ArrayList<ProbedTx> waitChain = new ArrayList<ProbedTx>(probe.waitChain().size() + 1);
            waitChain.addAll(probe.waitChain());
            waitChain.add(new ProbedTx(locTx.nodeId(), locTx.xidVersion(), locTx.nearXidVersion(), probe.blocker().startTime(), locTx.lockCounter()));
            ProbedTx nextProbedTx = new ProbedTx(nextBlocker.nodeId(), nextBlocker.xidVersion(), nextBlocker.nearXidVersion(), -1L, nextBlocker.lockCounter());
            this.sendProbe(nextBlocker.eventNodeId(), probe.initiatorVersion(), waitChain, nextProbedTx, true);
        });
    }

    private ProbedTx chooseVictim(ProbedTx locTx, Collection<ProbedTx> waitChain) {
        Iterator<ProbedTx> it = waitChain.iterator();
        while (it.hasNext() && !it.next().xidVersion().equals(locTx.xidVersion())) {
        }
        ProbedTx victim = locTx;
        long maxStartTime = locTx.startTime();
        while (it.hasNext()) {
            ProbedTx tx = it.next();
            if (tx.startTime() > maxStartTime) {
                maxStartTime = tx.startTime();
                victim = tx;
                continue;
            }
            if (tx.startTime() != maxStartTime || tx.nearXidVersion().compareTo(victim.nearXidVersion()) <= 0) continue;
            victim = tx;
        }
        return victim;
    }

    private void abortTx(GridDhtTxLocalAdapter tx) {
        this.cctx.coordinators().failWaiter(tx.mvccSnapshot(), new IgniteTxRollbackCheckedException("Deadlock detected. Transaction will be rolled back [tx=" + tx + ']'));
    }

    private Set<UUID> getPendingResponseNodes(GridNearTxLocal tx) {
        IgniteInternalFuture<?> lockFut = tx.lockFuture();
        if (lockFut instanceof GridNearTxAbstractEnlistFuture) {
            return ((GridNearTxAbstractEnlistFuture)lockFut).pendingResponseNodes();
        }
        return Collections.emptySet();
    }

    private void sendProbe(UUID destNodeId, GridCacheVersion initiatorVer, Collection<ProbedTx> waitChain, ProbedTx blocker, boolean near) {
        DeadlockProbe probe = new DeadlockProbe(initiatorVer, waitChain, blocker, near);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending probe [probe=" + probe + ", destNode=" + destNodeId + ']');
        }
        try {
            this.cctx.gridIO().sendToGridTopic(destNodeId, GridTopic.TOPIC_DEADLOCK_DETECTION, (Message)probe, (byte)2);
        }
        catch (ClusterTopologyCheckedException clusterTopologyCheckedException) {
        }
        catch (IgniteCheckedException e) {
            this.log.warning("Failed to send a deadlock probe [nodeId=" + destNodeId + ']', e);
        }
    }

    public class DelayedDeadlockComputation
    extends GridTimeoutObjectAdapter {
        private final MvccVersion waiterVer;
        private final MvccVersion blockerVer;

        @Override
        public void onTimeout() {
            DeadlockDetectionManager.this.startComputation(this.waiterVer, this.blockerVer);
        }

        private DelayedDeadlockComputation(MvccVersion waiterVer, MvccVersion blockerVer, long timeout) {
            super(timeout);
            this.waiterVer = waiterVer;
            this.blockerVer = blockerVer;
            DeadlockDetectionManager.this.cctx.kernalContext().timeout().addTimeoutObject(this);
        }

        public void cancel() {
            DeadlockDetectionManager.this.cctx.kernalContext().timeout().removeTimeoutObject(this);
        }
    }
}

