/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicSingleUpdateRequest;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridNearAtomicSingleUpdateFilterRequest
extends GridNearAtomicSingleUpdateRequest {
    private static final long serialVersionUID = 0L;
    private CacheEntryPredicate[] filter;

    public GridNearAtomicSingleUpdateFilterRequest() {
    }

    GridNearAtomicSingleUpdateFilterRequest(int cacheId, UUID nodeId, long futId, @NotNull AffinityTopologyVersion topVer, CacheWriteSynchronizationMode syncMode, GridCacheOperation op, @Nullable CacheEntryPredicate[] filter, @Nullable UUID subjId, int taskNameHash, byte flags, boolean addDepInfo) {
        super(cacheId, nodeId, futId, topVer, syncMode, op, subjId, taskNameHash, flags, addDepInfo);
        assert (filter != null && filter.length > 0);
        this.filter = filter;
    }

    @Override
    @Nullable
    public CacheEntryPredicate[] filter() {
        return this.filter;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        if (this.filter != null) {
            boolean hasFilter = false;
            for (CacheEntryPredicate p : this.filter) {
                if (p == null) continue;
                hasFilter = true;
                p.prepareMarshal(cctx);
            }
            if (!hasFilter) {
                this.filter = null;
            }
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.filter != null) {
            GridCacheContext cctx = ctx.cacheContext(this.cacheId);
            for (CacheEntryPredicate p : this.filter) {
                if (p == null) continue;
                p.finishUnmarshal(cctx, ldr);
            }
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 13: {
                if (!writer.writeObjectArray("filter", this.filter, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 13: {
                this.filter = reader.readObjectArray("filter", MessageCollectionItemType.MSG, CacheEntryPredicate.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearAtomicSingleUpdateFilterRequest.class);
    }

    @Override
    public short directType() {
        return 127;
    }

    @Override
    public byte fieldsCount() {
        return 14;
    }

    @Override
    public String toString() {
        return S.toString(GridNearAtomicSingleUpdateFilterRequest.class, this, "filter", (Object)Arrays.toString(this.filter), "parent", (Object)super.toString());
    }
}

