/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheEntry;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.cache.CacheManager;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.QueryDetailMetrics;
import org.apache.ignite.cache.query.QueryMetrics;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.internal.AsyncSupportAdapter;
import org.apache.ignite.internal.GridKernalState;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheGateway;
import org.apache.ignite.internal.processors.cache.GridCacheProxyImpl;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxyImpl;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.mxbean.CacheMetricsMXBean;
import org.apache.ignite.transactions.TransactionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GatewayProtectedCacheProxy<K, V>
extends AsyncSupportAdapter<IgniteCache<K, V>>
implements IgniteCacheProxy<K, V> {
    private static final long serialVersionUID = 0L;
    private IgniteCacheProxy<K, V> delegate;
    @GridToStringExclude
    private boolean lock;
    private CacheOperationContext opCtx;

    public GatewayProtectedCacheProxy() {
    }

    public GatewayProtectedCacheProxy(@NotNull IgniteCacheProxy<K, V> delegate, @NotNull CacheOperationContext opCtx, boolean lock) {
        this.delegate = delegate;
        this.opCtx = opCtx;
        this.lock = lock;
    }

    public void setCacheManager(CacheManager cacheMgr) {
        if (this.delegate instanceof IgniteCacheProxyImpl) {
            ((IgniteCacheProxyImpl)this.delegate).setCacheManager(cacheMgr);
        }
    }

    @Override
    public GridCacheContext<K, V> context() {
        return this.delegate.context();
    }

    @Override
    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        return this.delegate.getConfiguration(clazz);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public javax.cache.CacheManager getCacheManager() {
        return this.delegate.getCacheManager();
    }

    @Override
    public GridCacheProxyImpl<K, V> internalProxy() {
        return this.delegate.internalProxy();
    }

    @Override
    public GatewayProtectedCacheProxy<K, V> cacheNoGate() {
        return new GatewayProtectedCacheProxy<K, V>(this.delegate, this.opCtx, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayProtectedCacheProxy<K, V> withExpiryPolicy(ExpiryPolicy plc) {
        CacheOperationGate opGate = this.onEnter();
        try {
            MvccUtils.verifyMvccOperationSupport(this.delegate.context(), "withExpiryPolicy");
            GatewayProtectedCacheProxy<K, V> gatewayProtectedCacheProxy = new GatewayProtectedCacheProxy<K, V>(this.delegate, this.opCtx.withExpiryPolicy(plc), this.lock);
            return gatewayProtectedCacheProxy;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public GatewayProtectedCacheProxy<K, V> withSkipStore() {
        return this.skipStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayProtectedCacheProxy<K, V> skipStore() {
        CacheOperationGate opGate = this.onEnter();
        try {
            boolean skip = this.opCtx.skipStore();
            if (skip) {
                GatewayProtectedCacheProxy gatewayProtectedCacheProxy = this;
                return gatewayProtectedCacheProxy;
            }
            GatewayProtectedCacheProxy<K, V> gatewayProtectedCacheProxy = new GatewayProtectedCacheProxy<K, V>(this.delegate, this.opCtx.setSkipStore(true), this.lock);
            return gatewayProtectedCacheProxy;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteCache<K, V> withAllowAtomicOpsInTx() {
        if (this.context().atomic() && !this.opCtx.allowedAtomicOpsInTx() && this.context().tm().tx() != null) {
            throw new IllegalStateException("Enabling atomic operations during active transaction is not allowed. Enable atomic operations before transaction start.");
        }
        CacheOperationGate opGate = this.onEnter();
        try {
            boolean allowed = this.opCtx.allowedAtomicOpsInTx();
            if (allowed) {
                GatewayProtectedCacheProxy gatewayProtectedCacheProxy = this;
                return gatewayProtectedCacheProxy;
            }
            GatewayProtectedCacheProxy<K, V> gatewayProtectedCacheProxy = new GatewayProtectedCacheProxy<K, V>(this.delegate, this.opCtx.setAllowAtomicOpsInTx(), this.lock);
            return gatewayProtectedCacheProxy;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayProtectedCacheProxy<K, V> withNoRetries() {
        CacheOperationGate opGate = this.onEnter();
        try {
            boolean noRetries = this.opCtx.noRetries();
            if (noRetries) {
                GatewayProtectedCacheProxy gatewayProtectedCacheProxy = this;
                return gatewayProtectedCacheProxy;
            }
            GatewayProtectedCacheProxy<K, V> gatewayProtectedCacheProxy = new GatewayProtectedCacheProxy<K, V>(this.delegate, this.opCtx.setNoRetries(true), this.lock);
            return gatewayProtectedCacheProxy;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayProtectedCacheProxy<K, V> withPartitionRecover() {
        CacheOperationGate opGate = this.onEnter();
        try {
            boolean recovery = this.opCtx.recovery();
            if (recovery) {
                GatewayProtectedCacheProxy gatewayProtectedCacheProxy = this;
                return gatewayProtectedCacheProxy;
            }
            GatewayProtectedCacheProxy<K, V> gatewayProtectedCacheProxy = new GatewayProtectedCacheProxy<K, V>(this.delegate, this.opCtx.setRecovery(true), this.lock);
            return gatewayProtectedCacheProxy;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public <K1, V1> GatewayProtectedCacheProxy<K1, V1> withKeepBinary() {
        return this.keepBinary();
    }

    @Override
    public <K1, V1> GatewayProtectedCacheProxy<K1, V1> keepBinary() {
        CacheOperationGate opGate = this.onEnter();
        try {
            GatewayProtectedCacheProxy<K, V> gatewayProtectedCacheProxy = new GatewayProtectedCacheProxy<K, V>(this.delegate, this.opCtx.keepBinary(), this.lock);
            return gatewayProtectedCacheProxy;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayProtectedCacheProxy<K, V> withDataCenterId(byte dataCenterId) {
        CacheOperationGate opGate = this.onEnter();
        try {
            Byte prevDataCenterId = this.opCtx.dataCenterId();
            if (prevDataCenterId != null && dataCenterId == prevDataCenterId) {
                GatewayProtectedCacheProxy gatewayProtectedCacheProxy = this;
                return gatewayProtectedCacheProxy;
            }
            GatewayProtectedCacheProxy<K, V> gatewayProtectedCacheProxy = new GatewayProtectedCacheProxy<K, V>(this.delegate, this.opCtx.setDataCenterId(dataCenterId), this.lock);
            return gatewayProtectedCacheProxy;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadCache(@Nullable IgniteBiPredicate<K, V> p, Object ... args) throws CacheException {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.loadCache(p, args);
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Void> loadCacheAsync(@Nullable IgniteBiPredicate<K, V> p, Object ... args) throws CacheException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Void> igniteFuture = this.delegate.loadCacheAsync(p, args);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void localLoadCache(@Nullable IgniteBiPredicate<K, V> p, Object ... args) throws CacheException {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.localLoadCache(p, args);
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Void> localLoadCacheAsync(@Nullable IgniteBiPredicate<K, V> p, Object ... args) throws CacheException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Void> igniteFuture = this.delegate.localLoadCacheAsync(p, args);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getAndPutIfAbsent(K key, V val) throws CacheException, TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            V v = this.delegate.getAndPutIfAbsent(key, val);
            return v;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<V> getAndPutIfAbsentAsync(K key, V val) throws CacheException, TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<V> igniteFuture = this.delegate.getAndPutIfAbsentAsync(key, val);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock lock(K key) {
        CacheOperationGate opGate = this.onEnter();
        try {
            Lock lock = this.delegate.lock(key);
            return lock;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public Lock lockAll(Collection<? extends K> keys) {
        return this.delegate.lockAll(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLocalLocked(K key, boolean byCurrThread) {
        CacheOperationGate opGate = this.onEnter();
        try {
            boolean bl = this.delegate.isLocalLocked(key, byCurrThread);
            return bl;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> QueryCursor<R> query(Query<R> qry) {
        CacheOperationGate opGate = this.onEnter();
        try {
            QueryCursor<R> queryCursor = this.delegate.query(qry);
            return queryCursor;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsQueryCursor<List<?>> query(SqlFieldsQuery qry) {
        CacheOperationGate opGate = this.onEnter();
        try {
            FieldsQueryCursor<List<?>> fieldsQueryCursor = this.delegate.query(qry);
            return fieldsQueryCursor;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FieldsQueryCursor<List<?>>> queryMultipleStatements(SqlFieldsQuery qry) {
        CacheOperationGate opGate = this.onEnter();
        try {
            List<FieldsQueryCursor<List<?>>> list = this.delegate.queryMultipleStatements(qry);
            return list;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, R> QueryCursor<R> query(Query<T> qry, IgniteClosure<T, R> transformer) {
        CacheOperationGate opGate = this.onEnter();
        try {
            QueryCursor<R> queryCursor = this.delegate.query(qry, transformer);
            return queryCursor;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Cache.Entry<K, V>> localEntries(CachePeekMode ... peekModes) throws CacheException {
        CacheOperationGate opGate = this.onEnter();
        try {
            Iterable iterable = this.delegate.localEntries(peekModes);
            return iterable;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public QueryMetrics queryMetrics() {
        CacheOperationGate opGate = this.onEnter();
        try {
            QueryMetrics queryMetrics = this.delegate.queryMetrics();
            return queryMetrics;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public void resetQueryMetrics() {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.resetQueryMetrics();
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public Collection<? extends QueryDetailMetrics> queryDetailMetrics() {
        CacheOperationGate opGate = this.onEnter();
        try {
            Collection<QueryDetailMetrics> collection = this.delegate.queryDetailMetrics();
            return collection;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public void resetQueryDetailMetrics() {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.resetQueryDetailMetrics();
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public void localEvict(Collection<? extends K> keys) {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.localEvict(keys);
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V localPeek(K key, CachePeekMode ... peekModes) {
        CacheOperationGate opGate = this.onEnter();
        try {
            Object v = this.delegate.localPeek(key, peekModes);
            return v;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(CachePeekMode ... peekModes) throws CacheException {
        CacheOperationGate opGate = this.onEnter();
        try {
            int n = this.delegate.size(peekModes);
            return n;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Integer> sizeAsync(CachePeekMode ... peekModes) throws CacheException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Integer> igniteFuture = this.delegate.sizeAsync(peekModes);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sizeLong(CachePeekMode ... peekModes) throws CacheException {
        CacheOperationGate opGate = this.onEnter();
        try {
            long l = this.delegate.sizeLong(peekModes);
            return l;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Long> sizeLongAsync(CachePeekMode ... peekModes) throws CacheException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Long> igniteFuture = this.delegate.sizeLongAsync(peekModes);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sizeLong(int partition, CachePeekMode ... peekModes) throws CacheException {
        CacheOperationGate opGate = this.onEnter();
        try {
            long l = this.delegate.sizeLong(partition, peekModes);
            return l;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Long> sizeLongAsync(int partition, CachePeekMode ... peekModes) throws CacheException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Long> igniteFuture = this.delegate.sizeLongAsync(partition, peekModes);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int localSize(CachePeekMode ... peekModes) {
        CacheOperationGate opGate = this.onEnter();
        try {
            int n = this.delegate.localSize(peekModes);
            return n;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long localSizeLong(CachePeekMode ... peekModes) {
        CacheOperationGate opGate = this.onEnter();
        try {
            long l = this.delegate.localSizeLong(peekModes);
            return l;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long localSizeLong(int partition, CachePeekMode ... peekModes) {
        CacheOperationGate opGate = this.onEnter();
        try {
            long l = this.delegate.localSizeLong(partition, peekModes);
            return l;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            Map map2 = this.delegate.invokeAll(map, args);
            return map2;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> IgniteFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Map<K, EntryProcessorResult<T>>> igniteFuture = this.delegate.invokeAllAsync(map, args);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            Object v = this.delegate.get(key);
            return v;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<V> getAsync(K key) {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture igniteFuture = this.delegate.getAsync(key);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheEntry<K, V> getEntry(K key) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            CacheEntry cacheEntry = this.delegate.getEntry(key);
            return cacheEntry;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<CacheEntry<K, V>> getEntryAsync(K key) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture igniteFuture = this.delegate.getEntryAsync(key);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, V> getAll(Set<? extends K> keys) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            Map map = this.delegate.getAll(keys);
            return map;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Map<K, V>> getAllAsync(Set<? extends K> keys) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Map<K, V>> igniteFuture = this.delegate.getAllAsync(keys);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CacheEntry<K, V>> getEntries(Set<? extends K> keys) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            Collection<CacheEntry<K, V>> collection = this.delegate.getEntries(keys);
            return collection;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Collection<CacheEntry<K, V>>> getEntriesAsync(Set<? extends K> keys) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Collection<CacheEntry<K, V>>> igniteFuture = this.delegate.getEntriesAsync(keys);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, V> getAllOutTx(Set<? extends K> keys) {
        CacheOperationGate opGate = this.onEnter();
        try {
            Map map = this.delegate.getAllOutTx(keys);
            return map;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Map<K, V>> getAllOutTxAsync(Set<? extends K> keys) {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Map<K, V>> igniteFuture = this.delegate.getAllOutTxAsync(keys);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(K key) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            boolean bl = this.delegate.containsKey(key);
            return bl;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadAll(Set<? extends K> keys, boolean replaceExisting, CompletionListener completionListener) {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.loadAll(keys, replaceExisting, completionListener);
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Boolean> containsKeyAsync(K key) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Boolean> igniteFuture = this.delegate.containsKeyAsync(key);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKeys(Set<? extends K> keys) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            boolean bl = this.delegate.containsKeys(keys);
            return bl;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Boolean> containsKeysAsync(Set<? extends K> keys) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Boolean> igniteFuture = this.delegate.containsKeysAsync(keys);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V val) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.put(key, val);
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Void> putAsync(K key, V val) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Void> igniteFuture = this.delegate.putAsync(key, val);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getAndPut(K key, V val) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            V v = this.delegate.getAndPut(key, val);
            return v;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<V> getAndPutAsync(K key, V val) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<V> igniteFuture = this.delegate.getAndPutAsync(key, val);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.putAll(map);
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Void> putAllAsync(Map<? extends K, ? extends V> map) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Void> igniteFuture = this.delegate.putAllAsync(map);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putIfAbsent(K key, V val) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            boolean bl = this.delegate.putIfAbsent(key, val);
            return bl;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Boolean> putIfAbsentAsync(K key, V val) {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Boolean> igniteFuture = this.delegate.putIfAbsentAsync(key, val);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            boolean bl = this.delegate.remove(key);
            return bl;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Boolean> removeAsync(K key) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Boolean> igniteFuture = this.delegate.removeAsync(key);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key, V oldVal) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            boolean bl = this.delegate.remove(key, oldVal);
            return bl;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Boolean> removeAsync(K key, V oldVal) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Boolean> igniteFuture = this.delegate.removeAsync(key, oldVal);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getAndRemove(K key) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            Object v = this.delegate.getAndRemove(key);
            return v;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<V> getAndRemoveAsync(K key) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture igniteFuture = this.delegate.getAndRemoveAsync(key);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldVal, V newVal) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            boolean bl = this.delegate.replace(key, oldVal, newVal);
            return bl;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Boolean> replaceAsync(K key, V oldVal, V newVal) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Boolean> igniteFuture = this.delegate.replaceAsync(key, oldVal, newVal);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V val) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            boolean bl = this.delegate.replace(key, val);
            return bl;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Boolean> replaceAsync(K key, V val) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Boolean> igniteFuture = this.delegate.replaceAsync(key, val);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getAndReplace(K key, V val) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            V v = this.delegate.getAndReplace(key, val);
            return v;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<V> getAndReplaceAsync(K key, V val) {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<V> igniteFuture = this.delegate.getAndReplaceAsync(key, val);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public void removeAll(Set<? extends K> keys) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.removeAll(keys);
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Void> removeAllAsync(Set<? extends K> keys) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Void> igniteFuture = this.delegate.removeAllAsync(keys);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public void removeAll() {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.removeAll();
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public IgniteFuture<Void> removeAllAsync() {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Void> igniteFuture = this.delegate.removeAllAsync();
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public void clear() {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.clear();
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public IgniteFuture<Void> clearAsync() {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Void> igniteFuture = this.delegate.clearAsync();
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public void clear(K key) {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.clear(key);
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Void> clearAsync(K key) {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Void> igniteFuture = this.delegate.clearAsync(key);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public void clearAll(Set<? extends K> keys) {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.clearAll(keys);
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Void> clearAllAsync(Set<? extends K> keys) {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Void> igniteFuture = this.delegate.clearAllAsync(keys);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public void localClear(K key) {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.localClear(key);
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public void localClearAll(Set<? extends K> keys) {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.localClearAll(keys);
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            T t = this.delegate.invoke(key, entryProcessor, arguments);
            return t;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> IgniteFuture<T> invokeAsync(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<T> igniteFuture = this.delegate.invokeAsync(key, entryProcessor, arguments);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invoke(K key, CacheEntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            T t = this.delegate.invoke(key, entryProcessor, arguments);
            return t;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> IgniteFuture<T> invokeAsync(K key, CacheEntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<T> igniteFuture = this.delegate.invokeAsync(key, entryProcessor, arguments);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            Map<? extends K, EntryProcessorResult<T>> map = this.delegate.invokeAll(keys, entryProcessor, args);
            return map;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> IgniteFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Map<K, EntryProcessorResult<T>>> igniteFuture = this.delegate.invokeAllAsync(keys, entryProcessor, args);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, CacheEntryProcessor<K, V, T> entryProcessor, Object ... args) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            Map<? extends K, EntryProcessorResult<T>> map = this.delegate.invokeAll(keys, entryProcessor, args);
            return map;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> IgniteFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Set<? extends K> keys, CacheEntryProcessor<K, V, T> entryProcessor, Object ... args) throws TransactionException {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Map<K, EntryProcessorResult<T>>> igniteFuture = this.delegate.invokeAllAsync(keys, entryProcessor, args);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return this.delegate.unwrap(clazz);
    }

    @Override
    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.registerCacheEntryListener(cacheEntryListenerConfiguration);
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.deregisterCacheEntryListener(cacheEntryListenerConfiguration);
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator() {
        CacheOperationGate opGate = this.onEnter();
        try {
            Iterator iterator = this.delegate.iterator();
            return iterator;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public void destroy() {
        IgniteFuture<?> destroyFuture;
        GridCacheGateway<K, V> gate = this.gate();
        if (!this.onEnterIfNoStop(gate)) {
            return;
        }
        try {
            destroyFuture = this.delegate.destroyAsync();
        }
        finally {
            this.onLeave(gate);
        }
        if (destroyFuture != null) {
            destroyFuture.get();
        }
    }

    @Override
    public IgniteFuture<?> destroyAsync() {
        return this.delegate.destroyAsync();
    }

    @Override
    public void close() {
        IgniteFuture<?> closeFuture;
        GridCacheGateway<K, V> gate = this.gate();
        if (!this.onEnterIfNoStop(gate)) {
            return;
        }
        try {
            closeFuture = this.closeAsync();
        }
        finally {
            this.onLeave(gate);
        }
        if (closeFuture != null) {
            closeFuture.get();
        }
    }

    @Override
    public IgniteFuture<?> closeAsync() {
        return this.delegate.closeAsync();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public IgniteFuture<Boolean> rebalance() {
        return this.delegate.rebalance();
    }

    @Override
    public IgniteFuture<?> indexReadyFuture() {
        return this.delegate.indexReadyFuture();
    }

    @Override
    public CacheMetrics metrics() {
        CacheOperationGate opGate = this.onEnter();
        try {
            CacheMetrics cacheMetrics = this.delegate.metrics();
            return cacheMetrics;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheMetrics metrics(ClusterGroup grp) {
        CacheOperationGate opGate = this.onEnter();
        try {
            CacheMetrics cacheMetrics = this.delegate.metrics(grp);
            return cacheMetrics;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public CacheMetrics localMetrics() {
        CacheOperationGate opGate = this.onEnter();
        try {
            CacheMetrics cacheMetrics = this.delegate.localMetrics();
            return cacheMetrics;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public CacheMetricsMXBean mxBean() {
        CacheOperationGate opGate = this.onEnter();
        try {
            CacheMetricsMXBean cacheMetricsMXBean = this.delegate.mxBean();
            return cacheMetricsMXBean;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public CacheMetricsMXBean localMxBean() {
        CacheOperationGate opGate = this.onEnter();
        try {
            CacheMetricsMXBean cacheMetricsMXBean = this.delegate.localMxBean();
            return cacheMetricsMXBean;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public Collection<Integer> lostPartitions() {
        CacheOperationGate opGate = this.onEnter();
        try {
            Collection<Integer> collection = this.delegate.lostPartitions();
            return collection;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public void enableStatistics(boolean enabled) {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.enableStatistics(enabled);
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public void clearStatistics() {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.clearStatistics();
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Override
    public void preloadPartition(int part) {
        CacheOperationGate opGate = this.onEnter();
        try {
            this.delegate.preloadPartition(part);
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Void> preloadPartitionAsync(int part) {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Void> igniteFuture = this.delegate.preloadPartitionAsync(part);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean localPreloadPartition(int part) {
        CacheOperationGate opGate = this.onEnter();
        try {
            boolean bl = this.delegate.localPreloadPartition(part);
            return bl;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int localEntrySize(K key) {
        CacheOperationGate opGate = this.onEnter();
        try {
            int n = this.delegate.localEntrySize(key);
            return n;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean touch(K key) {
        CacheOperationGate opGate = this.onEnter();
        try {
            boolean bl = this.delegate.touch(key);
            return bl;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Boolean> touchAsync(K key) {
        CacheOperationGate opGate = this.onEnter();
        try {
            IgniteFuture<Boolean> igniteFuture = this.delegate.touchAsync(key);
            return igniteFuture;
        }
        finally {
            this.onLeave(opGate);
        }
    }

    @Nullable
    private GridCacheGateway<K, V> gate() {
        GridCacheContext<K, V> cacheContext = this.delegate.context();
        return cacheContext != null ? cacheContext.gate() : null;
    }

    private GridCacheGateway<K, V> checkProxyIsValid(@Nullable GridCacheGateway<K, V> gate, boolean tryRestart) {
        if (this.isProxyClosed()) {
            throw new IllegalStateException("Cache has been closed: " + this.context().name());
        }
        boolean isCacheProxy = this.delegate instanceof IgniteCacheProxyImpl;
        if (isCacheProxy) {
            ((IgniteCacheProxyImpl)this.delegate).checkRestart();
        }
        if (gate == null) {
            throw new IllegalStateException("Gateway is unavailable. Probably cache has been destroyed, but proxy is not closed.");
        }
        if (isCacheProxy && tryRestart && gate.isStopped() && this.context().kernalContext().gateway().getState() == GridKernalState.STARTED) {
            IgniteCacheProxyImpl proxyImpl = (IgniteCacheProxyImpl)this.delegate;
            try {
                IgniteCacheProxy proxy = this.context().kernalContext().cache().publicJCache(this.context().name());
                if (proxy != null) {
                    proxyImpl.opportunisticRestart(proxy.internalProxy());
                    return this.gate();
                }
            }
            catch (IgniteCheckedException igniteCheckedException) {
                // empty catch block
            }
        }
        return gate;
    }

    private CacheOperationGate onEnter() {
        GridCacheGateway<K, V> gate = this.checkProxyIsValid(this.gate(), true);
        try {
            return new CacheOperationGate(gate, this.lock ? gate.enter(this.opCtx) : gate.enterNoLock(this.opCtx));
        }
        catch (IllegalStateException e) {
            boolean isCacheProxy = this.delegate instanceof IgniteCacheProxyImpl;
            if (isCacheProxy) {
                ((IgniteCacheProxyImpl)this.delegate).checkRestart(true);
            }
            throw e;
        }
    }

    private boolean onEnterIfNoStop(@Nullable GridCacheGateway<K, V> gate) {
        try {
            this.checkProxyIsValid(gate, false);
        }
        catch (Exception e) {
            return false;
        }
        return this.lock ? gate.enterIfNotStopped() : gate.enterIfNotStoppedNoLock();
    }

    private void onLeave(CacheOperationGate opGate) {
        if (this.lock) {
            opGate.gate.leave(opGate.prev);
        } else {
            opGate.gate.leaveNoLock(opGate.prev);
        }
    }

    private void onLeave(GridCacheGateway<K, V> gate) {
        if (this.lock) {
            gate.leave();
        } else {
            gate.leaveNoLock();
        }
    }

    @Override
    public boolean isProxyClosed() {
        return this.delegate.isProxyClosed();
    }

    @Override
    public void closeProxy() {
        this.delegate.closeProxy();
    }

    @Override
    public IgniteCache<K, V> withAsync() {
        return this.delegate.withAsync();
    }

    @Override
    public boolean isAsync() {
        return this.delegate.isAsync();
    }

    @Override
    public <R> IgniteFuture<R> future() {
        return this.delegate.future();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.delegate);
        out.writeBoolean(this.lock);
        out.writeObject(this.opCtx);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.delegate = (IgniteCacheProxy)in.readObject();
        this.lock = in.readBoolean();
        this.opCtx = (CacheOperationContext)in.readObject();
    }

    public boolean equals(Object another) {
        GatewayProtectedCacheProxy anotherProxy = (GatewayProtectedCacheProxy)another;
        return this.delegate.equals(anotherProxy.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    private class CacheOperationGate {
        public final GridCacheGateway<K, V> gate;
        public final CacheOperationContext prev;

        public CacheOperationGate(GridCacheGateway<K, V> gate, CacheOperationContext prev) {
            this.gate = gate;
            this.prev = prev;
        }
    }
}

