/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class CacheEntrySerializablePredicate
implements CacheEntryPredicate {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    @GridDirectTransient
    private CacheEntryPredicate p;
    private byte[] bytes;

    public CacheEntrySerializablePredicate() {
    }

    public CacheEntrySerializablePredicate(CacheEntryPredicate p) {
        assert (p != null);
        this.p = p;
    }

    public CacheEntryPredicate predicate() {
        return this.p;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public void entryLocked(boolean locked) {
        assert (this.p != null);
        this.p.entryLocked(locked);
    }

    @Override
    public void finishUnmarshal(GridCacheContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        assert (this.p != null || this.bytes != null);
        if (this.p == null) {
            this.p = (CacheEntryPredicate)U.unmarshal(ctx.marshaller(), this.bytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
            this.p.finishUnmarshal(ctx, ldr);
        }
    }

    @Override
    public void prepareMarshal(GridCacheContext ctx) throws IgniteCheckedException {
        assert (this.p != null);
        this.p.prepareMarshal(ctx);
        if (this.bytes == null) {
            this.bytes = U.marshal(ctx.marshaller(), (Object)this.p);
        }
    }

    @Override
    public boolean apply(GridCacheEntryEx e) {
        assert (this.p != null);
        return this.p.apply(e);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("bytes", this.bytes)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.bytes = reader.readByteArray("bytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CacheEntrySerializablePredicate.class);
    }

    @Override
    public short directType() {
        return 99;
    }

    @Override
    public byte fieldsCount() {
        return 1;
    }
}

