/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.deployment;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.compute.ComputeTaskName;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.deployment.GridDeploymentClassLoader;
import org.apache.ignite.internal.managers.deployment.GridDeploymentCommunication;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfo;
import org.apache.ignite.internal.managers.deployment.GridDeploymentLocalStore;
import org.apache.ignite.internal.managers.deployment.GridDeploymentMetadata;
import org.apache.ignite.internal.managers.deployment.GridDeploymentPerLoaderStore;
import org.apache.ignite.internal.managers.deployment.GridDeploymentPerVersionStore;
import org.apache.ignite.internal.managers.deployment.GridDeploymentStore;
import org.apache.ignite.internal.managers.deployment.protocol.gg.GridProtocolHandler;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.deployment.DeploymentSpi;
import org.apache.ignite.spi.deployment.IgnoreIfPeerClassLoadingDisabled;
import org.jetbrains.annotations.Nullable;

public class GridDeploymentManager
extends GridManagerAdapter<DeploymentSpi> {
    private GridDeploymentStore locStore;
    private GridDeploymentStore ldrStore;
    private GridDeploymentStore verStore;
    private GridDeploymentCommunication comm;
    private final GridDeployment locDep;

    public GridDeploymentManager(GridKernalContext ctx) {
        super(ctx, (IgniteSpi[])new DeploymentSpi[]{ctx.config().getDeploymentSpi()});
        DeploymentSpi spi;
        IgnoreIfPeerClassLoadingDisabled ann;
        this.locDep = !ctx.config().isPeerClassLoadingEnabled() ? ((ann = U.getAnnotation((spi = ctx.config().getDeploymentSpi()).getClass(), IgnoreIfPeerClassLoadingDisabled.class)) != null ? new LocalDeployment(ctx.config().getDeploymentMode(), ctx.config().getClassLoader() != null ? ctx.config().getClassLoader() : U.gridClassLoader(), IgniteUuid.fromUuid(ctx.localNodeId()), ctx.userVersion(U.gridClassLoader()), String.class.getName()) : null) : null;
    }

    @Override
    public void start() throws IgniteCheckedException {
        GridProtocolHandler.registerDeploymentManager(this);
        this.assertParameter(this.ctx.config().getDeploymentMode() != null, "ctx.config().getDeploymentMode() != null");
        if (this.ctx.config().isPeerClassLoadingEnabled()) {
            this.assertParameter(this.ctx.config().getNetworkTimeout() > 0L, "networkTimeout > 0");
        }
        this.startSpi();
        this.comm = new GridDeploymentCommunication(this.ctx, this.log);
        this.comm.start();
        this.startStores();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Local deployment: " + this.locDep);
            this.log.debug(this.startInfo());
        }
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
        this.storesOnKernalStop();
        this.storesStop();
        this.startStores();
    }

    @Override
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) throws IgniteCheckedException {
        this.storesOnKernalStart();
        return null;
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        GridProtocolHandler.deregisterDeploymentManager();
        this.storesStop();
        if (this.comm != null) {
            this.comm.stop();
        }
        ((DeploymentSpi)this.getSpi()).setListener(null);
        this.stopSpi();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    @Override
    public void onKernalStart0() throws IgniteCheckedException {
        this.storesOnKernalStart();
    }

    @Override
    public void onKernalStop0(boolean cancel) {
        this.storesOnKernalStop();
    }

    @Override
    public boolean enabled() {
        return super.enabled() && this.locDep == null;
    }

    public Map<String, Class<? extends ComputeTask<?, ?>>> findAllTasks(IgnitePredicate<? super Class<? extends ComputeTask<?, ?>>> ... p) {
        HashMap map = new HashMap();
        if (this.locDep != null) {
            this.tasks(map, this.locDep, p);
        } else {
            Collection<GridDeployment> deps = this.locStore.getDeployments();
            for (GridDeployment dep : deps) {
                this.tasks(map, dep, p);
            }
        }
        return map;
    }

    private void tasks(Map<String, Class<? extends ComputeTask<?, ?>>> map, GridDeployment dep, IgnitePredicate<? super Class<? extends ComputeTask<?, ?>>>[] p) {
        assert (map != null);
        assert (dep != null);
        for (Map.Entry<String, Class<?>> clsEntry : dep.deployedClassMap().entrySet()) {
            Class<?> taskCls;
            if (!ComputeTask.class.isAssignableFrom(clsEntry.getValue()) || !F.isAll(taskCls = clsEntry.getValue(), p)) continue;
            map.put(clsEntry.getKey(), taskCls);
        }
    }

    public void undeployTask(String taskName, boolean locUndeploy, Collection<ClusterNode> rmtNodes) {
        assert (taskName != null);
        assert (!rmtNodes.contains(this.ctx.discovery().localNode()));
        if (this.locDep == null) {
            if (locUndeploy) {
                this.locStore.explicitUndeploy(null, taskName);
            }
            try {
                this.comm.sendUndeployRequest(taskName, rmtNodes);
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to send undeployment request for task: " + taskName, e);
            }
        }
    }

    void undeployTask(UUID nodeId, String taskName) {
        assert (taskName != null);
        if (this.locDep != null) {
            U.warn(this.log, "Received unexpected undeploy request [nodeId=" + nodeId + ", taskName=" + taskName + ']');
            return;
        }
        this.locStore.explicitUndeploy(nodeId, taskName);
        this.ldrStore.explicitUndeploy(nodeId, taskName);
        this.verStore.explicitUndeploy(nodeId, taskName);
    }

    @Nullable
    public GridDeployment deploy(Class<?> cls, ClassLoader clsLdr) throws IgniteCheckedException {
        String clsName;
        String lambdaParent;
        if (clsLdr == null) {
            clsLdr = this.getClass().getClassLoader();
        }
        if ((lambdaParent = U.lambdaEnclosingClassName(clsName = cls.getName())) != null) {
            clsName = lambdaParent;
            try {
                cls = Class.forName(clsName, true, clsLdr);
            }
            catch (ClassNotFoundException e) {
                throw new IgniteCheckedException("Cannot deploy parent class for lambda: " + clsName, e);
            }
        }
        if (clsLdr instanceof GridDeploymentClassLoader) {
            GridDeploymentInfo ldr = (GridDeploymentInfo)((Object)clsLdr);
            if (!(ldr.deployMode() != DeploymentMode.ISOLATED && ldr.deployMode() != DeploymentMode.PRIVATE || this.ctx.config().getDeploymentMode() != DeploymentMode.SHARED && this.ctx.config().getDeploymentMode() != DeploymentMode.CONTINUOUS || U.hasAnnotation(cls, GridInternal.class))) {
                throw new IgniteCheckedException("Attempt to deploy class loaded in ISOLATED or PRIVATE mode on node with SHARED or CONTINUOUS deployment mode [cls=" + cls + ", clsDeployMode=" + (Object)((Object)ldr.deployMode()) + ", localDeployMode=" + (Object)((Object)this.ctx.config().getDeploymentMode()) + ']');
            }
            GridDeploymentMetadata meta = new GridDeploymentMetadata();
            meta.alias(clsName);
            meta.classLoader(clsLdr);
            GridDeployment dep = this.checkDeployment(this.locStore.getDeployment(meta), "local");
            if (dep == null && (dep = this.checkDeployment(this.ldrStore.getDeployment(ldr.classLoaderId()), "perLoader")) == null) {
                dep = this.checkDeployment(this.verStore.getDeployment(ldr.classLoaderId()), "perVersion");
            }
            return dep;
        }
        if (this.locDep != null) {
            ComputeTaskName taskNameAnn;
            if (ComputeTask.class.isAssignableFrom(cls) && (taskNameAnn = this.locDep.annotation(cls, ComputeTaskName.class)) != null) {
                this.locDep.addDeployedClass(cls, taskNameAnn.value());
            }
            return this.locDep;
        }
        return this.locStore.explicitDeploy(cls, clsLdr);
    }

    private GridDeployment checkDeployment(GridDeployment deployment, String store) {
        if (deployment != null && deployment.participants() == null && !this.ctx.discovery().localNode().id().equals(deployment.classLoaderId().globalId())) {
            this.log.warning("Possibly incorrect deployment detected in '" + store + "', can't be used to deserialize message on target node, participants=null, localNodeId=" + this.ctx.discovery().localNode().id() + ", deployment=" + deployment);
        }
        return deployment;
    }

    @Nullable
    public GridDeployment getDeployment(IgniteUuid ldrId) {
        if (this.locDep != null) {
            return this.locDep.classLoaderId().equals(ldrId) ? this.locDep : null;
        }
        GridDeployment dep = this.locStore.getDeployment(ldrId);
        if (dep == null && (dep = this.ldrStore.getDeployment(ldrId)) == null) {
            dep = this.verStore.getDeployment(ldrId);
        }
        return dep;
    }

    @Nullable
    public GridDeployment getDeployment(String rsrcName) {
        GridDeploymentInfo depLdr;
        ClassLoader ldr;
        if (this.locDep != null) {
            return this.locDep;
        }
        GridDeployment dep = this.getLocalDeployment(rsrcName);
        if (dep == null && (ldr = Thread.currentThread().getContextClassLoader()) instanceof GridDeploymentClassLoader && (dep = this.ldrStore.getDeployment((depLdr = (GridDeploymentInfo)((Object)ldr)).classLoaderId())) == null) {
            dep = this.verStore.getDeployment(depLdr.classLoaderId());
        }
        return dep;
    }

    @Nullable
    public GridDeployment getLocalDeployment(String rsrcName) {
        if (this.locDep != null) {
            return this.locDep;
        }
        String lambdaEnclosingClsName = U.lambdaEnclosingClassName(rsrcName);
        String clsName = lambdaEnclosingClsName == null ? rsrcName : lambdaEnclosingClsName;
        GridDeploymentMetadata meta = new GridDeploymentMetadata();
        meta.record(true);
        meta.deploymentMode(this.ctx.config().getDeploymentMode());
        meta.alias(rsrcName);
        meta.className(clsName);
        meta.senderNodeId(this.ctx.localNodeId());
        return this.locStore.getDeployment(meta);
    }

    @Nullable
    public GridDeployment getGlobalDeployment(DeploymentMode depMode, String rsrcName, String clsName, String userVer, UUID sndNodeId, IgniteUuid clsLdrId, Map<UUID, IgniteUuid> participants, @Nullable IgnitePredicate<ClusterNode> nodeFilter) {
        if (this.locDep != null) {
            return this.locDep;
        }
        String lambdaEnclosingClsName = U.lambdaEnclosingClassName(clsName);
        if (lambdaEnclosingClsName != null) {
            clsName = lambdaEnclosingClsName;
        }
        GridDeploymentMetadata meta = new GridDeploymentMetadata();
        meta.deploymentMode(depMode);
        meta.className(clsName);
        meta.alias(rsrcName);
        meta.userVersion(userVer);
        meta.senderNodeId(sndNodeId);
        meta.classLoaderId(clsLdrId);
        meta.participants(participants);
        meta.nodeFilter(nodeFilter);
        if (!this.ctx.config().isPeerClassLoadingEnabled()) {
            meta.record(true);
            return this.locStore.getDeployment(meta);
        }
        if (this.isPerVersionMode(meta.deploymentMode())) {
            GridDeployment dep;
            String[] p2pExc;
            meta.record(true);
            boolean reuse = true;
            if (!sndNodeId.equals(this.ctx.localNodeId()) && (p2pExc = this.ctx.config().getPeerClassLoadingLocalClassPathExclude()) != null) {
                for (String rsrc : p2pExc) {
                    if (rsrc.endsWith("*")) {
                        rsrc = rsrc.substring(0, rsrc.length() - 1);
                    }
                    if (!meta.alias().startsWith(rsrc) && !meta.className().startsWith(rsrc)) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Will not reuse local deployment because resource is excluded [meta=" + meta + ']');
                    }
                    reuse = false;
                    break;
                }
            }
            if ((dep = this.verStore.searchDeploymentCache(meta)) != null) {
                return dep;
            }
            if (reuse) {
                GridDeployment locDep = this.locStore.getDeployment(meta);
                if (locDep == null && participants != null && participants.containsKey(this.ctx.localNodeId())) {
                    locDep = this.locStore.getDeployment(participants.get(this.ctx.localNodeId()));
                }
                if (locDep != null) {
                    if (!this.isPerVersionMode(locDep.deployMode())) {
                        U.warn(this.log, "Failed to deploy class in SHARED or CONTINUOUS mode (class is locally deployed in some other mode). Either change IgniteConfiguration.getDeploymentMode() property to SHARED or CONTINUOUS or remove class from local classpath and any of the local GAR deployments that may have it [cls=" + meta.className() + ", depMode=" + (Object)((Object)locDep.deployMode()) + ']');
                        return null;
                    }
                    if (!locDep.userVersion().equals(meta.userVersion())) {
                        U.warn(this.log, "Failed to deploy class in SHARED or CONTINUOUS mode for given user version (class is locally deployed for a different user version) [cls=" + meta.className() + ", localVer=" + locDep.userVersion() + ", otherVer=" + meta.userVersion() + ']');
                        return null;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Reusing local deployment for SHARED or CONTINUOUS mode: " + locDep);
                    }
                    return locDep;
                }
            }
            return this.verStore.getDeployment(meta);
        }
        meta.record(false);
        GridDeployment dep = this.ldrStore.searchDeploymentCache(meta);
        if (dep != null) {
            return dep;
        }
        dep = this.locStore.getDeployment(meta);
        if (sndNodeId.equals(this.ctx.localNodeId())) {
            if (dep == null) {
                U.warn(this.log, "Task got undeployed while deployment was in progress: " + meta);
            }
            return dep;
        }
        if (dep != null) {
            meta.parentLoader(dep.classLoader());
        }
        meta.record(true);
        return this.ldrStore.getDeployment(meta);
    }

    public void addCacheParticipants(Map<UUID, IgniteUuid> allParticipants, Map<UUID, IgniteUuid> addedParticipants) {
        this.verStore.addParticipants(allParticipants, addedParticipants);
    }

    private boolean isPerVersionMode(DeploymentMode mode) {
        return mode == DeploymentMode.CONTINUOUS || mode == DeploymentMode.SHARED;
    }

    @Nullable
    public IgniteUuid getClassLoaderId(ClassLoader ldr) {
        assert (ldr != null);
        return ldr instanceof GridDeploymentClassLoader ? ((GridDeploymentInfo)((Object)ldr)).classLoaderId() : null;
    }

    public boolean isGlobalLoader(ClassLoader ldr) {
        return ldr instanceof GridDeploymentClassLoader;
    }

    private void startStores() throws IgniteCheckedException {
        this.locStore = new GridDeploymentLocalStore((DeploymentSpi)this.getSpi(), this.ctx, this.comm);
        this.ldrStore = new GridDeploymentPerLoaderStore((DeploymentSpi)this.getSpi(), this.ctx, this.comm);
        this.verStore = new GridDeploymentPerVersionStore((DeploymentSpi)this.getSpi(), this.ctx, this.comm);
        this.locStore.start();
        this.ldrStore.start();
        this.verStore.start();
    }

    private void storesOnKernalStart() throws IgniteCheckedException {
        this.locStore.onKernalStart();
        this.ldrStore.onKernalStart();
        this.verStore.onKernalStart();
    }

    private void storesOnKernalStop() {
        if (this.verStore != null) {
            this.verStore.onKernalStop();
        }
        if (this.ldrStore != null) {
            this.ldrStore.onKernalStop();
        }
        if (this.locStore != null) {
            this.locStore.onKernalStop();
        }
    }

    private void storesStop() {
        if (this.verStore != null) {
            this.verStore.stop();
        }
        if (this.ldrStore != null) {
            this.ldrStore.stop();
        }
        if (this.locStore != null) {
            this.locStore.stop();
        }
    }

    private static class LocalDeployment
    extends GridDeployment {
        private LocalDeployment(DeploymentMode depMode, ClassLoader clsLdr, IgniteUuid clsLdrId, String userVer, String sampleClsName) {
            super(depMode, clsLdr, clsLdrId, userVer, sampleClsName, true);
        }

        @Override
        public boolean undeployed() {
            return false;
        }

        @Override
        public void undeploy() {
        }

        @Override
        public boolean pendingUndeploy() {
            return false;
        }

        @Override
        public void onUndeployScheduled() {
        }

        @Override
        public boolean acquire() {
            return true;
        }

        @Override
        public void release() {
        }

        @Override
        public boolean obsolete() {
            return false;
        }

        @Override
        @Nullable
        public Map<UUID, IgniteUuid> participants() {
            return null;
        }

        @Override
        public String toString() {
            return S.toString(LocalDeployment.class, this, super.toString());
        }
    }
}

